/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem.cast;

import com.google.common.base.Objects;
import io.sarl.lang.sarl.SarlPackage;
import io.sarl.lang.typesystem.cast.AmbiguousCastOperatorLinkingCandidate;
import io.sarl.lang.typesystem.cast.ICastOperatorLinkingCandidate;
import io.sarl.lang.typesystem.cast.Messages;
import io.sarl.lang.typesystem.cast.SuspiciousOverloadedCastOperatorLinkingCandidate;
import io.sarl.lang.util.Utils;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractPendingLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class CastOperatorLinkingCandidate
extends AbstractPendingLinkingCandidate<XCastedExpression>
implements ICastOperatorLinkingCandidate {
    private XExpression receiver;
    private XExpression argument;
    private boolean hasLinkingOperation;

    public CastOperatorLinkingCandidate(XCastedExpression expression, IIdentifiableElementDescription description, ITypeExpectation expectation, ExpressionTypeComputationState state) {
        super((XExpression)expression, description, expectation, state);
    }

    protected ExpressionTypeComputationState getState() {
        return super.getState();
    }

    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        CastOperatorLinkingCandidate right = (CastOperatorLinkingCandidate)other;
        CandidateCompareResult candidateCompareResult = this.compareTo(right);
        switch (candidateCompareResult.ordinal()) {
            case 3: {
                return this.createAmbiguousLinkingCandidate(right);
            }
            case 2: {
                return this.createSuspiciousLinkingCandidate(right);
            }
            case 0: 
            case 4: {
                return this;
            }
            case 1: {
                return other;
            }
        }
        throw new IllegalStateException();
    }

    private static boolean isSame(LightweightTypeReference first, LightweightTypeReference second) {
        return Objects.equal((Object)first.getIdentifier(), (Object)second.getIdentifier());
    }

    private static int computeCompliance(LightweightTypeReference target, LightweightTypeReference current) {
        if (CastOperatorLinkingCandidate.isSame(target, current)) {
            return 0;
        }
        LightweightTypeReference target2 = target.getWrapperTypeIfPrimitive();
        if (target2.isSubtypeOf(Number.class)) {
            LightweightTypeReference current2 = current.getWrapperTypeIfPrimitive();
            if (current2.isSubtypeOf(Number.class)) {
                return 1 + Math.max(CastOperatorLinkingCandidate.getNumberPrecision(target) - CastOperatorLinkingCandidate.getNumberPrecision(current), 0);
            }
            if (target.isAssignableFrom(current)) {
                return 8;
            }
            return 9;
        }
        if (target.isAssignableFrom(current)) {
            return 1;
        }
        return 2;
    }

    private static int getNumberPrecision(LightweightTypeReference type) {
        switch (type.getPrimitiveIfWrapperType().getSimpleName()) {
            case "byte": {
                return 0;
            }
            case "short": {
                return 1;
            }
            case "int": 
            case "AtomicInteger": {
                return 2;
            }
            case "long": 
            case "AtomicLong": {
                return 3;
            }
            case "float": {
                return 4;
            }
            case "double": 
            case "AtomicDouble": {
                return 5;
            }
        }
        return 6;
    }

    private CandidateCompareResult compareTo(CastOperatorLinkingCandidate right) {
        int rightSourceCompliance;
        int rightCompliance;
        int leftSourceCompliance;
        int leftCompliance;
        boolean invalid = false;
        CandidateCompareResult result = this.compareWithObjectType(right);
        switch (result.ordinal()) {
            case 2: {
                throw new IllegalStateException();
            }
            case 4: {
                invalid = true;
                break;
            }
            case 0: 
            case 1: {
                return result;
            }
        }
        LightweightTypeReference sourceType = this.getActualType(((XCastedExpression)this.getExpression()).getTarget());
        LightweightTypeReference leftSourceType = this.getOperationParameterType(this);
        LightweightTypeReference rightSourceType = this.getOperationParameterType(right);
        LightweightTypeReference targetType = this.getState().getReferenceOwner().toLightweightTypeReference(((XCastedExpression)this.getExpression()).getType());
        LightweightTypeReference leftTargetType = this.getOperationReturnType(this);
        LightweightTypeReference rightTargetType = this.getOperationReturnType(right);
        int leftTargetCompliance = CastOperatorLinkingCandidate.computeCompliance(targetType, leftTargetType);
        int rightTargetCompliance = CastOperatorLinkingCandidate.computeCompliance(targetType, rightTargetType);
        if (leftTargetCompliance == 0) {
            if (rightTargetCompliance != 0) {
                return CandidateCompareResult.THIS;
            }
        } else if (rightTargetCompliance == 0) {
            return CandidateCompareResult.OTHER;
        }
        if ((leftCompliance = (leftSourceCompliance = CastOperatorLinkingCandidate.computeCompliance(sourceType, leftSourceType)) + leftTargetCompliance) < (rightCompliance = (rightSourceCompliance = CastOperatorLinkingCandidate.computeCompliance(sourceType, rightSourceType)) + rightTargetCompliance)) {
            return CandidateCompareResult.THIS;
        }
        if (leftCompliance > rightCompliance) {
            return CandidateCompareResult.OTHER;
        }
        result = CastOperatorLinkingCandidate.compareByArityOverride(this.getArityMismatch(), right.getArityMismatch());
        switch (result.ordinal()) {
            case 2: {
                throw new IllegalStateException();
            }
            case 4: {
                invalid = true;
                break;
            }
            case 0: 
            case 1: {
                return result;
            }
        }
        return invalid ? CandidateCompareResult.EQUALLY_INVALID : CandidateCompareResult.AMBIGUOUS;
    }

    private CandidateCompareResult compareWithObjectType(CastOperatorLinkingCandidate right) {
        boolean meIsObject;
        JvmOperation operation = right.getOperation();
        boolean otherIsObject = operation != null && Objects.equal((Object)operation.getDeclaringType().getIdentifier(), (Object)Object.class.getName());
        operation = this.getOperation();
        boolean bl = meIsObject = operation != null && Objects.equal((Object)operation.getDeclaringType().getIdentifier(), (Object)Object.class.getName());
        if (otherIsObject != meIsObject) {
            if (otherIsObject) {
                return CandidateCompareResult.THIS;
            }
            return CandidateCompareResult.OTHER;
        }
        return CandidateCompareResult.AMBIGUOUS;
    }

    private static CandidateCompareResult compareByArityOverride(int leftArityMismatch, int rightArityMismatch) {
        if (leftArityMismatch != rightArityMismatch) {
            if (leftArityMismatch == 0) {
                return CandidateCompareResult.THIS;
            }
            if (rightArityMismatch == 0) {
                return CandidateCompareResult.OTHER;
            }
            if (Math.abs(leftArityMismatch) < Math.abs(rightArityMismatch)) {
                return CandidateCompareResult.THIS;
            }
            if (Math.abs(leftArityMismatch) > Math.abs(rightArityMismatch)) {
                return CandidateCompareResult.OTHER;
            }
            if (leftArityMismatch < 0) {
                return CandidateCompareResult.THIS;
            }
            if (rightArityMismatch < 0) {
                return CandidateCompareResult.OTHER;
            }
        }
        return leftArityMismatch == 0 ? CandidateCompareResult.AMBIGUOUS : CandidateCompareResult.EQUALLY_INVALID;
    }

    private LightweightTypeReference getOperationReturnType(CastOperatorLinkingCandidate candidate) {
        return this.getState().getReferenceOwner().toLightweightTypeReference(candidate.getOperation().getReturnType());
    }

    private LightweightTypeReference getOperationParameterType(CastOperatorLinkingCandidate candidate) {
        JvmOperation operation = candidate.getOperation();
        if (operation.getParameters().isEmpty()) {
            return this.getState().getReferenceOwner().toLightweightTypeReference((JvmType)operation.getDeclaringType());
        }
        return this.getState().getReferenceOwner().toLightweightTypeReference(((JvmFormalParameter)operation.getParameters().get(0)).getParameterType());
    }

    public boolean isExtension() {
        return this.description.isExtension();
    }

    public boolean isTypeLiteral() {
        return this.description.isTypeLiteral();
    }

    protected boolean hasReceiver() {
        return !this.description.isStatic();
    }

    @Override
    public XExpression getReceiver() {
        this.ensureLinkingOperation();
        return this.receiver;
    }

    @Override
    public XExpression getArgument() {
        this.ensureLinkingOperation();
        return this.argument;
    }

    protected String getFeatureTypeName() {
        return "cast";
    }

    protected List<XExpression> getArguments() {
        return Collections.emptyList();
    }

    protected List<JvmTypeReference> getPlainSyntacticTypeArguments() {
        return Collections.emptyList();
    }

    protected ILinkingCandidate createAmbiguousLinkingCandidate(AbstractPendingLinkingCandidate<?> second) {
        return new AmbiguousCastOperatorLinkingCandidate(this, second);
    }

    protected ILinkingCandidate createSuspiciousLinkingCandidate(AbstractPendingLinkingCandidate<?> chosenCandidate) {
        return new SuspiciousOverloadedCastOperatorLinkingCandidate((CastOperatorLinkingCandidate)chosenCandidate, this);
    }

    public void applyToModel(IResolvedTypes resolvedTypes) {
        XCastedExpression expr = (XCastedExpression)this.getExpression();
        if (expr.eClass().isSuperTypeOf(SarlPackage.eINSTANCE.getSarlCastedExpression())) {
            Utils.setStructuralFeature((EObject)expr, (EStructuralFeature)SarlPackage.Literals.SARL_CASTED_EXPRESSION__FEATURE, this.getFeature());
            Utils.setStructuralFeature((EObject)expr, (EStructuralFeature)SarlPackage.Literals.SARL_CASTED_EXPRESSION__RECEIVER, this.getReceiver());
            Utils.setStructuralFeature((EObject)expr, (EStructuralFeature)SarlPackage.Literals.SARL_CASTED_EXPRESSION__ARGUMENT, this.getArgument());
        }
    }

    @Override
    public JvmOperation getOperation() {
        return (JvmOperation)this.getFeature();
    }

    public String getValidationDescription() {
        JvmOperation feature = this.getOperation();
        String message = null;
        message = !this.getDeclaredTypeParameters().isEmpty() ? MessageFormat.format(Messages.CastOperatorLinkingCandidate_0, this.getFeatureTypeParametersAsString(true), feature.getSimpleName(), this.getFeatureParameterTypesAsString(), feature.getDeclaringType().getSimpleName()) : MessageFormat.format(Messages.CastOperatorLinkingCandidate_1, feature.getSimpleName(), this.getFeatureParameterTypesAsString(), feature.getDeclaringType().getSimpleName());
        return message;
    }

    protected void ensureLinkingOperation() {
        if (!this.hasLinkingOperation) {
            this.hasLinkingOperation = true;
            XExpression target = ((XCastedExpression)this.getExpression()).getTarget();
            if (!this.hasReceiver()) {
                this.receiver = null;
                this.argument = target;
            } else if (this.getOperation().getParameters().isEmpty()) {
                this.receiver = target;
                this.argument = null;
            } else {
                this.argument = target;
                XExpression obj1 = this.description.getSyntacticReceiver();
                XExpression obj2 = this.description.getImplicitFirstArgument();
                XExpression obj3 = this.description.getImplicitReceiver();
                this.receiver = obj1 != null && obj1 != target ? obj1 : (obj2 != null && obj2 != target ? obj2 : (obj3 != target ? obj3 : null));
            }
        }
    }

    private static enum CandidateCompareResult {
        THIS,
        OTHER,
        SUSPICIOUS_OTHER,
        AMBIGUOUS,
        EQUALLY_INVALID;

    }
}

