/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem.cast;

import com.google.common.collect.Lists;
import io.sarl.lang.sarl.SarlCastedExpression;
import io.sarl.lang.sarl.SarlPackage;
import io.sarl.lang.typesystem.cast.CastOperatorLinkingCandidate;
import io.sarl.lang.typesystem.cast.CastScopeSession;
import io.sarl.lang.typesystem.cast.ICastOperationCandidateSelector;
import io.sarl.lang.util.ReflectMethod;
import io.sarl.lang.util.Utils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.AbstractFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class CastedExpressionTypeComputationState
extends ExpressionTypeComputationState {
    private static ReflectMethod<ResolvedTypes, StackedResolvedTypes> pushTypesMethod = ReflectMethod.of(ResolvedTypes.class, StackedResolvedTypes.class, "pushTypes");
    private final CastScopeSession castScopeSession;
    private final ICastOperationCandidateSelector candidateValidator;

    public CastedExpressionTypeComputationState(SarlCastedExpression expression, AbstractTypeComputationState delegate, ICastOperationCandidateSelector candidateValidator) {
        super((StackedResolvedTypes)delegate.getResolvedTypes(), delegate.getFeatureScopeSession(), delegate, (XExpression)expression);
        this.candidateValidator = candidateValidator;
        this.castScopeSession = new CastScopeSession((AbstractFeatureScopeSession)delegate.getFeatureScopeSession());
    }

    private StackedResolvedTypes pushTypes() {
        return pushTypesMethod.invoke((ResolvedTypes)this.getStackedResolvedTypes(), new Object[0]);
    }

    public boolean isCastOperatorLinkingEnabled(SarlCastedExpression cast) {
        LightweightTypeReference sourceType = this.getStackedResolvedTypes().getReturnType(cast.getTarget());
        LightweightTypeReference destinationType = this.getReferenceOwner().toLightweightTypeReference(cast.getType());
        if (sourceType.isPrimitiveVoid() || destinationType.isPrimitiveVoid()) {
            return false;
        }
        if (sourceType.isPrimitive() && destinationType.isPrimitive()) {
            return false;
        }
        return !sourceType.isSubtypeOf(destinationType.getType());
    }

    public List<? extends ILinkingCandidate> getLinkingCandidates(SarlCastedExpression cast) {
        StackedResolvedTypes demandComputedTypes = this.pushTypes();
        final AbstractTypeComputationState forked = this.withNonVoidExpectation((ResolvedTypes)demandComputedTypes);
        ForwardingResolvedTypes demandResolvedTypes = new ForwardingResolvedTypes(this){

            protected IResolvedTypes delegate() {
                return forked.getResolvedTypes();
            }

            public LightweightTypeReference getActualType(XExpression expression) {
                LightweightTypeReference type = super.getActualType(expression);
                if (type == null) {
                    ITypeComputationResult result = forked.computeTypes(expression);
                    return result.getActualExpressionType();
                }
                return type;
            }
        };
        IScope scope = this.getCastScopeSession().getScope((EObject)cast, SarlPackage.Literals.SARL_CASTED_EXPRESSION__FEATURE, (IResolvedTypes)demandResolvedTypes);
        LightweightTypeReference targetType = this.getReferenceOwner().toLightweightTypeReference(cast.getType());
        ArrayList resultList = Lists.newArrayList();
        LightweightTypeReference expressionType = this.getStackedResolvedTypes().getActualType(cast.getTarget());
        ICastOperationCandidateSelector.ISelector validator = this.candidateValidator.prepare(this.getParent(), targetType, expressionType);
        for (IEObjectDescription description : scope.getAllElements()) {
            ExpressionAwareStackedResolvedTypes descriptionResolvedTypes;
            ExpressionTypeComputationState descriptionState;
            ILinkingCandidate candidate;
            IIdentifiableElementDescription idesc = this.toIdentifiableDescription(description);
            if (!validator.isCastOperatorCandidate(idesc) || (candidate = this.createCandidate(cast, descriptionState = this.createExpressionComputationState((XExpression)cast, (StackedResolvedTypes)(descriptionResolvedTypes = this.pushTypes((XExpression)cast))), idesc)) == null) continue;
            resultList.add(candidate);
        }
        return resultList;
    }

    public CastScopeSession getCastScopeSession() {
        return this.castScopeSession;
    }

    protected ILinkingCandidate createCandidate(SarlCastedExpression cast, ExpressionTypeComputationState state, IIdentifiableElementDescription description) {
        return new CastOperatorLinkingCandidate(cast, description, this.getSingleExpectation((ITypeComputationState)state), state);
    }

    public void resetFeature(SarlCastedExpression object) {
        Utils.setStructuralFeature((EObject)object, (EStructuralFeature)SarlPackage.Literals.SARL_CASTED_EXPRESSION__FEATURE, null);
        Utils.setStructuralFeature((EObject)object, (EStructuralFeature)SarlPackage.Literals.SARL_CASTED_EXPRESSION__RECEIVER, null);
        Utils.setStructuralFeature((EObject)object, (EStructuralFeature)SarlPackage.Literals.SARL_CASTED_EXPRESSION__ARGUMENT, null);
    }
}

