/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem.cast;

import com.google.inject.Singleton;
import io.sarl.lang.typesystem.cast.ICastOperationCandidateSelector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

@Singleton
public class ObjectAndPrimitiveBasedCastOperationCandidateSelector
implements ICastOperationCandidateSelector {
    @Override
    public ICastOperationCandidateSelector.ISelector prepare(AbstractTypeComputationState state, LightweightTypeReference castType, LightweightTypeReference expressionType) {
        return new ObjectAndPrimitiveBasedSelector(state, castType, expressionType);
    }

    protected static class ObjectAndPrimitiveBasedSelector
    implements ICastOperationCandidateSelector.ISelector {
        private static final String CLASS_PREFIX = "to";
        private static final String PRIMITIVE_POSTFIX = "Value";
        private final AbstractTypeComputationState state;
        private final LightweightTypeReference castType;
        private final LightweightTypeReference primitiveCastType;
        private final LightweightTypeReference expressionType;
        private final boolean primitiveCast;

        protected ObjectAndPrimitiveBasedSelector(AbstractTypeComputationState state, LightweightTypeReference castType, LightweightTypeReference expressionType) {
            this.state = state;
            this.castType = castType.getWrapperTypeIfPrimitive();
            this.primitiveCastType = castType.getPrimitiveIfWrapperType();
            this.expressionType = expressionType;
            this.primitiveCast = castType.isPrimitive() || castType.isWrapper();
        }

        protected String getValidClassSimpleName(String name) {
            String nm;
            if (name.startsWith(CLASS_PREFIX) && !Strings.isEmpty((String)(nm = Strings.toFirstUpper((String)name.substring(CLASS_PREFIX.length()))))) {
                return nm;
            }
            return null;
        }

        protected String getValidPrimitiveSimpleName(String name) {
            String nm;
            if (this.primitiveCast && name.endsWith(PRIMITIVE_POSTFIX) && !Strings.isEmpty((String)(nm = name.substring(0, name.length() - PRIMITIVE_POSTFIX.length()).toLowerCase()))) {
                return nm;
            }
            return null;
        }

        protected boolean isValidReturnType(String expectedTypeName, LightweightTypeReference type) {
            if (type != null && (type.isSubtypeOf(this.castType.getType()) || this.primitiveCast && type.isSubtypeOf(this.primitiveCastType.getType()))) {
                return type.getSimpleName().equals(expectedTypeName);
            }
            return false;
        }

        protected boolean isValidParameters(JvmOperation operation) {
            EList parameters = operation.getParameters();
            if (parameters.size() == 0) {
                JvmDeclaredType originType = operation.getDeclaringType();
                return this.expressionType.isSubtypeOf((JvmType)originType);
            }
            if (parameters.size() == 1) {
                JvmTypeReference parameterType = ((JvmFormalParameter)parameters.get(0)).getParameterType();
                LightweightTypeReference paramType = this.state.getReferenceOwner().toLightweightTypeReference(parameterType);
                if (parameterType != null) {
                    return paramType.isAssignableFrom(this.expressionType);
                }
            }
            return false;
        }

        private boolean validatePrototype(String expectedTypeName, JvmOperation operation) {
            LightweightTypeReference concreteReturnType = this.state.getResolvedTypes().getActualType((JvmIdentifiableElement)operation);
            if (this.isValidReturnType(expectedTypeName, concreteReturnType)) {
                return this.isValidParameters(operation);
            }
            return false;
        }

        @Override
        public boolean isCastOperatorCandidate(IIdentifiableElementDescription description) {
            if (description instanceof ScopeProviderAccess.ErrorDescription || !description.isVisible()) {
                return false;
            }
            JvmIdentifiableElement operatorFunction = description.getElementOrProxy();
            if (operatorFunction instanceof JvmOperation) {
                JvmOperation executable = (JvmOperation)operatorFunction;
                String objectTypeName = this.getValidClassSimpleName(executable.getSimpleName());
                if (objectTypeName != null) {
                    return this.validatePrototype(objectTypeName, executable);
                }
                String primitiveTypeName = this.getValidPrimitiveSimpleName(executable.getSimpleName());
                if (primitiveTypeName != null) {
                    return this.validatePrototype(primitiveTypeName, executable);
                }
            }
            return false;
        }
    }
}

