/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.util;

import java.lang.reflect.Field;

public final class ReflectField<RT, T> {
    private final Class<RT> receiverType;
    private final Class<T> returnType;
    private final String fieldName;
    private Field field;

    protected ReflectField(Class<RT> receiverType, Class<T> returnType, String fieldName) {
        this.receiverType = receiverType;
        this.returnType = returnType;
        this.fieldName = fieldName;
    }

    public static <RT, T> ReflectField<RT, T> of(Class<RT> receiverType, Class<T> returnType, String fieldName) {
        return new ReflectField<RT, T>(receiverType, returnType, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(RT receiver) {
        Field field;
        ReflectField reflectField = this;
        synchronized (reflectField) {
            field = this.field == null ? (this.field = this.getField(receiver)) : this.field;
        }
        try {
            return this.returnType.cast(field.get(receiver));
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
    }

    public T get() {
        return this.get(null);
    }

    private Field getField(RT receiver) {
        try {
            Class<RT> clazz = this.receiverType;
            Field compatible = null;
            do {
                for (Field candidate : clazz.getDeclaredFields()) {
                    if (candidate == null || !this.isCompatible(candidate, this.fieldName)) continue;
                    if (compatible != null) {
                        throw new IllegalStateException("Ambiguous field to access. Both " + String.valueOf(compatible) + " and " + String.valueOf(candidate) + " would be compatible choices.");
                    }
                    compatible = candidate;
                }
                clazz = clazz.getSuperclass();
            } while (compatible == null && clazz != null);
            if (compatible != null) {
                compatible.setAccessible(true);
                return compatible;
            }
            if (receiver != null) {
                return receiver.getClass().getField(this.fieldName);
            }
            return this.receiverType.getField(this.fieldName);
        }
        catch (Throwable exception) {
            throw new Error(exception);
        }
    }

    private boolean isCompatible(Field candidate, String featureName) {
        if (!candidate.getName().equals(featureName)) {
            return false;
        }
        Class<?> class1 = candidate.getType();
        if (class1.isPrimitive()) {
            class1 = ReflectField.wrapperTypeFor(class1);
        }
        return this.returnType.isAssignableFrom(class1);
    }

    private static Class<?> wrapperTypeFor(Class<?> primitive) {
        assert (primitive != null);
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException(String.valueOf(primitive) + " is not a primitive");
    }
}

