/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.util;

import java.lang.reflect.Method;

public final class ReflectMethod<RT, T> {
    private final Class<RT> receiverType;
    private final Class<T> returnType;
    private final String methodName;
    private Method method;

    protected ReflectMethod(Class<RT> receiverType, Class<T> returnType, String methodName) {
        this.receiverType = receiverType;
        this.returnType = returnType;
        this.methodName = methodName;
    }

    public static <RT, T> ReflectMethod<RT, T> of(Class<RT> receiverType, Class<T> returnType, String methodName) {
        return new ReflectMethod<RT, T>(receiverType, returnType, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T invoke(RT receiver, Object ... arguments) {
        Method method;
        assert (receiver != null);
        ReflectMethod reflectMethod = this;
        synchronized (reflectMethod) {
            method = this.method == null ? (this.method = this.getMethod(receiver, arguments)) : this.method;
        }
        try {
            return this.returnType.cast(method.invoke(receiver, arguments));
        }
        catch (Error | RuntimeException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new RuntimeException(exception);
        }
    }

    private Method getMethod(RT receiver, Object[] args) {
        try {
            Object[] objectArray;
            if (args == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = null;
            } else {
                objectArray = args;
            }
            Object[] arguments = objectArray;
            Class<RT> clazz = this.receiverType;
            Method compatible = null;
            do {
                for (Method candidate : clazz.getDeclaredMethods()) {
                    if (candidate == null || candidate.isBridge() || !ReflectMethod.isCompatible(candidate, this.methodName, arguments)) continue;
                    if (compatible != null) {
                        throw new IllegalStateException("Ambiguous methods to invoke. Both " + String.valueOf(compatible) + " and " + String.valueOf(candidate) + " would be compatible choices.");
                    }
                    compatible = candidate;
                }
                clazz = clazz.getSuperclass();
            } while (compatible == null && clazz != null);
            if (compatible != null) {
                compatible.setAccessible(true);
                return compatible;
            }
            Class[] paramTypes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                paramTypes[i] = arguments[i] == null ? Object.class : arguments[i].getClass();
            }
            return receiver.getClass().getMethod(this.methodName, paramTypes);
        }
        catch (Throwable exception) {
            throw new Error(exception);
        }
    }

    private static boolean isCompatible(Method candidate, String featureName, Object ... args) {
        if (!candidate.getName().equals(featureName)) {
            return false;
        }
        if (candidate.getParameterTypes().length != args.length) {
            return false;
        }
        for (int i = 0; i < candidate.getParameterTypes().length; ++i) {
            Object param = args[i];
            Class<?> class1 = candidate.getParameterTypes()[i];
            if (class1.isPrimitive()) {
                class1 = ReflectMethod.wrapperTypeFor(class1);
            }
            if (param == null || class1.isInstance(param)) continue;
            return false;
        }
        return true;
    }

    private static Class<?> wrapperTypeFor(Class<?> primitive) {
        assert (primitive != null);
        if (primitive == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitive == Byte.TYPE) {
            return Byte.class;
        }
        if (primitive == Character.TYPE) {
            return Character.class;
        }
        if (primitive == Short.TYPE) {
            return Short.class;
        }
        if (primitive == Integer.TYPE) {
            return Integer.class;
        }
        if (primitive == Long.TYPE) {
            return Long.class;
        }
        if (primitive == Float.TYPE) {
            return Float.class;
        }
        if (primitive == Double.TYPE) {
            return Double.class;
        }
        if (primitive == Void.TYPE) {
            return Void.class;
        }
        throw new IllegalArgumentException(String.valueOf(primitive) + " is not a primitive");
    }
}

