/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.util;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.sarl.lang.core.SARLVersion;
import io.sarl.lang.core.annotation.EarlyExit;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.util.JvmIdentifiableComparator;
import io.sarl.lang.util.JvmTypeReferenceComparator;
import io.sarl.lang.util.Messages;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstraintOwner;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.JvmWildcardTypeReference;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.EmfFormatter;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xtype.XFunctionTypeRef;
import org.eclipse.xtext.xtype.XtypeFactory;
import org.osgi.framework.Version;

public final class Utils {
    private static final String STATIC_CONSTRUCTOR_NAME = "static$new";
    private static final String PREFIX_DEFAULT_VALUE_FUNCTION = "$DEFAULT_VALUE$";
    private static final String PREFIX_CAPACITY_IMPLEMENTATION = "$CAPACITY_USE$";
    private static final String POSTFIX_CAPACITY_IMPLEMENTATION_CALLER = "$CALLER";
    private static final String PREFIX_GUARD_EVALUATOR = "$guardEvaluator$";
    private static final String PREFIX_GUARD = "$behaviorUnitGuard$";
    private static final String PREFIX_EVENT_HANDLER = "$behaviorUnit$";
    private static final String PREFIX_LOCAL_VARIABLE = "___SARLlocal_";
    private static final String HIDDEN_MEMBER_REPLACEMENT_CHARACTER = "_";
    private static final String SARL_PACKAGE_PREFIX;
    private static final String SARL_VERSION_FIELD_NAME_STR = "SPECIFICATION_RELEASE_VERSION_STRING";
    private static boolean checkSarlVersionClass;
    private static final Pattern IMPLICIT_LAMBDA_PARAMETER_PATTERN;
    private static final String JAVA_MAIN_FUNCTION_NAME = "main";

    private Utils() {
    }

    public static boolean isNameForJavaMainFunction(String name) {
        return Objects.equal((Object)JAVA_MAIN_FUNCTION_NAME, (Object)name);
    }

    public static String getNameForJavaMainFunction() {
        return JAVA_MAIN_FUNCTION_NAME;
    }

    public static boolean isMainFunctionDeclaration(XtendFunction function, CommonTypeComputationServices services) {
        LightweightTypeReference retType;
        return Utils.isMainFunctionDeclarationExcludingReturnType(function, services) && ((retType = Utils.toLightweightTypeReference(function.getReturnType(), services)) == null || retType.isPrimitiveVoid());
    }

    public static boolean isMainFunctionDeclarationExcludingReturnType(XtendFunction function, CommonTypeComputationServices services) {
        if (Utils.isNameForJavaMainFunction(function.getName()) && function.isStatic() && !function.isDispatch() && function.getParameters().size() == 1) {
            XtendParameter providedArg = (XtendParameter)function.getParameters().get(0);
            LightweightTypeReference argType = Utils.toLightweightTypeReference(providedArg.getParameterType(), services);
            boolean isVarArgsFromSource = Utils.isVarArg((List<? extends XtendParameter>)function.getParameters());
            if (!isVarArgsFromSource && argType.isArray()) {
                argType = argType.getComponentType();
            }
            return argType.isType(String.class);
        }
        return false;
    }

    @Pure
    public static boolean isDynamicDefaultValueFunctionName(String name) {
        return name != null && name.startsWith(PREFIX_DEFAULT_VALUE_FUNCTION);
    }

    @Pure
    public static boolean isStaticConstructorName(String name) {
        return STATIC_CONSTRUCTOR_NAME.equals(name);
    }

    @Pure
    public static String getStaticConstructorName() {
        return STATIC_CONSTRUCTOR_NAME;
    }

    public static void populateInterfaceElements(JvmDeclaredType jvmElement, Map<ActionPrototype, JvmOperation> operations, Map<String, JvmField> fields, IActionPrototypeProvider sarlSignatureProvider) {
        for (JvmFeature feature : jvmElement.getAllFeatures()) {
            if ("java.lang.Object".equals(feature.getDeclaringType().getQualifiedName())) continue;
            if (operations != null && feature instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)feature;
                ActionParameterTypes sig = sarlSignatureProvider.createParameterTypesFromJvmModel(operation.isVarArgs(), (List<JvmFormalParameter>)operation.getParameters());
                ActionPrototype actionKey = sarlSignatureProvider.createActionPrototype(operation.getSimpleName(), sig);
                operations.put(actionKey, operation);
                continue;
            }
            if (fields == null || !(feature instanceof JvmField)) continue;
            fields.put(feature.getSimpleName(), (JvmField)feature);
        }
    }

    public static void populateInheritanceContext(JvmDeclaredType jvmElement, Map<ActionPrototype, JvmOperation> finalOperations, Map<ActionPrototype, JvmOperation> overridableOperations, Map<String, JvmField> inheritedFields, Map<ActionPrototype, JvmOperation> operationsToImplement, Map<ActionParameterTypes, JvmConstructor> superConstructors, IActionPrototypeProvider sarlSignatureProvider) {
        Utils.populateInheritanceContext(jvmElement, jvmElement.getExtendedClass(), jvmElement.getExtendedInterfaces(), finalOperations, overridableOperations, inheritedFields, operationsToImplement, superConstructors, sarlSignatureProvider);
    }

    public static void populateInheritanceContext(JvmDeclaredType jvmElement, JvmTypeReference extendedClass, Iterable<? extends JvmTypeReference> extendedInterfaces, Map<ActionPrototype, JvmOperation> finalOperations, Map<ActionPrototype, JvmOperation> overridableOperations, Map<String, JvmField> inheritedFields, Map<ActionPrototype, JvmOperation> operationsToImplement, Map<ActionParameterTypes, JvmConstructor> superConstructors, IActionPrototypeProvider sarlSignatureProvider) {
        JvmType extendedClassJvmType;
        if (operationsToImplement != null && extendedInterfaces != null) {
            for (JvmTypeReference jvmTypeReference : extendedInterfaces) {
                JvmType interfaceReferenceType = jvmTypeReference.getType();
                if (!(interfaceReferenceType instanceof JvmGenericType)) continue;
                JvmGenericType cvalue = (JvmGenericType)interfaceReferenceType;
                for (JvmFeature feature : cvalue.getAllFeatures()) {
                    if ("java.lang.Object".equals(feature.getDeclaringType().getQualifiedName()) || !(feature instanceof JvmOperation)) continue;
                    JvmOperation operation = (JvmOperation)feature;
                    ActionParameterTypes sig = sarlSignatureProvider.createParameterTypesFromJvmModel(operation.isVarArgs(), (List<JvmFormalParameter>)operation.getParameters());
                    ActionPrototype actionKey = sarlSignatureProvider.createActionPrototype(operation.getSimpleName(), sig);
                    if (operation.isDefault()) {
                        if (overridableOperations == null) continue;
                        overridableOperations.put(actionKey, operation);
                        continue;
                    }
                    if (operationsToImplement == null) continue;
                    operationsToImplement.put(actionKey, operation);
                }
            }
        }
        if (extendedClass != null && (extendedClassJvmType = extendedClass.getType()) instanceof JvmGenericType) {
            JvmGenericType jvmGenericType = (JvmGenericType)extendedClassJvmType;
            for (JvmFeature feature : jvmGenericType.getAllFeatures()) {
                if ("java.lang.Object".equals(feature.getDeclaringType().getQualifiedName()) || !Utils.isVisible(jvmElement, (JvmMember)feature) || SarlUtils.isHiddenMember((String)feature.getSimpleName())) continue;
                if (feature instanceof JvmOperation) {
                    JvmOperation operation = (JvmOperation)feature;
                    if (feature.isStatic()) continue;
                    ActionParameterTypes sig = sarlSignatureProvider.createParameterTypesFromJvmModel(operation.isVarArgs(), (List<JvmFormalParameter>)operation.getParameters());
                    ActionPrototype actionKey = sarlSignatureProvider.createActionPrototype(feature.getSimpleName(), sig);
                    if (operation.isAbstract() && !operation.isDefault()) {
                        if (operationsToImplement == null) continue;
                        operationsToImplement.put(actionKey, operation);
                        continue;
                    }
                    if (operation.isFinal()) {
                        if (finalOperations != null) {
                            finalOperations.put(actionKey, operation);
                        }
                        if (operationsToImplement == null) continue;
                        operationsToImplement.remove(actionKey);
                        continue;
                    }
                    if (overridableOperations != null) {
                        overridableOperations.put(actionKey, operation);
                    }
                    if (operationsToImplement == null) continue;
                    operationsToImplement.remove(actionKey);
                    continue;
                }
                if (!(feature instanceof JvmField)) continue;
                JvmField cvalue = (JvmField)feature;
                if (inheritedFields == null) continue;
                inheritedFields.put(feature.getSimpleName(), cvalue);
            }
            if (superConstructors != null) {
                for (JvmConstructor cons : jvmGenericType.getDeclaredConstructors()) {
                    ActionParameterTypes sig = sarlSignatureProvider.createParameterTypesFromJvmModel(cons.isVarArgs(), (List<JvmFormalParameter>)cons.getParameters());
                    superConstructors.put(sig, cons);
                }
            }
        }
    }

    public static boolean isVisible(JvmDeclaredType fromType, JvmMember target) {
        switch (target.getVisibility()) {
            case DEFAULT: {
                return target.getDeclaringType().getPackageName().equals(fromType.getPackageName());
            }
            case PROTECTED: 
            case PUBLIC: {
                return true;
            }
        }
        return false;
    }

    public static boolean isVarArg(List<? extends XtendParameter> params) {
        assert (params != null);
        if (params.size() > 0) {
            XtendParameter param = params.get(params.size() - 1);
            assert (param != null);
            return param.isVarArg();
        }
        return false;
    }

    public static boolean isImplicitLambdaParameterName(String name) {
        return IMPLICIT_LAMBDA_PARAMETER_PATTERN.matcher(name).matches();
    }

    public static String fixHiddenMember(String name) {
        return name.replaceAll(Pattern.quote("$"), Matcher.quoteReplacement(HIDDEN_MEMBER_REPLACEMENT_CHARACTER));
    }

    public static String createNameForHiddenDefaultValueFunction(String id) {
        return PREFIX_DEFAULT_VALUE_FUNCTION + Utils.fixHiddenMember(id.toUpperCase());
    }

    public static String createNameForHiddenCapacityImplementationAttribute(String id) {
        return PREFIX_CAPACITY_IMPLEMENTATION + Utils.fixHiddenMember(id.toUpperCase()).replace(".", HIDDEN_MEMBER_REPLACEMENT_CHARACTER);
    }

    public static String createNameForHiddenCapacityImplementationCallingMethodFromFieldName(String capacityImplementationFieldName) {
        return capacityImplementationFieldName + POSTFIX_CAPACITY_IMPLEMENTATION_CALLER;
    }

    public static boolean isNameForHiddenCapacityImplementationCallingMethod(String simpleName) {
        return simpleName != null && simpleName.startsWith(PREFIX_CAPACITY_IMPLEMENTATION) && simpleName.endsWith(POSTFIX_CAPACITY_IMPLEMENTATION_CALLER);
    }

    public static String createNameForHiddenLocalVariable(String id) {
        return PREFIX_LOCAL_VARIABLE + Utils.fixHiddenMember(id);
    }

    private static StringBuilder buildNameForHiddenEventMethod(JvmParameterizedTypeReference eventId, String prefix, boolean appendTypeSimpleName, boolean forceTypeParameterBoundsInName) {
        StringBuilder fullName = new StringBuilder(prefix);
        StringBuilder fullName0 = new StringBuilder();
        TypeParameterStatus result = Utils.forEachTypeParameterName(eventId, (name, i) -> {
            fullName0.append("$").append("$");
            if (name == null) {
                fullName0.append(Utils.fixHiddenMember(Object.class.getSimpleName()));
            } else {
                fullName0.append(Utils.fixHiddenMember(name.getSimpleName()));
            }
        });
        if (result == null) {
            if (appendTypeSimpleName) {
                fullName.append(Utils.fixHiddenMember(eventId.getSimpleName()));
            }
        } else {
            if (appendTypeSimpleName) {
                fullName.append(Utils.fixHiddenMember(eventId.getType().getSimpleName()));
            }
            if (forceTypeParameterBoundsInName || result.isBoundInFunctionName()) {
                fullName.append((CharSequence)fullName0);
            }
        }
        return fullName;
    }

    public static String createNameForHiddenGuardGeneralEvaluatorMethod(JvmParameterizedTypeReference eventId) {
        return Utils.buildNameForHiddenEventMethod(eventId, PREFIX_GUARD_EVALUATOR, true, true).toString();
    }

    public static String createNameForHiddenGuardEvaluatorMethod(JvmParameterizedTypeReference eventId, int handlerIndex) {
        StringBuilder fullName = Utils.buildNameForHiddenEventMethod(eventId, PREFIX_GUARD, true, false);
        fullName.append("$").append(handlerIndex);
        return fullName.toString();
    }

    public static String createNameForHiddenEventHandlerMethod(JvmParameterizedTypeReference eventId, int handlerIndex) {
        StringBuilder fullName = Utils.buildNameForHiddenEventMethod(eventId, PREFIX_EVENT_HANDLER, true, false);
        fullName.append("$").append(handlerIndex);
        return fullName.toString();
    }

    public static boolean isClass(LightweightTypeReference typeRef) {
        JvmType t = typeRef.getType();
        if (t instanceof JvmGenericType) {
            JvmGenericType cvalue = (JvmGenericType)t;
            return !cvalue.isInterface();
        }
        return false;
    }

    public static boolean isClass(Class<?> type) {
        return !type.isInterface();
    }

    public static boolean isFinal(LightweightTypeReference expressionTypeRef) {
        JvmDeclaredType cvalue;
        if (expressionTypeRef.isArray()) {
            return Utils.isFinal(expressionTypeRef.getComponentType());
        }
        if (expressionTypeRef.isPrimitive()) {
            return true;
        }
        JvmType jvmType = expressionTypeRef.getType();
        return jvmType instanceof JvmDeclaredType && (cvalue = (JvmDeclaredType)jvmType).isFinal();
    }

    public static boolean isFinal(Class<?> expressionType) {
        if (expressionType.isArray()) {
            return Utils.isFinal(expressionType.getComponentType());
        }
        if (expressionType.isPrimitive()) {
            return true;
        }
        return expressionType.isEnum() || Modifier.isFinal(expressionType.getModifiers());
    }

    public static boolean isInterface(LightweightTypeReference type) {
        JvmGenericType cvalue;
        JvmType jvmType = type.getType();
        return jvmType instanceof JvmGenericType && (cvalue = (JvmGenericType)jvmType).isInterface();
    }

    public static boolean canCast(LightweightTypeReference fromType, LightweightTypeReference toType, boolean enablePrimitiveWidening, boolean enableVoidMatchingNull, boolean allowSynonyms) {
        if (enableVoidMatchingNull) {
            boolean toVoid;
            boolean fromVoid = fromType == null || fromType.isPrimitiveVoid();
            boolean bl = toVoid = toType == null || toType.isPrimitiveVoid();
            if (fromVoid) {
                return toVoid;
            }
            if (toVoid) {
                return fromVoid;
            }
            assert (fromType != null);
            assert (toType != null);
        } else if (fromType == null || toType == null || fromType.isPrimitiveVoid() != toType.isPrimitiveVoid()) {
            return false;
        }
        TypeConformanceComputationArgument conform = new TypeConformanceComputationArgument(false, false, true, enablePrimitiveWidening, false, allowSynonyms);
        assert (fromType != null);
        return (!(fromType.getType() instanceof JvmDeclaredType) && !fromType.isPrimitive() || Utils.isInterface(fromType) && !Utils.isFinal(toType) || Utils.isInterface(toType) && !Utils.isFinal(fromType) || toType.isAssignableFrom(fromType, conform) || !Utils.isFinal(fromType) && !Utils.isFinal(toType) && (!Utils.isClass(fromType) || !Utils.isClass(toType)) || fromType.isAssignableFrom(toType, conform)) && (!toType.isPrimitive() || fromType.isPrimitive() || fromType.isWrapper());
    }

    private static ResourceSet getResoutceSet(EObject object) {
        if (object == null) {
            return null;
        }
        Resource r = object.eResource();
        if (r == null) {
            return null;
        }
        return r.getResourceSet();
    }

    public static LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, CommonTypeComputationServices services) {
        return Utils.toLightweightTypeReference(typeRef, services, Utils.getResoutceSet((EObject)typeRef), false);
    }

    public static LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, CommonTypeComputationServices services, ResourceSet context) {
        return Utils.toLightweightTypeReference(typeRef, services, context, false);
    }

    public static LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, CommonTypeComputationServices services, boolean keepUnboundWildcardInformation) {
        return Utils.toLightweightTypeReference(typeRef, services, Utils.getResoutceSet((EObject)typeRef), keepUnboundWildcardInformation);
    }

    public static LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, CommonTypeComputationServices services, ResourceSet context, boolean keepUnboundWildcardInformation) {
        if (typeRef == null) {
            return null;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(services, context);
        LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory((ITypeReferenceOwner)owner, keepUnboundWildcardInformation);
        LightweightTypeReference reference = factory.toLightweightReference(typeRef);
        return reference;
    }

    public static LightweightTypeReference toLightweightTypeReference(JvmType type, CommonTypeComputationServices services) {
        return Utils.toLightweightTypeReference(type, services, false);
    }

    public static LightweightTypeReference toLightweightTypeReference(JvmType type, CommonTypeComputationServices services, boolean keepUnboundWildcardInformation) {
        if (type == null) {
            return null;
        }
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(services, (EObject)type);
        LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory((ITypeReferenceOwner)owner, keepUnboundWildcardInformation);
        LightweightTypeReference reference = factory.toLightweightReference(type);
        return reference;
    }

    @Deprecated(since="0.13", forRemoval=true)
    public static int compareVersions(String v1, String v2) {
        Version vobject1 = Utils.parseVersion(v1);
        Version vobject2 = Utils.parseVersion(v2);
        return vobject1.compareTo(vobject2);
    }

    public static int compareMajorMinorVersions(String v1, String v2) {
        Version vobject1 = Utils.parseVersion(v1);
        Version vo1 = new Version(vobject1.getMajor(), vobject1.getMinor(), 0);
        Version vobject2 = Utils.parseVersion(v2);
        Version vo2 = new Version(vobject2.getMajor(), vobject2.getMinor(), 0);
        return vo1.compareTo(vo2);
    }

    private static void addAnnotationToSignature(StringBuilder textRepresentation, SARLGrammarKeywordAccess elements, ISerializer serializer, ImportManager importManager, XAnnotation annotation) {
        textRepresentation.append(elements.getCommercialAtKeyword());
        textRepresentation.append(Utils.getSignatureType(annotation.getAnnotationType(), importManager));
        XExpression value = annotation.getValue();
        if (value != null) {
            textRepresentation.append(elements.getLeftParenthesisKeyword());
            textRepresentation.append(serializer.serialize((EObject)value).trim());
            textRepresentation.append(elements.getRightParenthesisKeyword());
        } else if (!annotation.getElementValuePairs().isEmpty()) {
            textRepresentation.append(elements.getLeftParenthesisKeyword());
            boolean addComa = false;
            for (XAnnotationElementValuePair pair : annotation.getElementValuePairs()) {
                if (addComa) {
                    textRepresentation.append(elements.getCommaKeyword());
                } else {
                    addComa = true;
                }
                textRepresentation.append(elements.getEqualsSignKeyword());
                textRepresentation.append(serializer.serialize((EObject)pair.getValue()).trim());
            }
            textRepresentation.append(elements.getRightParenthesisKeyword());
        }
    }

    public static String getSarlCodeFor(EObject object) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)object);
        if (node != null) {
            String text = node.getText();
            if (text != null) {
                text = text.trim();
                text = text.replaceAll("[\n\r\f]+", " ");
            }
            return Strings.emptyToNull((String)text);
        }
        return null;
    }

    public static String getActionSignatureString(SarlAction signature, ISerializer serializer, SARLGrammarKeywordAccess grammarAccess, ImportManager importManager) {
        try {
            return serializer.serialize((EObject)signature);
        }
        catch (Throwable throwable) {
            JvmTypeReference returnType;
            StringBuilder textRepresentation = new StringBuilder();
            for (XAnnotation annotation : signature.getAnnotations()) {
                Utils.addAnnotationToSignature(textRepresentation, grammarAccess, serializer, importManager, annotation);
            }
            for (Object modifier : signature.getModifiers()) {
                textRepresentation.append((String)modifier);
                textRepresentation.append(' ');
            }
            if (!signature.getTypeParameters().isEmpty()) {
                boolean addComa = false;
                textRepresentation.append(grammarAccess.getLessThanSignKeyword());
                for (JvmTypeParameter typeParameter : signature.getTypeParameters()) {
                    if (addComa) {
                        textRepresentation.append(grammarAccess.getCommaKeyword());
                        textRepresentation.append(' ');
                    } else {
                        addComa = true;
                    }
                    textRepresentation.append(Utils.getSignatureType((JvmType)typeParameter, importManager));
                }
                textRepresentation.append(grammarAccess.getLessThanSignKeyword());
                textRepresentation.append(' ');
            }
            textRepresentation.append(signature.getName());
            if (!signature.getParameters().isEmpty()) {
                textRepresentation.append(grammarAccess.getLeftParenthesisKeyword());
                int idx = signature.getParameters().size() - 1;
                for (int i = 0; i < idx; ++i) {
                    Utils.addParamToSignature(textRepresentation, (XtendParameter)signature.getParameters().get(i), grammarAccess, importManager, serializer);
                    textRepresentation.append(grammarAccess.getCommaKeyword());
                    textRepresentation.append(' ');
                }
                Utils.addParamToSignature(textRepresentation, (XtendParameter)signature.getParameters().get(idx), grammarAccess, importManager, serializer);
                textRepresentation.append(grammarAccess.getRightParenthesisKeyword());
            }
            if ((returnType = signature.getReturnType()) != null && !"void".equals(returnType.getIdentifier())) {
                textRepresentation.append(' ');
                textRepresentation.append(grammarAccess.getColonKeyword());
                textRepresentation.append(' ');
                textRepresentation.append(Utils.getSignatureType(returnType.getType(), importManager));
            }
            if (!signature.getExceptions().isEmpty()) {
                textRepresentation.append(' ');
                textRepresentation.append(grammarAccess.getThrowsKeyword());
                textRepresentation.append(' ');
                boolean addComa = false;
                for (JvmTypeReference eventType : signature.getExceptions()) {
                    if (addComa) {
                        textRepresentation.append(grammarAccess.getCommaKeyword());
                        textRepresentation.append(' ');
                    } else {
                        addComa = true;
                    }
                    textRepresentation.append(Utils.getSignatureType(eventType.getType(), importManager));
                }
            }
            if (!signature.getFiredEvents().isEmpty()) {
                textRepresentation.append(' ');
                textRepresentation.append(grammarAccess.getFiresKeyword());
                textRepresentation.append(' ');
                boolean addComa = false;
                for (JvmTypeReference eventType : signature.getFiredEvents()) {
                    if (addComa) {
                        textRepresentation.append(grammarAccess.getCommaKeyword());
                        textRepresentation.append(' ');
                    } else {
                        addComa = true;
                    }
                    textRepresentation.append(Utils.getSignatureType(eventType.getType(), importManager));
                }
            }
            return textRepresentation.toString();
        }
    }

    private static void addParamToSignature(StringBuilder signature, XtendParameter parameter, SARLGrammarKeywordAccess grammarAccess, ImportManager importManager, ISerializer serializer) {
        SarlFormalParameter sarlParameter;
        signature.append(parameter.getName());
        signature.append(' ');
        signature.append(grammarAccess.getColonKeyword());
        signature.append(' ');
        signature.append(Utils.getSignatureType(parameter.getParameterType().getType(), importManager));
        if (parameter.isVarArg()) {
            signature.append(grammarAccess.getWildcardAsteriskKeyword());
        } else if (parameter instanceof SarlFormalParameter && (sarlParameter = (SarlFormalParameter)parameter).getDefaultValue() != null) {
            signature.append(' ');
            signature.append(grammarAccess.getEqualsSignKeyword());
            signature.append(' ');
            signature.append(serializer.serialize((EObject)sarlParameter.getDefaultValue()).trim());
        }
    }

    private static String getSignatureType(JvmType type, ImportManager importManager) {
        if (importManager != null) {
            importManager.addImportFor(type);
            return type.getSimpleName();
        }
        return type.getIdentifier();
    }

    public static long computeSerialVersionUID(JvmGenericType jvm) {
        StringBuilder serialVersionUIDBuffer = new StringBuilder();
        serialVersionUIDBuffer.append(jvm.getQualifiedName());
        BitSet bitset = new BitSet(32);
        bitset.set(jvm.getVisibility().getValue());
        if (jvm.isFinal()) {
            bitset.set(4);
        }
        if (jvm.isAbstract()) {
            bitset.set(5);
        }
        if (jvm.isInterface()) {
            bitset.set(6);
        }
        serialVersionUIDBuffer.append(bitset.toByteArray());
        TreeSet superTypes = CollectionLiterals.newTreeSet((Comparator)new JvmTypeReferenceComparator());
        superTypes.addAll(jvm.getSuperTypes());
        TreeSet fields = CollectionLiterals.newTreeSet((Comparator)new JvmIdentifiableComparator());
        TreeSet constructors = CollectionLiterals.newTreeSet((Comparator)new JvmIdentifiableComparator());
        TreeSet operations = CollectionLiterals.newTreeSet((Comparator)new JvmIdentifiableComparator());
        for (JvmMember member : jvm.getMembers()) {
            JvmOperation operation;
            if (member instanceof JvmField) {
                JvmField field = (JvmField)member;
                if (field.getVisibility() == JvmVisibility.PRIVATE && (field.isStatic() || field.isTransient())) continue;
                fields.add(field);
                continue;
            }
            if (member instanceof JvmConstructor) {
                JvmConstructor constructor = (JvmConstructor)member;
                if (constructor.getVisibility() == JvmVisibility.PRIVATE) continue;
                constructors.add(constructor);
                continue;
            }
            if (!(member instanceof JvmOperation) || (operation = (JvmOperation)member).getVisibility() == JvmVisibility.PRIVATE) continue;
            operations.add(operation);
        }
        for (JvmTypeReference superType : superTypes) {
            serialVersionUIDBuffer.append(superType.getQualifiedName());
        }
        for (JvmField field : fields) {
            serialVersionUIDBuffer.append(field.getSimpleName());
            bitset = new BitSet(32);
            bitset.set(field.getVisibility().getValue());
            if (field.isStatic()) {
                bitset.set(4);
            }
            if (field.isFinal()) {
                bitset.set(5);
            }
            if (field.isVolatile()) {
                bitset.set(6);
            }
            if (field.isTransient()) {
                bitset.set(7);
            }
            serialVersionUIDBuffer.append(bitset.toByteArray());
            serialVersionUIDBuffer.append(field.getType().getIdentifier());
        }
        for (JvmConstructor constructor : constructors) {
            bitset = new BitSet(32);
            bitset.set(constructor.getVisibility().getValue());
            if (constructor.isStatic()) {
                bitset.set(4);
            }
            if (constructor.isVarArgs()) {
                bitset.set(5);
            }
            serialVersionUIDBuffer.append(bitset.toByteArray());
            for (JvmFormalParameter parameter : constructor.getParameters()) {
                serialVersionUIDBuffer.append(parameter.getParameterType().getIdentifier());
            }
        }
        for (JvmOperation operation : operations) {
            bitset = new BitSet(32);
            bitset.set(operation.getVisibility().getValue());
            if (operation.isStatic()) {
                bitset.set(4);
            }
            if (operation.isFinal()) {
                bitset.set(5);
            }
            if (operation.isSynchronized()) {
                bitset.set(6);
            }
            if (operation.isNative()) {
                bitset.set(7);
            }
            if (operation.isAbstract()) {
                bitset.set(8);
            }
            if (operation.isStrictFloatingPoint()) {
                bitset.set(9);
            }
            if (operation.isVarArgs()) {
                bitset.set(10);
            }
            serialVersionUIDBuffer.append(bitset.toByteArray());
            for (JvmFormalParameter parameter : operation.getParameters()) {
                serialVersionUIDBuffer.append(parameter.getParameterType().getIdentifier());
            }
        }
        long key = 1L;
        try {
            byte[] uniqueKey = serialVersionUIDBuffer.toString().getBytes();
            byte[] sha = MessageDigest.getInstance("SHA").digest(uniqueKey);
            key = sha[0] >>> 24 & 0xFF | (sha[0] >>> 16 & 0xFF) << 8 | (sha[0] >>> 8 & 0xFF) << 16 | (sha[0] >>> 0 & 0xFF) << 24 | (sha[1] >>> 24 & 0xFF) << 32 | (sha[1] >>> 16 & 0xFF) << 40 | (sha[1] >>> 8 & 0xFF) << 48 | (sha[1] >>> 0 & 0xFF) << 56;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return key;
    }

    public static <T> List<T> singletonList(T element) {
        if (element == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(element);
    }

    public static QualifiedName getQualifiedName(JvmIdentifiableElement element) {
        if (element == null) {
            return null;
        }
        return QualifiedName.create((String[])element.getQualifiedName('.').split("\\."));
    }

    public static boolean hasAbstractMember(XtendTypeDeclaration declaration) {
        if (declaration != null) {
            for (XtendMember member : declaration.getMembers()) {
                XtendFunction cvalue;
                if (!(member instanceof XtendFunction) || !(cvalue = (XtendFunction)member).isAbstract()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCompatibleSARLLibraryOnClasspath(TypeReferences typeReferences, Notifier context) {
        OutParameter version = new OutParameter();
        SarlLibraryErrorCode code = Utils.getSARLLibraryVersionOnClasspath(typeReferences, context, (OutParameter<String>)version);
        if (code == SarlLibraryErrorCode.SARL_FOUND) {
            return Utils.isCompatibleSARLLibraryVersion((String)version.get());
        }
        return false;
    }

    public static boolean isCompatibleSARLLibraryVersion(String version) {
        if (version != null) {
            Version currentVersion = Utils.parseVersion("0.15");
            assert (currentVersion != null);
            Version paramVersion = Utils.parseVersion(version);
            if (paramVersion != null) {
                return currentVersion.getMajor() == paramVersion.getMajor() && currentVersion.getMinor() == paramVersion.getMinor();
            }
        }
        return false;
    }

    public static Version parseVersion(String version) {
        if (version != null) {
            try {
                return Version.parseVersion((String)version);
            }
            catch (Throwable ex0) {
                try {
                    return Version.parseVersion((String)(version + ".0"));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static boolean isCompatibleJDKVersionWithSARLCompilationEnvironment(String version) {
        Version current;
        if (version != null && (current = Utils.parseVersion(version)) != null) {
            Version minJdk = Utils.parseVersion("21");
            assert (minJdk != null);
            if (current.compareTo(minJdk) >= 0) {
                Version maxJdk = Utils.parseVersion("27");
                assert (maxJdk != null);
                return current.compareTo(maxJdk) < 0;
            }
        }
        return false;
    }

    public static boolean isCompatibleJDKVersionWithSARLCompilationEnvironment() {
        return Utils.isCompatibleJDKVersionWithSARLCompilationEnvironment(System.getProperty("java.specification.version"));
    }

    public static boolean isCompatibleJDKVersionWhenInSARLProjectClasspath(String version) {
        Version current;
        if (version != null && !version.isEmpty() && (current = Utils.parseVersion(version)) != null) {
            Version minJdk = Utils.parseVersion("21");
            assert (minJdk != null);
            if (current.compareTo(minJdk) >= 0) {
                Version maxJdk = Utils.parseVersion("27");
                assert (maxJdk != null);
                return current.compareTo(maxJdk) < 0;
            }
        }
        return false;
    }

    public static boolean isCompatibleXtextVersion(String version) {
        return version != null && !version.isEmpty() && Utils.compareVersions(version, "2.40.0") >= 0;
    }

    public static boolean isCompatibleXtextVersion() {
        XtextVersion xtextVersion = XtextVersion.getCurrent();
        if (xtextVersion != null && !Strings.isNullOrEmpty((String)xtextVersion.getVersion())) {
            return Utils.isCompatibleXtextVersion(xtextVersion.getVersion());
        }
        return false;
    }

    @Deprecated(forRemoval=true, since="0.10")
    public static String getSARLLibraryVersionOnClasspath(TypeReferences typeReferences, Notifier context) {
        OutParameter version = new OutParameter();
        SarlLibraryErrorCode code = Utils.getSARLLibraryVersionOnClasspath(typeReferences, context, (OutParameter<String>)version);
        if (code == SarlLibraryErrorCode.SARL_FOUND) {
            return (String)version.get();
        }
        return null;
    }

    public static SarlLibraryErrorCode getSARLLibraryVersionOnClasspath(TypeReferences typeReferences, Notifier context, OutParameter<String> version) {
        JvmType type;
        if (checkSarlVersionClass) {
            checkSarlVersionClass = false;
            try {
                Field v = SARLVersion.class.getDeclaredField(SARL_VERSION_FIELD_NAME_STR);
                if (v == null) {
                    return SarlLibraryErrorCode.INVALID_SARL_VERSION_BYTECODE;
                }
            }
            catch (Throwable e) {
                return SarlLibraryErrorCode.INVALID_SARL_VERSION_BYTECODE;
            }
        }
        try {
            type = typeReferences.findDeclaredType(SARLVersion.class, context);
        }
        catch (Throwable exception) {
            return SarlLibraryErrorCode.NO_SARL_VERSION_CLASS;
        }
        if (type == null) {
            return SarlLibraryErrorCode.NO_SARL_VERSION_CLASS;
        }
        if (type instanceof JvmDeclaredType) {
            JvmDeclaredType sarlVersionType = (JvmDeclaredType)type;
            JvmField versionField = null;
            Iterator iterator = sarlVersionType.getDeclaredFields().iterator();
            while (versionField == null && iterator.hasNext()) {
                JvmField field = (JvmField)iterator.next();
                if (!SARL_VERSION_FIELD_NAME_STR.equals(field.getSimpleName())) continue;
                versionField = field;
            }
            if (versionField == null) {
                return SarlLibraryErrorCode.NO_SARL_VERSION_FIELD;
            }
            String value = versionField.getConstantValueAsString();
            if (Strings.isNullOrEmpty((String)value)) {
                return SarlLibraryErrorCode.NO_SARL_VERSION_VALUE;
            }
            if (version != null) {
                version.set((Object)value);
            }
            return SarlLibraryErrorCode.SARL_FOUND;
        }
        return SarlLibraryErrorCode.NO_SARL_VERSION_DECLARED_TYPE;
    }

    public static boolean isSARLAnnotation(Class<?> type) {
        return type != null && Annotation.class.isAssignableFrom(type) && Utils.isSARLAnnotation(type.getPackage().getName());
    }

    public static boolean isSARLAnnotation(String qualifiedName) {
        return qualifiedName != null && qualifiedName.startsWith(SARL_PACKAGE_PREFIX);
    }

    public static boolean isFunctionalInterface(JvmGenericType type, IActionPrototypeProvider sarlSignatureProvider) {
        if (type != null && type.isInterface()) {
            HashMap<ActionPrototype, JvmOperation> operations = new HashMap<ActionPrototype, JvmOperation>();
            Utils.populateInterfaceElements((JvmDeclaredType)type, operations, null, sarlSignatureProvider);
            if (operations.size() == 1) {
                JvmOperation op = operations.values().iterator().next();
                return !op.isStatic() && !op.isDefault();
            }
        }
        return false;
    }

    public static boolean getContainerNotOfType(EObject element, Class<? extends EObject> type, OutParameter<EObject> container, OutParameter<EObject> directContainerChild) {
        EObject previous = element;
        for (EObject elt = element.eContainer(); elt != null; elt = elt.eContainer()) {
            if (!type.isInstance(elt)) {
                if (directContainerChild != null) {
                    directContainerChild.set((Object)previous);
                }
                if (container != null) {
                    container.set((Object)elt);
                }
                return true;
            }
            previous = elt;
        }
        return false;
    }

    @SafeVarargs
    public static boolean getContainerOfType(EObject element, OutParameter<EObject> container, OutParameter<EObject> directContainerChild, Class<? extends EObject> ... types) {
        EObject previous = element;
        for (EObject elt = element.eContainer(); elt != null; elt = elt.eContainer()) {
            if (Utils.isInstance(types, elt)) {
                if (directContainerChild != null) {
                    directContainerChild.set((Object)previous);
                }
                if (container != null) {
                    container.set((Object)elt);
                }
                return true;
            }
            previous = elt;
        }
        return false;
    }

    private static boolean isInstance(Class<? extends EObject>[] types, Object element) {
        for (Class<? extends EObject> type : types) {
            if (!type.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    public static EObject getFirstContainerForPredicate(EObject element, Functions.Function1<? super EObject, ? extends Boolean> predicate) {
        if (predicate == null || element == null) {
            return null;
        }
        for (EObject elt = element.eContainer(); elt != null; elt = elt.eContainer()) {
            if (!((Boolean)predicate.apply((Object)elt)).booleanValue()) continue;
            return elt;
        }
        return null;
    }

    public static String dump(EObject object) {
        return EmfFormatter.objToStr((Object)object, (EStructuralFeature[])new EStructuralFeature[0]);
    }

    public static String dump(Object object, boolean includeStaticField) {
        if (object == null) {
            return new String();
        }
        StringBuilder buffer = new StringBuilder();
        LinkedList types = new LinkedList();
        types.add(object.getClass());
        while (!types.isEmpty()) {
            Class type = (Class)types.removeFirst();
            Class supertype = type.getSuperclass();
            if (supertype != null && !supertype.equals(Object.class)) {
                types.add(supertype);
            }
            if (buffer.length() > 0) {
                buffer.append("\n");
            }
            Field[] fields = type.getDeclaredFields();
            buffer.append(type.getSimpleName()).append(" {\n");
            boolean firstRound = true;
            for (Field field : fields) {
                if (!includeStaticField && Modifier.isStatic(field.getModifiers())) continue;
                try {
                    field.setAccessible(true);
                    if (firstRound) {
                        firstRound = false;
                    } else {
                        buffer.append(",\n");
                    }
                    try {
                        Object fieldObj = field.get(object);
                        String value = null == fieldObj ? "null" : fieldObj.toString();
                        buffer.append('\t').append(field.getName()).append('=').append('\"');
                        buffer.append(org.eclipse.xtext.util.Strings.convertToJavaString((String)value));
                        buffer.append("\"");
                    }
                    catch (IllegalAccessException illegalAccessException) {}
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            buffer.append("\n}");
        }
        return buffer.toString();
    }

    public static JvmTypeReference cloneWithTypeParametersAndProxies(JvmTypeReference type, Iterable<JvmTypeParameter> executableTypeParameters, Map<String, JvmTypeReference> superTypeParameterMapping, JvmTypeReferenceBuilder typeParameterBuilder, JvmTypesBuilder typeBuilder, TypeReferences typeReferences, TypesFactory jvmTypesFactory) {
        if (type == null) {
            return typeParameterBuilder.typeRef(Object.class, new JvmTypeReference[0]);
        }
        boolean cloneType = true;
        JvmTypeReference typeCandidate = type;
        if ((executableTypeParameters.iterator().hasNext() || !superTypeParameterMapping.isEmpty()) && cloneType) {
            TreeMap<String, JvmTypeParameter> typeParameterIdentifiers = new TreeMap<String, JvmTypeParameter>();
            for (JvmTypeParameter typeParameter : executableTypeParameters) {
                typeParameterIdentifiers.put(typeParameter.getIdentifier(), typeParameter);
            }
            if (type instanceof JvmParameterizedTypeReference) {
                cloneType = false;
                typeCandidate = Utils.cloneAndAssociate(type, typeParameterIdentifiers, superTypeParameterMapping, typeParameterBuilder, typeReferences, jvmTypesFactory);
            } else if (type instanceof XFunctionTypeRef) {
                XFunctionTypeRef functionRef = (XFunctionTypeRef)type;
                cloneType = false;
                XFunctionTypeRef cloneReference = XtypeFactory.eINSTANCE.createXFunctionTypeRef();
                for (JvmTypeReference paramType : functionRef.getParamTypes()) {
                    cloneReference.getParamTypes().add((Object)Utils.cloneAndAssociate(paramType, typeParameterIdentifiers, superTypeParameterMapping, typeParameterBuilder, typeReferences, jvmTypesFactory));
                }
                cloneReference.setReturnType(Utils.cloneAndAssociate(functionRef.getReturnType(), typeParameterIdentifiers, superTypeParameterMapping, typeParameterBuilder, typeReferences, jvmTypesFactory));
                cloneReference.setInstanceContext(functionRef.isInstanceContext());
                typeCandidate = cloneReference;
            }
        }
        assert (typeCandidate != null);
        JvmTypeReference returnType = !cloneType ? typeCandidate : typeBuilder.cloneWithProxies(typeCandidate);
        return returnType;
    }

    private static JvmTypeReference cloneAndAssociate(JvmTypeReference type, final Map<String, JvmTypeParameter> typeParameterIdentifiers, final Map<String, JvmTypeReference> superTypeParameterMapping, final JvmTypeReferenceBuilder typeParameterBuilder, final TypeReferences typeReferences, final TypesFactory jvmTypesFactory) {
        var copier = new EcoreUtil.Copier(false){
            private static final long serialVersionUID = 698510355384773254L;

            public EObject copy(EObject eobject) {
                EObject result;
                String id;
                if (eobject instanceof JvmTypeReference) {
                    JvmTypeReference cvalue = (JvmTypeReference)eobject;
                    id = cvalue.getIdentifier();
                } else if (eobject instanceof JvmIdentifiableElement) {
                    JvmIdentifiableElement cvalue = (JvmIdentifiableElement)eobject;
                    id = cvalue.getIdentifier();
                } else {
                    id = null;
                }
                if (id != null) {
                    JvmTypeParameter param = (JvmTypeParameter)typeParameterIdentifiers.get(id);
                    if (param != null) {
                        return typeReferences.createTypeRef((JvmType)param, new JvmTypeReference[0]);
                    }
                    JvmTypeReference superTypeReference = (JvmTypeReference)superTypeParameterMapping.get(id);
                    if (superTypeReference != null) {
                        return typeReferences.createDelegateTypeReference(superTypeReference);
                    }
                }
                if ((result = super.copy(eobject)) instanceof JvmWildcardTypeReference) {
                    JvmWildcardTypeReference wildcardType = (JvmWildcardTypeReference)result;
                    boolean upperBoundSeen = false;
                    for (JvmTypeConstraint constraint : wildcardType.getConstraints()) {
                        if (!(constraint instanceof JvmUpperBound)) continue;
                        upperBoundSeen = true;
                        break;
                    }
                    if (!upperBoundSeen) {
                        JvmTypeReference object = typeParameterBuilder.typeRef(Object.class, new JvmTypeReference[0]);
                        JvmUpperBound upperBound = jvmTypesFactory.createJvmUpperBound();
                        upperBound.setTypeReference(object);
                        wildcardType.getConstraints().add(0, (Object)upperBound);
                    }
                }
                return result;
            }
        };
        JvmTypeReference copy = (JvmTypeReference)copier.copy((EObject)type);
        copier.copyReferences();
        return copy;
    }

    public static void getSuperTypeParameterMap(JvmDeclaredType type, Map<String, JvmTypeReference> mapping) {
        for (JvmTypeReference superTypeReference : type.getSuperTypes()) {
            if (!(superTypeReference instanceof JvmParameterizedTypeReference)) continue;
            JvmParameterizedTypeReference parameterizedTypeReference = (JvmParameterizedTypeReference)superTypeReference;
            JvmType st = superTypeReference.getType();
            if (!(st instanceof JvmTypeParameterDeclarator)) continue;
            JvmTypeParameterDeclarator superType = (JvmTypeParameterDeclarator)st;
            int i = 0;
            for (JvmTypeParameter typeParameter : superType.getTypeParameters()) {
                if (i < parameterizedTypeReference.getArguments().size()) {
                    mapping.put(typeParameter.getIdentifier(), (JvmTypeReference)parameterizedTypeReference.getArguments().get(i));
                } else {
                    mapping.put(typeParameter.getIdentifier(), null);
                }
                ++i;
            }
        }
    }

    public static void copyTypeParametersFromJvmOperation(JvmOperation fromOperation, JvmOperation toOperation, JvmTypeReferenceBuilder typeParameterBuilder, JvmTypesBuilder typeBuilder, TypeReferences typeReferences, TypesFactory jvmTypesFactory) {
        HashMap<String, JvmTypeReference> superTypeParameterMapping = new HashMap<String, JvmTypeReference>();
        Utils.getSuperTypeParameterMap(toOperation.getDeclaringType(), superTypeParameterMapping);
        Utils.copyTypeParametersFromJvmOperation((List<JvmTypeParameter>)fromOperation.getTypeParameters(), (List<JvmTypeParameter>)toOperation.getTypeParameters(), superTypeParameterMapping, typeParameterBuilder, typeBuilder, typeReferences, jvmTypesFactory);
    }

    public static void copyTypeParametersFromJvmOperation(List<JvmTypeParameter> inputParameters, List<JvmTypeParameter> outputParameters, Map<String, JvmTypeReference> superTypeParameterMapping, JvmTypeReferenceBuilder typeParameterBuilder, JvmTypesBuilder typeBuilder, TypeReferences typeReferences, TypesFactory jvmTypesFactory) {
        JvmTypeParameter typeParameterCopy;
        for (JvmTypeParameter typeParameter : inputParameters) {
            typeParameterCopy = jvmTypesFactory.createJvmTypeParameter();
            typeParameterCopy.setName(typeParameter.getName());
            outputParameters.add(typeParameterCopy);
        }
        for (int i = 0; i < inputParameters.size(); ++i) {
            JvmTypeParameter typeParameter;
            typeParameter = inputParameters.get(i);
            typeParameterCopy = outputParameters.get(i);
            for (JvmTypeConstraint constraint : typeParameter.getConstraints()) {
                JvmLowerBound cst = null;
                if (constraint instanceof JvmLowerBound) {
                    cst = jvmTypesFactory.createJvmLowerBound();
                } else if (constraint instanceof JvmUpperBound) {
                    cst = jvmTypesFactory.createJvmUpperBound();
                }
                if (cst == null) continue;
                typeParameterCopy.getConstraints().add((Object)cst);
                cst.setTypeReference(Utils.cloneWithTypeParametersAndProxies(constraint.getTypeReference(), outputParameters, superTypeParameterMapping, typeParameterBuilder, typeBuilder, typeReferences, jvmTypesFactory));
            }
        }
    }

    public static void setStructuralFeature(EObject object, EStructuralFeature property, Object value) {
        assert (object != null);
        assert (property != null);
        if (value == null) {
            object.eUnset(property);
        } else {
            object.eSet(property, value);
        }
    }

    public static XAbstractFeatureCall getRootFeatureCall(XAbstractFeatureCall featureCall) {
        EObject container = featureCall.eContainer();
        XAbstractFeatureCall rootFeatureCall = container instanceof XMemberFeatureCall || container instanceof XFeatureCall ? (XAbstractFeatureCall)Utils.getFirstContainerForPredicate((EObject)featureCall, (Functions.Function1<? super EObject, ? extends Boolean>)((Functions.Function1)it -> it.eContainer() != null && !(it.eContainer() instanceof XMemberFeatureCall) && !(it.eContainer() instanceof XFeatureCall))) : featureCall;
        return rootFeatureCall;
    }

    public static XAbstractFeatureCall getRootFeatureCall(XAbstractFeatureCall featureCall, XExpression container, List<JvmFormalParameter> containerParameters) {
        if (Utils.hasLocalParameters((EObject)featureCall, container, containerParameters) || !(featureCall instanceof XMemberFeatureCall) && !(featureCall instanceof XFeatureCall)) {
            return null;
        }
        XAbstractFeatureCall current = featureCall;
        EObject currentContainer = current.eContainer();
        while (currentContainer != null) {
            if (currentContainer instanceof XMemberFeatureCall || currentContainer instanceof XFeatureCall) {
                XAbstractFeatureCall c = (XAbstractFeatureCall)currentContainer;
                if (Utils.hasLocalParameters((EObject)c, container, containerParameters)) {
                    return current;
                }
                current = c;
                currentContainer = current.eContainer();
                continue;
            }
            return current;
        }
        return current;
    }

    private static boolean hasLocalParameters(EObject current, XExpression container, List<JvmFormalParameter> containerParameters) {
        if (current instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall featureCall = (XAbstractFeatureCall)current;
            if (Utils.isLocalEntity(featureCall, container, containerParameters)) {
                return true;
            }
            for (XExpression argument : featureCall.getActualArguments()) {
                Iterable iterable;
                if (argument instanceof XAbstractFeatureCall) {
                    XAbstractFeatureCall cvalue = (XAbstractFeatureCall)argument;
                    iterable = Iterables.concat(Collections.singletonList(cvalue), (Iterable)EcoreUtil2.getAllContentsOfType((EObject)argument, XAbstractFeatureCall.class));
                } else {
                    iterable = EcoreUtil2.getAllContentsOfType((EObject)argument, XAbstractFeatureCall.class);
                }
                for (XAbstractFeatureCall c : iterable) {
                    if (!Utils.isLocalEntity(c, container, containerParameters)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isLocalEntity(XAbstractFeatureCall featureCall, XExpression container, List<JvmFormalParameter> containerParameters) {
        JvmIdentifiableElement feature = featureCall.getFeature();
        return feature instanceof JvmFormalParameter ? containerParameters.contains(feature) : feature instanceof XVariableDeclaration && EcoreUtil.isAncestor((EObject)container, (EObject)feature);
    }

    public static boolean containsGenericType(LightweightTypeReference type) {
        if (type == null) {
            return false;
        }
        JvmType jtype = type.getType();
        if (jtype instanceof JvmTypeParameter) {
            return true;
        }
        for (LightweightTypeReference atype : type.getTypeArguments()) {
            if (!Utils.containsGenericType(atype)) continue;
            return true;
        }
        switch (type.getKind()) {
            case 8: {
                if (!Utils.containsGenericType(type.getLowerBoundSubstitute()) && !Utils.containsGenericType(type.getUpperBoundSubstitute())) break;
                return true;
            }
            case 3: {
                if (!Utils.containsGenericType(type.getComponentType())) break;
                return true;
            }
        }
        return false;
    }

    @Pure
    public static Object toReadableString(String text) {
        String str = Strings.emptyToNull((String)text);
        if (str == null) {
            return Messages.Utils_0;
        }
        return text;
    }

    @Pure
    public static String getHumanReadableTypeArgumentsWithoutBounds(List<LightweightTypeReference> arguments, int numberOfArgumentsIfNotProvider, SARLGrammarKeywordAccess grammarAccess) {
        StringBuilder buffer = new StringBuilder();
        if (arguments != null && !arguments.isEmpty()) {
            buffer.append(grammarAccess.getLessThanSignKeyword());
            boolean first = true;
            for (LightweightTypeReference argument : arguments) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(grammarAccess.getCommaKeyword()).append(" ");
                }
                buffer.append(argument.getHumanReadableName());
            }
            buffer.append(grammarAccess.getGreaterThanSignKeyword());
        } else {
            buffer.append(grammarAccess.getLessThanSignKeyword());
            for (int i = 0; i < numberOfArgumentsIfNotProvider; ++i) {
                if (i > 0) {
                    buffer.append(grammarAccess.getCommaKeyword());
                }
                buffer.append(grammarAccess.getQuestionMarkKeyword());
            }
            buffer.append(grammarAccess.getGreaterThanSignKeyword());
        }
        return buffer.toString();
    }

    @Pure
    public static String getHumanReadableTypeArgumentsWithoutBounds(LightweightTypeReference type, int numberOfArgumentsIfNotProvider, SARLGrammarKeywordAccess grammarAccess) {
        return Utils.getHumanReadableTypeArgumentsWithoutBounds(type.getTypeArguments(), numberOfArgumentsIfNotProvider, grammarAccess);
    }

    @Pure
    public static String getHumanReadableTypeParametersWithBounds(List<JvmTypeParameter> arguments, SARLGrammarKeywordAccess grammarAccess) {
        StringBuilder buffer = new StringBuilder();
        if (arguments != null && !arguments.isEmpty()) {
            buffer.append(grammarAccess.getLessThanSignKeyword());
            boolean first = true;
            for (JvmTypeParameter argument : arguments) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(grammarAccess.getCommaKeyword()).append(" ");
                }
                buffer.append(argument.getSimpleName());
                for (JvmTypeConstraint constraint : argument.getConstraints()) {
                    if (constraint instanceof JvmUpperBound) {
                        JvmUpperBound upper = (JvmUpperBound)constraint;
                        buffer.append(" ").append(grammarAccess.getExtendsKeyword());
                        buffer.append(" ").append(upper.getTypeReference().getSimpleName());
                        continue;
                    }
                    if (!(constraint instanceof JvmLowerBound)) continue;
                    JvmLowerBound lower = (JvmLowerBound)constraint;
                    buffer.append(" ").append(grammarAccess.getSuperKeyword());
                    buffer.append(" ").append(lower.getTypeReference().getSimpleName());
                }
            }
            buffer.append(grammarAccess.getGreaterThanSignKeyword());
        }
        return buffer.toString();
    }

    @Pure
    public static String getHumanReadableTypeArgumentsWithBounds(List<LightweightTypeReference> arguments, SARLGrammarKeywordAccess grammarAccess) {
        StringBuilder buffer = new StringBuilder();
        if (arguments != null && arguments.isEmpty()) {
            buffer.append(grammarAccess.getLessThanSignKeyword());
            boolean first = true;
            for (LightweightTypeReference argument : arguments) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(grammarAccess.getCommaKeyword()).append(" ");
                }
                buffer.append(argument.getHumanReadableName());
                buffer.append(" ").append(grammarAccess.getExtendsKeyword()).append(" ");
                buffer.append(argument.getConstraintSubstitute().getHumanReadableName());
            }
            buffer.append(grammarAccess.getGreaterThanSignKeyword());
        }
        return buffer.toString();
    }

    @Pure
    public static String getHumanReadableTypeArgumentsWithBounds(LightweightTypeReference type, SARLGrammarKeywordAccess grammarAccess) {
        return Utils.getHumanReadableTypeArgumentsWithBounds(type.getTypeArguments(), grammarAccess);
    }

    public static JvmTypeReference getUpperBoundFromConstraints(JvmConstraintOwner parameter) {
        EList cst = parameter.getConstraints();
        if (!cst.isEmpty()) {
            return ((JvmTypeConstraint)cst.get(0)).getTypeReference();
        }
        return null;
    }

    public static TypeParameterStatus forEachTypeParameterName(JvmParameterizedTypeReference type, BiConsumer<JvmTypeReference, Integer> consumer) {
        JvmType jvmType;
        TypeParameterStatus status = TypeParameterStatus.NO_TYPE_PARAMETER;
        if (type != null && (jvmType = type.getType()) instanceof JvmTypeParameterDeclarator) {
            JvmTypeParameterDeclarator gtype = (JvmTypeParameterDeclarator)jvmType;
            EList parameters = gtype.getTypeParameters();
            EList arguments = type.getArguments();
            int i = 0;
            for (JvmTypeParameter parameter : parameters) {
                JvmTypeReference argument;
                JvmTypeReference jvmTypeReference = argument = i < arguments.size() ? (JvmTypeReference)arguments.get(i) : null;
                if (argument == null) {
                    try {
                        consumer.accept(Utils.getUpperBoundFromConstraints((JvmConstraintOwner)parameter), i);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    status = status.or(TypeParameterStatus.DEFINITION_ROOT_BOUND);
                } else if (argument instanceof JvmWildcardTypeReference) {
                    JvmWildcardTypeReference wargument = (JvmWildcardTypeReference)argument;
                    JvmTypeReference name = Utils.getUpperBoundFromConstraints((JvmConstraintOwner)wargument);
                    if (name == null) {
                        try {
                            name = Utils.getUpperBoundFromConstraints((JvmConstraintOwner)parameter);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        status = status.or(TypeParameterStatus.DEFINITION_ROOT_BOUND);
                    } else {
                        status = status.or(TypeParameterStatus.EXPLICIT_BOUNDED_WILDCARD);
                    }
                    consumer.accept(name, i);
                } else {
                    consumer.accept(argument, i);
                    status = status.or(TypeParameterStatus.EXPLICIT_DIRECT_TYPE);
                }
                ++i;
            }
        }
        return status;
    }

    public static String createBehaviorUnitEventId(JvmParameterizedTypeReference eventType) {
        String id = eventType.getType().getIdentifier();
        return Utils.buildNameForHiddenEventMethod(eventType, id, false, true).toString();
    }

    public static List<JvmTypeReference> getTypeParameterBoundsFor(JvmParameterizedTypeReference eventType, TypeReferences typeReferences) {
        ArrayList<JvmTypeReference> bounds = new ArrayList<JvmTypeReference>();
        TypeParameterStatus result = Utils.forEachTypeParameterName(eventType, (name, i) -> {
            Object ref = name == null ? typeReferences.createTypeRef(typeReferences.findDeclaredType(Object.class, (Notifier)eventType), new JvmTypeReference[0]) : name;
            bounds.add((JvmTypeReference)ref);
        });
        if (result != TypeParameterStatus.NO_TYPE_PARAMETER) {
            return bounds;
        }
        return null;
    }

    static {
        checkSarlVersionClass = true;
        IMPLICIT_LAMBDA_PARAMETER_PATTERN = Pattern.compile("^\\$[0-9]+$");
        StringBuilder name = new StringBuilder();
        String[] components = EarlyExit.class.getPackage().getName().split("\\.");
        int len = Math.min(3, components.length);
        for (int i = 0; i < len; ++i) {
            name.append(components[i]);
            name.append(".");
        }
        SARL_PACKAGE_PREFIX = name.toString();
    }

    public static enum TypeParameterStatus {
        NO_TYPE_PARAMETER{

            @Override
            public boolean isBoundInFunctionName() {
                return false;
            }
        }
        ,
        DEFINITION_ROOT_BOUND{

            @Override
            public boolean isBoundInFunctionName() {
                return true;
            }
        }
        ,
        EXPLICIT_BOUNDED_WILDCARD{

            @Override
            public boolean isBoundInFunctionName() {
                return true;
            }
        }
        ,
        EXPLICIT_DIRECT_TYPE{

            @Override
            public boolean isBoundInFunctionName() {
                return true;
            }
        };


        public TypeParameterStatus or(TypeParameterStatus status) {
            return status.ordinal() > this.ordinal() ? status : this;
        }

        public abstract boolean isBoundInFunctionName();
    }

    public static enum SarlLibraryErrorCode {
        SARL_FOUND,
        NO_SARL_VERSION_CLASS,
        NO_SARL_VERSION_DECLARED_TYPE,
        NO_SARL_VERSION_FIELD,
        NO_SARL_VERSION_VALUE,
        INVALID_SARL_VERSION_BYTECODE;

    }
}

