/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.validation.IConfigurableIssueSeveritiesProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.PreferenceKey;
import org.eclipse.xtext.validation.ConfigurableIssueCodesProvider;
import org.eclipse.xtext.validation.IssueSeveritiesProvider;

@Singleton
public class ConfigurableIssueSeveritiesProvider
extends IssueSeveritiesProvider
implements IConfigurableIssueSeveritiesProvider {
    private final Map<String, Severity> overridingSeverities = Collections.synchronizedMap(new HashMap());
    @Inject
    private ConfigurableIssueCodesProvider issueCodesProvider;

    protected IPreferenceValuesProvider getValuesProvider() {
        IPreferenceValuesProvider original = super.getValuesProvider();
        if (this.overridingSeverities.isEmpty()) {
            return original;
        }
        return new ConfigurableValueProvider(original, this.overridingSeverities);
    }

    @Override
    public void setSeverity(String code, Severity severity) {
        PreferenceKey key;
        if (!Strings.isNullOrEmpty((String)code) && (key = (PreferenceKey)this.issueCodesProvider.getConfigurableIssueCodes().get(code)) != null) {
            if (severity == null) {
                this.overridingSeverities.remove(key.getId());
            } else {
                this.overridingSeverities.put(key.getId(), severity);
            }
        }
    }

    @Override
    public void setAllSeverities(Severity severity) {
        this.overridingSeverities.clear();
        if (severity != null) {
            for (PreferenceKey key : this.issueCodesProvider.getConfigurableIssueCodes().values()) {
                if (key == null) continue;
                this.overridingSeverities.put(key.getId(), severity);
            }
        }
    }

    public static class ConfigurableValueProvider
    implements IPreferenceValuesProvider {
        private final IPreferenceValuesProvider original;
        private final Map<String, Severity> overridingSeverities;

        public ConfigurableValueProvider(IPreferenceValuesProvider original, Map<String, Severity> overridingSeverities) {
            this.original = original;
            this.overridingSeverities = overridingSeverities;
        }

        public IPreferenceValues getPreferenceValues(Resource context) {
            IPreferenceValues values = this.original.getPreferenceValues(context);
            return new ConfigurableValues(values, this.overridingSeverities);
        }
    }

    public static class ConfigurableValues
    implements IPreferenceValues {
        private final IPreferenceValues original;
        private final Map<String, Severity> overridingSeverities;

        public ConfigurableValues(IPreferenceValues original, Map<String, Severity> overridingSeverities) {
            this.original = original;
            this.overridingSeverities = overridingSeverities;
        }

        public String getPreference(PreferenceKey key) {
            Severity severity;
            if (key != null && (severity = this.overridingSeverities.get(key.getId())) != null) {
                switch (severity) {
                    case ERROR: {
                        return "error";
                    }
                    case IGNORE: {
                        return "ignore";
                    }
                    case INFO: {
                        return "info";
                    }
                    case WARNING: {
                        return "warning";
                    }
                }
            }
            return this.original.getPreference(key);
        }
    }
}

