/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation;

import com.google.inject.Inject;
import io.sarl.lang.core.annotation.PrivateAPI;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.typesystem.SARLAnnotationUtil;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.IFeatureCallValidator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.InputOutput;

public class DefaultFeatureCallValidator
implements IFeatureCallValidator {
    @Inject
    private SARLAnnotationUtil annotations;
    @Inject
    private ILogicalContainerProvider containerProvider;

    private static boolean isInsideOOTypeDeclaration(XAbstractFeatureCall call) {
        XtendTypeDeclaration declaration = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)call, XtendTypeDeclaration.class);
        return declaration != null && (declaration instanceof XtendClass || declaration instanceof XtendEnum || declaration instanceof XtendInterface || declaration instanceof XtendAnnotationType);
    }

    @Override
    public boolean isDisallowedCall(XAbstractFeatureCall call) {
        if (call != null && call.getFeature() != null) {
            JvmIdentifiableElement feature = call.getFeature();
            String id = feature.getQualifiedName();
            if ("java.lang.System.exit".equals(id)) {
                return !DefaultFeatureCallValidator.isInsideOOTypeDeclaration(call);
            }
            String simpleName = feature.getSimpleName();
            if (!(!SarlUtils.isHiddenMember((String)simpleName) || Utils.isNameForHiddenCapacityImplementationCallingMethod(simpleName) || Utils.isImplicitLambdaParameterName(simpleName) && DefaultFeatureCallValidator.isInsideClosure(call))) {
                return true;
            }
            if (this.isPrivateAPI(feature) && !this.isPrivateAPI(call)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isInsideClosure(XAbstractFeatureCall call) {
        EObject container = Utils.getFirstContainerForPredicate((EObject)call, (Functions.Function1<? super EObject, ? extends Boolean>)((Functions.Function1)it -> it instanceof XClosure || it instanceof XtendMember));
        return container instanceof XClosure;
    }

    private boolean isPrivateAPI(JvmIdentifiableElement element) {
        JvmMember featureContainer = (JvmMember)EcoreUtil2.getContainerOfType((EObject)element, JvmMember.class);
        while (featureContainer != null) {
            Boolean value = this.annotations.findBooleanValue((JvmAnnotationTarget)featureContainer, PrivateAPI.class);
            if (value != null && !value.booleanValue()) {
                return true;
            }
            featureContainer = (JvmMember)EcoreUtil2.getContainerOfType((EObject)featureContainer.eContainer(), JvmMember.class);
        }
        return false;
    }

    private boolean isPrivateAPI(XAbstractFeatureCall element) {
        JvmIdentifiableElement jvmElement = this.containerProvider.getNearestLogicalContainer((EObject)element);
        return jvmElement != null && this.isPrivateAPICaller(jvmElement);
    }

    private boolean isPrivateAPICaller(JvmIdentifiableElement element) {
        JvmMember featureContainer = (JvmMember)EcoreUtil2.getContainerOfType((EObject)element, JvmMember.class);
        while (featureContainer != null) {
            if (this.annotations.findAnnotation((JvmAnnotationTarget)featureContainer, PrivateAPI.class.getName()) != null) {
                return true;
            }
            featureContainer = (JvmMember)EcoreUtil2.getContainerOfType((EObject)featureContainer.eContainer(), JvmMember.class);
        }
        return false;
    }

    @Override
    public boolean isDiscouragedCall(XAbstractFeatureCall call) {
        JvmIdentifiableElement feature;
        String id;
        if (call != null && call.getFeature() != null && (id = (feature = call.getFeature()).getQualifiedName()) != null) {
            switch (id) {
                case "java.lang.System.err": 
                case "java.lang.System.out": 
                case "java.lang.System.setErr": 
                case "java.lang.System.setOut": 
                case "java.lang.System.console": 
                case "java.lang.System.inheritedChannel": {
                    return true;
                }
                case "java.lang.System.exit": {
                    return DefaultFeatureCallValidator.isInsideOOTypeDeclaration(call);
                }
            }
            if (id.startsWith(InputOutput.class.getName())) {
                return true;
            }
            if (id.startsWith(Thread.class.getName())) {
                return true;
            }
        }
        return false;
    }
}

