/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation;

import com.google.inject.Singleton;
import io.sarl.lang.validation.IProgrammaticWarningSuppressor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;

@Singleton
public class DefaultProgrammaticWarningSuppressor
implements IProgrammaticWarningSuppressor {
    private static final String ALL_WARNINGS = "all";

    @Override
    public IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject currentObject, IssueSeverities predefinedSeverities) {
        HashSet<String> codes = new HashSet<String>();
        XtendAnnotationTarget cObject = (XtendAnnotationTarget)EcoreUtil2.getContainerOfType((EObject)currentObject, XtendAnnotationTarget.class);
        boolean ignoreAll = false;
        while (!ignoreAll && cObject != null) {
            block1: for (XAnnotation annotation : cObject.getAnnotations()) {
                if (!SuppressWarnings.class.getName().equals(annotation.getAnnotationType().getIdentifier())) continue;
                XExpression expr = annotation.getValue();
                if (expr instanceof XStringLiteral) {
                    XStringLiteral cvalue = (XStringLiteral)expr;
                    String id = cvalue.getValue();
                    if (ALL_WARNINGS.equalsIgnoreCase(id)) {
                        ignoreAll = true;
                        codes.clear();
                        break;
                    }
                    codes.add(DefaultProgrammaticWarningSuppressor.extractId(id));
                    continue;
                }
                if (!(expr instanceof XCollectionLiteral)) continue;
                XCollectionLiteral collection = (XCollectionLiteral)expr;
                for (XExpression idExpr : collection.getElements()) {
                    String id;
                    if (idExpr instanceof XStringLiteral) {
                        XStringLiteral cvalue = (XStringLiteral)idExpr;
                        id = cvalue.getValue();
                    } else {
                        id = null;
                    }
                    if (ALL_WARNINGS.equalsIgnoreCase(id)) {
                        ignoreAll = true;
                        codes.clear();
                        continue block1;
                    }
                    codes.add(DefaultProgrammaticWarningSuppressor.extractId(id));
                }
            }
            cObject = (XtendAnnotationTarget)EcoreUtil2.getContainerOfType((EObject)cObject.eContainer(), XtendAnnotationTarget.class);
        }
        if (!ignoreAll && codes.isEmpty()) {
            return predefinedSeverities;
        }
        return new SuppressWarningIssueSeverities(predefinedSeverities, ignoreAll, codes);
    }

    private static String extractId(String code) {
        int index = code.lastIndexOf(46);
        if (index >= 0) {
            return code.substring(index + 1);
        }
        return code;
    }

    private static final class SuppressWarningIssueSeverities
    extends IssueSeverities {
        private final IssueSeverities delegate;
        private final boolean ignoredAll;
        private final Set<String> ignoredWarnings;

        SuppressWarningIssueSeverities(IssueSeverities delegate, boolean ignoreAll, Set<String> codes) {
            super(null, null, null);
            this.delegate = delegate;
            this.ignoredAll = ignoreAll;
            this.ignoredWarnings = codes;
        }

        public Severity getSeverity(String code) {
            if (this.delegate == null || this.ignoredAll) {
                return Severity.IGNORE;
            }
            String codeId = DefaultProgrammaticWarningSuppressor.extractId(code);
            if (this.ignoredWarnings.contains(codeId)) {
                return Severity.IGNORE;
            }
            return this.delegate.getSeverity(code);
        }
    }
}

