/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.controlflow.ISarlEarlyExitComputer;
import io.sarl.lang.validation.IProgrammaticWarningSuppressor;
import io.sarl.lang.validation.Messages;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.validation.XtendEarlyExitValidator;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;

@Singleton
public class SARLEarlyExitValidator
extends XtendEarlyExitValidator {
    @Inject
    private ISarlEarlyExitComputer earlyExitComputer;
    @Inject
    private IProgrammaticWarningSuppressor warningSuppressor;

    protected IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject eObject) {
        IssueSeverities severities = super.getIssueSeverities(context, eObject);
        return this.warningSuppressor.getIssueSeverities(context, eObject, severities);
    }

    @Check
    public void checkDeadCode(XBlockExpression block) {
        EList expressions = block.getExpressions();
        int size = expressions.size();
        for (int i = 0; i < size - 1; ++i) {
            XExpression expression = (XExpression)expressions.get(i);
            if (this.earlyExitComputer.isEarlyExit(expression)) {
                if (expression instanceof XAbstractFeatureCall) {
                    XAbstractFeatureCall cvalue = (XAbstractFeatureCall)expression;
                    if (this.earlyExitComputer.isEarlyExitAnnotatedElement(cvalue.getFeature())) {
                        this.markAsDeadCode((XExpression)expressions.get(i + 1));
                    }
                } else {
                    this.markAsDeadCode((XExpression)expressions.get(i + 1));
                }
                return;
            }
            if (!this.earlyExitComputer.isEarlyExitLoop(expression)) continue;
            this.markAsDeadCode((XExpression)expressions.get(i + 1));
        }
    }

    protected void collectExits(EObject expr, List<XExpression> found) {
        XAbstractFeatureCall cvalue;
        JvmIdentifiableElement element;
        super.collectExits(expr, found);
        if (expr instanceof XAbstractFeatureCall && this.earlyExitComputer.isEarlyExitAnnotatedElement(element = (cvalue = (XAbstractFeatureCall)expr).getFeature())) {
            found.add((XExpression)expr);
        }
    }

    private boolean markAsDeadCode(XExpression expression) {
        XBlockExpression block;
        EList expressions;
        if (expression instanceof XBlockExpression && !(expressions = (block = (XBlockExpression)expression).getExpressions()).isEmpty()) {
            this.markAsDeadCode((XExpression)expressions.get(0));
            return true;
        }
        if (expression != null) {
            this.error(Messages.SARLEarlyExitValidator_0, (EObject)expression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.unreachable_code", new String[0]);
            return true;
        }
        return false;
    }
}

