/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.typesystem.ISARLTypeChecker;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.AbstractSARLValidator;
import io.sarl.lang.validation.IProgrammaticWarningSuppressor;
import io.sarl.lang.validation.ISARLValidator;
import io.sarl.lang.validation.Messages;
import io.sarl.lang.validation.subvalidators.SARLCastValidator;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.RichStringForLoop;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.DeprecationUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.util.XbaseUsageCrossReferencer;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;
import org.eclipse.xtext.xtype.XImportDeclaration;

@Singleton
public class SARLValidator
extends AbstractSARLValidator
implements ISARLValidator {
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private SarlJvmModelAssociations associations;
    @Inject
    private IJvmModelAssociations jvmModelAssociations;
    @Inject
    private SARLCastValidator castValidator;
    @Inject
    private IProgrammaticWarningSuppressor warningSuppressor;
    @Inject
    private ReadAndWriteTracking readAndWriteTracking;
    @Inject
    private SARLGrammarKeywordAccess grammarAccess;
    @Inject
    private ISARLTypeChecker sarlTypeChecker;
    private ValidationMessageAcceptor temporaryMessageAcceptor;

    @Override
    public boolean isPrimitiveVoid(JvmTypeReference typeReference) {
        return super.isPrimitiveVoid(typeReference);
    }

    @Override
    public boolean isFinal(LightweightTypeReference type) {
        return super.isFinal(type);
    }

    @Override
    public boolean memberOfTypeHierarchy(LightweightTypeReference type, LightweightTypeReference potentialMember) {
        return super.memberOfTypeHierarchy(type, potentialMember);
    }

    @Override
    public CommonTypeComputationServices getServices() {
        return super.getServices();
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        return super.toLightweightTypeReference(typeRef);
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, boolean keepUnboundWildcardInformation) {
        return super.toLightweightTypeReference(typeRef, keepUnboundWildcardInformation);
    }

    @Override
    public LightweightTypeReference getActualType(XExpression expression) {
        return super.getActualType(expression);
    }

    @Override
    public boolean isIgnored(String issueCode) {
        return super.isIgnored(issueCode);
    }

    @Override
    public boolean isIgnored(String issueCode, EObject currentObject) {
        IssueSeverities severities = this.getIssueSeverities(this.getContext(), currentObject);
        return severities.isIgnored(issueCode);
    }

    @Override
    public void addIssue(String message, EObject source, String issueCode) {
        super.addIssue(message, source, issueCode);
    }

    @Override
    public boolean isLocallyUsed(EObject target, EObject containerToFindUsage) {
        boolean result = super.isLocallyUsed(target, containerToFindUsage);
        return result;
    }

    @Override
    public boolean isTypeParameterLocallyUsedInEvent(JvmTypeParameter parameter, SarlEvent event) {
        for (XtendMember member : event.getMembers()) {
            Collection usages;
            if (!(member instanceof XtendField)) continue;
            XtendField field = (XtendField)member;
            if (field.getType() != null && field.getType().getType().getIdentifier().equals(parameter.getIdentifier())) {
                return true;
            }
            if (field.getInitialValue() == null || (usages = XbaseUsageCrossReferencer.find((EObject)parameter, (EObject)field.getInitialValue())).isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public LightweightTypeReference toLightweightTypeReference(JvmType type, EObject context) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), context);
        LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory((ITypeReferenceOwner)owner, false);
        return factory.toLightweightReference(type);
    }

    @Override
    public GeneratorConfig getGeneratorConfig(EObject element) {
        GeneratorConfig result = (GeneratorConfig)this.getContext().get(GeneratorConfig.class);
        if (result == null) {
            result = this.generatorConfigProvider.get(element);
            this.getContext().put(GeneratorConfig.class, result);
        }
        return result;
    }

    protected void checkCast(JvmTypeReference concreteSyntax, LightweightTypeReference toType, LightweightTypeReference fromType) {
        super.checkCast(concreteSyntax, toType, fromType);
        this.castValidator.checkCast(this, concreteSyntax, toType, fromType);
    }

    @Check(value=CheckType.NORMAL)
    public void checkCasts(XCastedExpression cast) {
        if (!this.castValidator.checkCasts(this, cast)) {
            super.checkCasts(cast);
        }
    }

    protected boolean isValueExpectedRecursive(XExpression expr) {
        EObject container = expr.eContainer();
        if (container instanceof SarlBreakExpression) {
            return false;
        }
        if (container instanceof SarlContinueExpression) {
            return false;
        }
        if (container instanceof SarlAssertExpression) {
            return true;
        }
        if (container instanceof RichString || container instanceof RichStringForLoop || container instanceof XtendField) {
            return true;
        }
        return super.isValueExpectedRecursive(expr);
    }

    @Override
    public IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject eObject) {
        IssueSeverities severities = super.getIssueSeverities(context, eObject);
        return this.warningSuppressor.getIssueSeverities(context, eObject, severities);
    }

    protected boolean isInitialized(JvmField input) {
        if (super.isInitialized(input)) {
            return true;
        }
        XtendField sarlField = (XtendField)this.associations.getPrimarySourceElement((EObject)input);
        if (sarlField == null) {
            return false;
        }
        XtendTypeDeclaration declaringType = sarlField.getDeclaringType();
        if (declaringType == null) {
            return false;
        }
        for (XtendConstructor staticConstructor : Iterables.filter((Iterable)Iterables.filter((Iterable)declaringType.getMembers(), XtendConstructor.class), it -> it.isStatic())) {
            if (staticConstructor.getExpression() == null) continue;
            for (XAssignment assign : EcoreUtil2.getAllContentsOfType((EObject)staticConstructor.getExpression(), XAssignment.class)) {
                if (!assign.isStatic() || !Strings.equal((String)input.getIdentifier(), (String)assign.getFeature().getIdentifier())) continue;
                this.readAndWriteTracking.markInitialized((EObject)input, null);
                return true;
            }
        }
        return false;
    }

    protected void checkAssignment(XExpression expression, EStructuralFeature feature, boolean simpleAssignment) {
        XAbstractFeatureCall cvalue;
        JvmIdentifiableElement assignmentFeature;
        if (simpleAssignment && expression instanceof XAbstractFeatureCall && (assignmentFeature = (cvalue = (XAbstractFeatureCall)expression).getFeature()) instanceof JvmField) {
            JvmOperation operation;
            JvmField field = (JvmField)assignmentFeature;
            if (!field.isFinal()) {
                return;
            }
            JvmIdentifiableElement container = this.getLogicalContainerProvider().getNearestLogicalContainer((EObject)expression);
            if (container != null && container instanceof JvmOperation && (operation = (JvmOperation)container).isStatic() && field.getDeclaringType() == operation.getDeclaringType() && Utils.isStaticConstructorName(operation.getSimpleName())) {
                return;
            }
        }
        super.checkAssignment(expression, feature, simpleAssignment);
    }

    @Override
    public void doCheckFinalFieldInitialization(JvmGenericType type, ValidationMessageAcceptor acceptor) {
        assert (type != null);
        this.temporaryMessageAcceptor = acceptor;
        super.checkFinalFieldInitialization(type);
    }

    private ValidationMessageAcceptor getTemporaryMessageAcceptor() {
        ValidationMessageAcceptor acceptor = this.temporaryMessageAcceptor;
        if (acceptor == null) {
            acceptor = this.getMessageAcceptor();
        }
        return acceptor;
    }

    protected void reportUninitializedField(JvmField field) {
        ValidationMessageAcceptor acceptor = this.getTemporaryMessageAcceptor();
        EObject element = this.associations.getPrimarySourceElement((EObject)field);
        if (element instanceof XtendField) {
            acceptor.acceptError(MessageFormat.format(Messages.SARLValidator_1, field.getSimpleName()), element, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
        } else {
            acceptor.acceptError(MessageFormat.format(Messages.SARLValidator_2, field.getSimpleName()), element, null, -1, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
        }
    }

    protected void reportUninitializedField(JvmField field, JvmConstructor constructor) {
        ValidationMessageAcceptor acceptor = this.getTemporaryMessageAcceptor();
        EObject sourceElement = this.associations.getPrimarySourceElement((EObject)constructor);
        if (sourceElement != null) {
            if (this.associations.getXtendField(field) != null) {
                acceptor.acceptError(MessageFormat.format(Messages.SARLValidator_1, field.getSimpleName()), sourceElement, null, -1, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
            } else {
                acceptor.acceptError(MessageFormat.format(Messages.SARLValidator_2, field.getSimpleName()), sourceElement, null, -1, "org.eclipse.xtend.core.validation.IssueCodes.field_not_initialized", new String[0]);
            }
        }
    }

    protected boolean isLocalClassSemantics(EObject object) {
        return super.isLocalClassSemantics(object) || object instanceof XtendMember && !(object instanceof AnonymousClass);
    }

    @Check(value=CheckType.NORMAL)
    public void checkDeprecated(XImportDeclaration decl) {
        XtendFile file = (XtendFile)EcoreUtil2.getContainerOfType((EObject)decl, XtendFile.class);
        if (file != null) {
            for (XtendTypeDeclaration t : file.getXtendTypes()) {
                for (EObject e : this.jvmModelAssociations.getJvmElements((EObject)t)) {
                    JvmAnnotationTarget cvalue;
                    if (!(e instanceof JvmAnnotationTarget) || !DeprecationUtil.isDeprecated((JvmAnnotationTarget)(cvalue = (JvmAnnotationTarget)e))) continue;
                    return;
                }
                if (!SARLValidator.hasAnnotation((XtendAnnotationTarget)t, Deprecated.class)) continue;
                return;
            }
        }
        super.checkDeprecated(decl);
    }

    private static boolean hasAnnotation(XtendAnnotationTarget source, Class<?> class1) {
        for (XAnnotation anno : source.getAnnotations()) {
            if (anno == null || anno.getAnnotationType() == null || !class1.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean doCheckValidSuperTypeArgumentDefinition(LightweightTypeReference typeRef, EObject context, EStructuralFeature feature, int superTypeIndex, boolean allowWildcardAsAny, boolean rawTypeWarningIfNoArgument, ValidationMessageAcceptor messageAcceptor) {
        JvmTypeParameterDeclarator cvalue;
        EList typeParameters;
        JvmType superType = typeRef.getType();
        if (superType instanceof JvmTypeParameterDeclarator && !(typeParameters = (cvalue = (JvmTypeParameterDeclarator)superType).getTypeParameters()).isEmpty()) {
            List<LightweightTypeReference> initialTypeArguments = typeRef.getTypeArguments();
            if (rawTypeWarningIfNoArgument && (initialTypeArguments == null || initialTypeArguments.isEmpty())) {
                if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.raw_type")) {
                    messageAcceptor.acceptWarning(MessageFormat.format(Messages.SARLValidator_4, typeRef.getSimpleName(), Utils.getHumanReadableTypeParametersWithBounds((List<JvmTypeParameter>)typeParameters, this.grammarAccess)), context, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type", new String[0]);
                }
                return true;
            }
            List<LightweightTypeReference> typeArguments = allowWildcardAsAny ? this.sarlTypeChecker.substituteRootWildcard(initialTypeArguments, (List<JvmTypeParameter>)typeParameters, typeRef.getOwner()) : initialTypeArguments;
            boolean isConformant = this.sarlTypeChecker.isTypeArgumentConformant(typeArguments, (List<JvmTypeParameter>)typeParameters, typeRef.getOwner());
            if (!isConformant) {
                messageAcceptor.acceptError(MessageFormat.format(Messages.SARLValidator_3, Utils.getHumanReadableTypeArgumentsWithoutBounds(typeRef, typeParameters.size(), this.grammarAccess), Utils.getHumanReadableTypeParametersWithBounds((List<JvmTypeParameter>)typeParameters, this.grammarAccess), superType.getSimpleName()), context, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch", new String[0]);
                return false;
            }
        }
        return true;
    }
}

