/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.validation.ISARLValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.lang.ref.WeakReference;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.IVisibilityHelper;
import org.eclipse.xtext.xbase.validation.JvmGenericTypeValidator;

public abstract class AbstractSARLJvmGenericTypeValidator
extends JvmGenericTypeValidator {
    @Inject
    private SarlJvmModelAssociations associations;
    @Inject
    private SARLGrammarKeywordAccess grammarAccess;
    @Inject
    private OverrideHelper overrideHelper;
    @Inject
    private IVisibilityHelper visibilityHelper;
    @Inject
    private Provider<ISARLValidator> parentValidatorProvider;
    private WeakReference<ISARLValidator> parentValidator;

    public IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject eObject) {
        return this.getParentValidator().getIssueSeverities(context, eObject);
    }

    public ISARLValidator getParentValidator() {
        ISARLValidator ref;
        ISARLValidator iSARLValidator = ref = this.parentValidator == null ? null : (ISARLValidator)this.parentValidator.get();
        if (ref == null) {
            ref = (ISARLValidator)this.parentValidatorProvider.get();
            this.parentValidator = new WeakReference<ISARLValidator>(ref);
        }
        return ref;
    }

    protected IVisibilityHelper getVisibilityHelper() {
        return this.visibilityHelper;
    }

    protected OverrideHelper getOverrideHelper() {
        return this.overrideHelper;
    }

    protected SARLGrammarKeywordAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    protected SarlJvmModelAssociations getAssociations() {
        return this.associations;
    }

    protected EStructuralFeature nameFeature(EObject member) {
        if (member instanceof XtendFunction) {
            return XtendPackage.Literals.XTEND_FUNCTION__NAME;
        }
        if (member instanceof XtendField) {
            return XtendPackage.Literals.XTEND_FIELD__NAME;
        }
        return null;
    }

    protected EStructuralFeature returnTypeFeature(EObject member) {
        if (member instanceof XtendFunction) {
            return XtendPackage.Literals.XTEND_FUNCTION__RETURN_TYPE;
        }
        return null;
    }

    protected static String canonicalName(LightweightTypeReference typeRef) {
        return typeRef == null ? Messages.AbstractSARLSubValidator_4 : typeRef.getHumanReadableName();
    }

    protected boolean isIgnored(String issueCode, EObject currentObject) {
        IssueSeverities severities = this.getIssueSeverities(this.getContext(), currentObject);
        return severities.isIgnored(issueCode);
    }
}

