/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.inject.Inject;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.jvmmodel.SARLReadAndWriteTracking;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlArtifact;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.SarlSpace;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.typesystem.IImmutableTypeValidator;
import io.sarl.lang.typesystem.InheritanceHelper;
import io.sarl.lang.typesystem.SARLOperationHelper;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.IProgrammaticWarningSuppressor;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.EValidatorRegistrar;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.util.XbaseUsageCrossReferencer;
import org.eclipse.xtext.xbase.validation.FeatureNameValidator;

public abstract class AbstractSARLSubValidator
extends AbstractDeclarativeValidator {
    @Inject
    private SarlJvmModelAssociations associations;
    @Inject
    private SARLReadAndWriteTracking readAndWriteTracking;
    @Inject
    private SARLGrammarKeywordAccess grammarAccess;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private XExpressionHelper expressionHelper;
    @Inject
    private IImmutableTypeValidator immutableTypeValidator;
    @Inject
    private FeatureNameValidator featureNameValidator;
    @Inject
    private IActionPrototypeProvider sarlActionSignatures;
    @Inject
    private InheritanceHelper inheritanceHelper;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private SARLOperationHelper operationHelper;
    @Inject
    private JavaKeywords javaUtils;
    @Inject
    private IProgrammaticWarningSuppressor warningSuppressor;
    private List<String> visibilityModifiers;

    public IssueSeverities getIssueSeverities(Map<Object, Object> context, EObject eObject) {
        IssueSeverities severities = super.getIssueSeverities(context, eObject);
        return this.warningSuppressor.getIssueSeverities(context, eObject, severities);
    }

    protected List<String> getVisibilityModifiers() {
        if (this.visibilityModifiers == null) {
            this.visibilityModifiers = new ArrayList<String>();
            this.visibilityModifiers.add(this.grammarAccess.getPublicKeyword());
            this.visibilityModifiers.add(this.grammarAccess.getProtectedKeyword());
            this.visibilityModifiers.add(this.grammarAccess.getPackageKeyword());
            this.visibilityModifiers.add(this.grammarAccess.getPrivateKeyword());
        }
        return this.visibilityModifiers;
    }

    protected SARLOperationHelper getOperationHelper() {
        return this.operationHelper;
    }

    protected ILogicalContainerProvider getLogicalContainerProvider() {
        return this.logicalContainerProvider;
    }

    protected TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    protected InheritanceHelper getInheritanceHelper() {
        return this.inheritanceHelper;
    }

    protected IActionPrototypeProvider getSarlActionSignatures() {
        return this.sarlActionSignatures;
    }

    protected FeatureNameValidator getFeatureNameValidator() {
        return this.featureNameValidator;
    }

    protected IImmutableTypeValidator getImmutableTypeValidator() {
        return this.immutableTypeValidator;
    }

    protected XExpressionHelper getExpressionHelper() {
        return this.expressionHelper;
    }

    protected CommonTypeComputationServices getServices() {
        return this.services;
    }

    protected SarlJvmModelAssociations getAssociations() {
        return this.associations;
    }

    protected SARLReadAndWriteTracking getReadAndWriteTracking() {
        return this.readAndWriteTracking;
    }

    protected SARLGrammarKeywordAccess getGrammarAccess() {
        return this.grammarAccess;
    }

    public void register(EValidatorRegistrar registrar) {
    }

    protected final EObject getOutermostType(XtendMember member) {
        XtendTypeDeclaration result = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)member, XtendTypeDeclaration.class);
        if (result == null) {
            return member.eContainer();
        }
        while (!(result.eContainer() instanceof SarlScript)) {
            XtendTypeDeclaration next = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)result.eContainer(), XtendTypeDeclaration.class);
            if (next == null) {
                return result;
            }
            result = next;
        }
        return result;
    }

    protected boolean isLocallyAssigned(EObject target, EObject containerToFindUsage) {
        if (this.getReadAndWriteTracking().isAssigned(target)) {
            return true;
        }
        Collection usages = XbaseUsageCrossReferencer.find((EObject)target, (EObject)containerToFindUsage);
        for (EStructuralFeature.Setting usage : usages) {
            XAssignment assignment;
            EObject object = usage.getEObject();
            if (!(object instanceof XAssignment) || (assignment = (XAssignment)object).getFeature() != target) continue;
            this.getReadAndWriteTracking().markAssignmentAccess(target);
            return true;
        }
        return false;
    }

    protected boolean isIgnored(String issueCode, EObject currentObject) {
        IssueSeverities severities = this.getIssueSeverities(this.getContext(), currentObject);
        return severities.isIgnored(issueCode);
    }

    protected boolean doCheckValidMemberName(XtendMember member) {
        String name;
        EStructuralFeature nameAttribute = member.eClass().getEStructuralFeature("name");
        if (nameAttribute != null && (name = (String)member.eGet(nameAttribute)) != null) {
            if (name.equals(this.getGrammarAccess().getThisKeyword()) || name.equals(this.getGrammarAccess().getItKeyword()) || name.equals(this.getGrammarAccess().getOccurrenceKeyword())) {
                this.error(MessageFormat.format(Messages.AbstractSARLSubValidator_1, name), nameAttribute, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
                return false;
            }
            if (SarlUtils.isHiddenMember((String)name)) {
                this.error(MessageFormat.format(Messages.AbstractSARLSubValidator_2, "$"), nameAttribute, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
                return false;
            }
        }
        return true;
    }

    protected static String canonicalName(LightweightTypeReference typeRef) {
        return typeRef == null ? Messages.AbstractSARLSubValidator_4 : typeRef.getHumanReadableName();
    }

    protected String getNameOfTypes(LightweightTypeReference expectedType) {
        final StringBuilder result = new StringBuilder(AbstractSARLSubValidator.canonicalName(expectedType));
        this.getServices().getSynonymTypesProvider().collectSynonymTypes(expectedType, new SynonymTypesProvider.Acceptor(this){

            protected boolean accept(LightweightTypeReference synonym, int flags) {
                result.append(Messages.AbstractSARLSubValidator_3).append(AbstractSARLSubValidator.canonicalName(synonym));
                return true;
            }
        });
        return result.toString();
    }

    protected LightweightTypeReference getActualType(EObject context, JvmIdentifiableElement element) {
        return this.typeResolver.resolveTypes(context).getActualType(element);
    }

    protected LightweightTypeReference getActualType(XExpression expression) {
        return this.typeResolver.resolveTypes((EObject)expression).getActualType(expression);
    }

    protected LightweightTypeReference getActualType(JvmIdentifiableElement identifiable) {
        return this.typeResolver.resolveTypes((EObject)identifiable).getActualType(identifiable);
    }

    protected LightweightTypeReference getExpectedType(XExpression expression) {
        return this.typeResolver.resolveTypes((EObject)expression).getExpectedType(expression);
    }

    protected static XMemberFeatureCall getRootOfMemberFeatureCallSequence(EObject leaf, EObject container, Procedures.Procedure1<XMemberFeatureCall> feedback) {
        XMemberFeatureCall cvalue;
        EObject call = leaf;
        XExpression obj = (XExpression)EcoreUtil2.getContainerOfType((EObject)leaf.eContainer(), XExpression.class);
        while (obj != null && (container == null || obj != container)) {
            if (obj instanceof XMemberFeatureCall) {
                XMemberFeatureCall fcall = (XMemberFeatureCall)obj;
                EObject previous = call;
                call = fcall;
                if (fcall.getActualReceiver() == previous) {
                    if (feedback != null) {
                        feedback.apply((Object)fcall);
                    }
                    obj = (XExpression)EcoreUtil2.getContainerOfType((EObject)call.eContainer(), XExpression.class);
                    continue;
                }
                if (fcall.getActualArguments().contains((Object)previous)) {
                    call = previous;
                    obj = null;
                    continue;
                }
                obj = null;
                continue;
            }
            obj = null;
        }
        return call instanceof XMemberFeatureCall ? (cvalue = (XMemberFeatureCall)call) : null;
    }

    protected boolean isImmutable(EObject element) {
        LightweightTypeReference calledFeatureType = null;
        if (element instanceof XExpression) {
            XExpression cvalue = (XExpression)element;
            calledFeatureType = this.getActualType(cvalue);
        } else if (element instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement cvalue = (JvmIdentifiableElement)element;
            calledFeatureType = this.getActualType(cvalue);
        }
        if (calledFeatureType != null) {
            return this.getImmutableTypeValidator().isImmutable(calledFeatureType);
        }
        return false;
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef) {
        return this.toLightweightTypeReference(typeRef, false);
    }

    protected LightweightTypeReference toLightweightTypeReference(JvmTypeReference typeRef, boolean keepUnboundWildcardInformation) {
        StandardTypeReferenceOwner owner = new StandardTypeReferenceOwner(this.getServices(), (EObject)typeRef);
        LightweightTypeReferenceFactory factory = new LightweightTypeReferenceFactory((ITypeReferenceOwner)owner, keepUnboundWildcardInformation);
        LightweightTypeReference reference = factory.toLightweightReference(typeRef);
        return reference;
    }

    protected List<LightweightTypeReference> getParamTypeReferences(JvmExecutable jvmExecutable, boolean wrapFromPrimitives, boolean wrapToPrimitives) {
        assert (wrapFromPrimitives && !wrapToPrimitives || wrapToPrimitives && !wrapFromPrimitives);
        ArrayList<LightweightTypeReference> types = new ArrayList<LightweightTypeReference>();
        for (JvmFormalParameter parameter : jvmExecutable.getParameters()) {
            LightweightTypeReference typeReference = this.toLightweightTypeReference(parameter.getParameterType());
            if (wrapFromPrimitives) {
                typeReference = typeReference.getWrapperTypeIfPrimitive();
            } else if (wrapToPrimitives) {
                typeReference = typeReference.getPrimitiveIfWrapperType();
            }
            types.add(typeReference);
        }
        return types;
    }

    protected boolean isReallyDisallowedName(QualifiedName name) {
        if (this.getFeatureNameValidator().isDisallowedName(name)) {
            return true;
        }
        String base = name.getLastSegment();
        return SarlUtils.isHiddenMember((String)base) && Utils.isImplicitLambdaParameterName(base);
    }

    protected String typeName(XtendTypeDeclaration declaration) {
        EObject jvmObject;
        if (declaration != null && (jvmObject = this.getServices().getJvmModelAssociations().getPrimaryJvmElement((EObject)declaration)) instanceof JvmType) {
            JvmType jvmType = (JvmType)jvmObject;
            String name = jvmType.getSimpleName();
            StringBuilder fullLabel = new StringBuilder();
            if (declaration instanceof SarlAgent) {
                fullLabel.append(this.getGrammarAccess().getAgentKeyword());
            } else if (declaration instanceof SarlBehavior) {
                fullLabel.append(this.getGrammarAccess().getBehaviorKeyword());
            } else if (declaration instanceof SarlCapacity) {
                fullLabel.append(this.getGrammarAccess().getCapacityKeyword());
            } else if (declaration instanceof SarlEvent) {
                fullLabel.append(this.getGrammarAccess().getEventKeyword());
            } else if (declaration instanceof SarlSkill) {
                fullLabel.append(this.getGrammarAccess().getSkillKeyword());
            } else if (declaration instanceof XtendClass) {
                fullLabel.append(this.getGrammarAccess().getClassKeyword());
            } else if (declaration instanceof XtendInterface) {
                fullLabel.append(this.getGrammarAccess().getInterfaceKeyword());
            } else if (declaration instanceof XtendEnum) {
                fullLabel.append(this.getGrammarAccess().getEnumKeyword());
            } else if (declaration instanceof XtendAnnotationType) {
                fullLabel.append(this.getGrammarAccess().getAnnotationKeyword());
            } else if (declaration instanceof SarlSpace) {
                fullLabel.append(this.getGrammarAccess().getSpaceKeyword());
            } else if (declaration instanceof SarlArtifact) {
                fullLabel.append(this.getGrammarAccess().getArtifactKeyword());
            } else {
                throw new IllegalStateException();
            }
            fullLabel.append(' ').append(name);
            return fullLabel.toString();
        }
        return null;
    }

    protected String memberName(XtendField field) {
        String memberName = null;
        if (field != null) {
            LightweightTypeReference type;
            JvmField jvmField;
            if (field.isExtension() && field.getName() == null && (jvmField = this.getAssociations().getJvmField(field)) != null && (type = this.getActualType((JvmIdentifiableElement)jvmField)) != null) {
                memberName = MessageFormat.format(Messages.AbstractSARLSubValidator_6, type.getHumanReadableName());
            }
            if (memberName == null) {
                memberName = MessageFormat.format(Messages.AbstractSARLSubValidator_5, field.getName());
            }
        }
        return memberName;
    }

    protected String memberName(XtendFunction function) {
        if (function != null) {
            XtendTypeDeclaration container = function.getDeclaringType();
            if (this.isAOContainer(container)) {
                return MessageFormat.format(Messages.AbstractSARLSubValidator_7, function.getName());
            }
            return MessageFormat.format(Messages.AbstractSARLSubValidator_8, function.getName());
        }
        return null;
    }

    protected String canonicalName(EObject object) {
        if (object instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement cvalue = (JvmIdentifiableElement)object;
            return cvalue.getQualifiedName();
        }
        EObject jvmElement = this.associations.getPrimaryJvmElement(object);
        if (jvmElement instanceof JvmIdentifiableElement) {
            JvmIdentifiableElement cvalue = (JvmIdentifiableElement)jvmElement;
            return cvalue.getQualifiedName();
        }
        return null;
    }

    protected boolean isAOConstructorContainer(XtendTypeDeclaration type) {
        return type instanceof SarlAgent || type instanceof SarlBehavior || type instanceof SarlSkill || type instanceof SarlEvent;
    }

    protected boolean isAOContainer(XtendTypeDeclaration type) {
        return type instanceof SarlAgent || type instanceof SarlBehavior || type instanceof SarlCapacity || type instanceof SarlSkill || type instanceof SarlEvent || type instanceof SarlSpace;
    }

    protected boolean isTypeFreeExpression(XExpression expression) {
        return expression instanceof XNullLiteral;
    }

    protected Iterator<? extends XAbstractFeatureCall> getAllFeatureCalls(XExpression expr) {
        Object iter;
        if (expr instanceof XAbstractFeatureCall) {
            UnmodifiableIterator iter2 = Iterators.filter((Iterator)expr.eAllContents(), XAbstractFeatureCall.class);
            UnmodifiableIterator iter3 = Iterators.singletonIterator((Object)((XAbstractFeatureCall)expr));
            iter = iter2.hasNext() ? Iterators.concat((Iterator)iter3, (Iterator)iter2) : iter3;
        } else {
            iter = Iterators.filter((Iterator)expr.eAllContents(), XAbstractFeatureCall.class);
        }
        return iter;
    }

    protected String getDeclaratorName(JvmFeature feature) {
        if (feature != null) {
            JvmDeclaredType declarator = feature.getDeclaringType();
            if (declarator.isLocal()) {
                return this.getGrammarAccess().getNewKeyword() + ((JvmTypeReference)Iterables.getLast((Iterable)declarator.getSuperTypes())).getType().getSimpleName();
            }
            return declarator.getSimpleName();
        }
        return "";
    }

    protected void checkNoJavaKeyword(EObject obj, EAttribute attribute) {
        Object name = obj.eGet((EStructuralFeature)attribute);
        if (name != null && this.javaUtils.isJavaKeyword(name.toString())) {
            this.error(MessageFormat.format(Messages.AbstractSARLSubValidator_9, name), obj, (EStructuralFeature)attribute, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_identifier", new String[0]);
        }
    }
}

