/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Inject;
import io.sarl.lang.core.DefaultSkill;
import io.sarl.lang.core.annotation.EarlyExit;
import io.sarl.lang.core.annotation.ErrorOnCall;
import io.sarl.lang.core.annotation.InfoOnCall;
import io.sarl.lang.core.annotation.WarningOnCall;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlAnnotationType;
import io.sarl.lang.sarl.SarlArtifact;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlEnumeration;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.SarlInterface;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.SarlSpace;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidatorWithParentLink;
import io.sarl.lang.validation.subvalidators.Messages;
import java.lang.annotation.ElementType;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtend.lib.annotations.Delegate;
import org.eclipse.xtend.lib.annotations.EqualsHashCode;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtend.lib.annotations.ToString;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmCustomAnnotationValue;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.annotations.typing.XAnnotationUtil;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationsPackage;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SARLAnnotationValidator
extends AbstractSARLSubValidatorWithParentLink {
    protected final Multimap<Class<?>, ElementType> targetInfos;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private XAnnotationUtil annotationUtil;
    @Inject
    private AnnotationLookup annotationLookup;

    public SARLAnnotationValidator() {
        ImmutableMultimap.Builder result = ImmutableMultimap.builder();
        result.put(XtendClass.class, (Object)ElementType.TYPE);
        result.put(XtendInterface.class, (Object)ElementType.TYPE);
        result.put(XtendEnum.class, (Object)ElementType.TYPE);
        result.putAll(XtendAnnotationType.class, (Object[])new ElementType[]{ElementType.ANNOTATION_TYPE, ElementType.TYPE});
        result.put(XtendField.class, (Object)ElementType.FIELD);
        result.put(XtendFunction.class, (Object)ElementType.METHOD);
        result.put(XtendParameter.class, (Object)ElementType.PARAMETER);
        result.put(SarlAgent.class, (Object)ElementType.TYPE);
        result.put(SarlCapacity.class, (Object)ElementType.TYPE);
        result.put(SarlSkill.class, (Object)ElementType.TYPE);
        result.put(SarlEvent.class, (Object)ElementType.TYPE);
        result.put(SarlBehavior.class, (Object)ElementType.TYPE);
        result.put(SarlSpace.class, (Object)ElementType.TYPE);
        result.put(SarlArtifact.class, (Object)ElementType.TYPE);
        result.put(SarlClass.class, (Object)ElementType.TYPE);
        result.put(SarlInterface.class, (Object)ElementType.TYPE);
        result.put(SarlEnumeration.class, (Object)ElementType.TYPE);
        result.putAll(SarlAnnotationType.class, (Object[])new ElementType[]{ElementType.ANNOTATION_TYPE, ElementType.TYPE});
        result.put(SarlField.class, (Object)ElementType.FIELD);
        result.put(SarlAction.class, (Object)ElementType.METHOD);
        result.put(SarlFormalParameter.class, (Object)ElementType.PARAMETER);
        this.targetInfos = result.build();
    }

    @Check(value=CheckType.NORMAL)
    public void checkReservedAnnotation(XtendAnnotationTarget annotationTarget) {
        if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.use_reserved_sarl_annotation")) {
            if (annotationTarget.getAnnotations().isEmpty() || !this.isRelevantAnnotationTarget(annotationTarget)) {
                return;
            }
            QualifiedName reservedPackage = this.qualifiedNameConverter.toQualifiedName(EarlyExit.class.getPackage().getName());
            String earlyExitAnnotation = EarlyExit.class.getName();
            String errorOnCallAnnotation = ErrorOnCall.class.getName();
            String warningOnCallAnnotation = WarningOnCall.class.getName();
            String infoOnCallAnnotation = InfoOnCall.class.getName();
            for (XAnnotation annotation : annotationTarget.getAnnotations()) {
                QualifiedName annotationName;
                JvmType type = annotation.getAnnotationType();
                if (type == null || type.eIsProxy()) continue;
                if (Objects.equals(type.getIdentifier(), earlyExitAnnotation)) {
                    if (annotationTarget instanceof SarlEvent) continue;
                    this.addIssue(MessageFormat.format(Messages.SARLAnnotationValidator_1, type.getSimpleName()), (EObject)annotation, "io.sarl.lang.validation.IssueCodes.use_reserved_sarl_annotation");
                    continue;
                }
                if (Objects.equals(type.getIdentifier(), errorOnCallAnnotation) || Objects.equals(type.getIdentifier(), warningOnCallAnnotation) || Objects.equals(type.getIdentifier(), infoOnCallAnnotation) || !(annotationName = this.qualifiedNameConverter.toQualifiedName(type.getIdentifier())).startsWith(reservedPackage)) continue;
                this.addIssue(MessageFormat.format(Messages.SARLAnnotationValidator_1, type.getSimpleName()), (EObject)annotation, "io.sarl.lang.validation.IssueCodes.use_reserved_sarl_annotation");
            }
        }
    }

    private boolean isRelevantAnnotationTarget(final XtendAnnotationTarget annotationTarget) {
        return Iterables.any((Iterable)this.targetInfos.keySet(), (Predicate)new Predicate<Class<?>>(){

            public boolean apply(Class<?> input) {
                return input.isInstance(annotationTarget);
            }
        });
    }

    private boolean isForbiddenActiveAnnotation(XAnnotation annotation) {
        String name = annotation.getAnnotationType().getQualifiedName();
        return Strings.equal((String)EqualsHashCode.class.getName(), (String)name) || Strings.equal((String)FinalFieldsConstructor.class.getName(), (String)name);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkManualInlineDefinition(XtendAnnotationTarget annotationTarget) {
        if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.manual_inline_definition")) {
            if (annotationTarget.getAnnotations().isEmpty() || !this.isRelevantAnnotationTarget(annotationTarget)) {
                return;
            }
            String inlineAnnotation = Inline.class.getName();
            for (XAnnotation annotation : annotationTarget.getAnnotations()) {
                JvmType type = annotation.getAnnotationType();
                if (type == null || type.eIsProxy() || !Objects.equals(type.getIdentifier(), inlineAnnotation)) continue;
                this.addIssue(Messages.SARLAnnotationValidator_2, (EObject)annotation, "io.sarl.lang.validation.IssueCodes.manual_inline_definition");
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDefaultSkillAnnotation(SarlCapacity capacity) {
        String annotationId = DefaultSkill.class.getName();
        XAnnotation annotation = (XAnnotation)IterableExtensions.findFirst((Iterable)capacity.getAnnotations(), it -> Strings.equal((String)annotationId, (String)it.getAnnotationType().getIdentifier()));
        if (annotation != null) {
            XTypeLiteral typeLiteral;
            JvmType type;
            XExpression expr = annotation.getValue();
            if (expr instanceof XTypeLiteral && (type = (typeLiteral = (XTypeLiteral)expr).getType()) != null && !type.eIsProxy()) {
                LightweightTypeReference reference = this.getParentValidator().toLightweightTypeReference(type, (EObject)capacity);
                if (this.getInheritanceHelper().isSarlSkill(reference)) {
                    EObject element = this.getAssociations().getPrimaryJvmElement((EObject)capacity);
                    assert (element instanceof JvmType);
                    if (!reference.isSubtypeOf((JvmType)element)) {
                        this.error(MessageFormat.format(Messages.SARLAnnotationValidator_3, capacity.getName(), type.getSimpleName()), (EObject)expr, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_default_skill_annotation", new String[0]);
                    }
                    return;
                }
            }
            this.error(Messages.SARLAnnotationValidator_4, (EObject)expr, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_default_skill_annotation", new String[0]);
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkProgrammaticIssueMessage(XAbstractFeatureCall expression) {
        JvmIdentifiableElement feature;
        if (expression != null && expression.getFeature() != null && (feature = expression.getFeature()) instanceof JvmAnnotationTarget) {
            JvmAnnotationTarget target = (JvmAnnotationTarget)feature;
            String errorAnnoName = ErrorOnCall.class.getName();
            String warningAnnoName = WarningOnCall.class.getName();
            String infoAnnoName = InfoOnCall.class.getName();
            for (JvmAnnotationReference annotation : target.getAnnotations()) {
                String message;
                EList values = annotation.getValues();
                if (values.isEmpty()) continue;
                if (Objects.equals(errorAnnoName, annotation.getAnnotation().getIdentifier())) {
                    message = SARLAnnotationValidator.parseIssueOnCallAnnotation((List<JvmAnnotationValue>)values);
                    this.error(message, (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.programmatic_issue_annotation", new String[0]);
                    continue;
                }
                if (Objects.equals(warningAnnoName, annotation.getAnnotation().getIdentifier())) {
                    message = SARLAnnotationValidator.parseIssueOnCallAnnotation((List<JvmAnnotationValue>)values);
                    this.warning(message, (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.programmatic_issue_annotation", new String[0]);
                    continue;
                }
                if (!Objects.equals(infoAnnoName, annotation.getAnnotation().getIdentifier())) continue;
                message = SARLAnnotationValidator.parseIssueOnCallAnnotation((List<JvmAnnotationValue>)values);
                this.info(message, (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.programmatic_issue_annotation", new String[0]);
            }
        }
    }

    private static String parseIssueOnCallAnnotation(List<JvmAnnotationValue> values) {
        StringBuilder message = new StringBuilder();
        for (JvmAnnotationValue value : values) {
            if (value instanceof JvmStringAnnotationValue) {
                JvmStringAnnotationValue cvalue = (JvmStringAnnotationValue)value;
                message.append(cvalue.getValues());
                continue;
            }
            if (!(value instanceof JvmCustomAnnotationValue)) continue;
            JvmCustomAnnotationValue cvalue = (JvmCustomAnnotationValue)value;
            for (EObject obj : cvalue.getValues()) {
                if (!(obj instanceof XStringLiteral)) continue;
                XStringLiteral cvalue0 = (XStringLiteral)obj;
                message.append(cvalue0.getValue());
            }
        }
        return message.toString();
    }

    protected boolean isOOActiveAnnotation(XAnnotation annotation) {
        String name = annotation.getAnnotationType().getQualifiedName();
        return Strings.equal((String)Accessors.class.getName(), (String)name) || Strings.equal((String)Data.class.getName(), (String)name) || Strings.equal((String)Delegate.class.getName(), (String)name) || Strings.equal((String)ToString.class.getName(), (String)name);
    }

    protected boolean isAOActiveAnnotation(XAnnotation annotation) {
        String name = annotation.getAnnotationType().getQualifiedName();
        return Strings.equal((String)Accessors.class.getName(), (String)name);
    }

    protected boolean isAOActiveAnnotationReceiver(XtendTypeDeclaration container) {
        return container instanceof SarlAgent || container instanceof SarlBehavior || container instanceof SarlSkill;
    }

    protected boolean isOOType(XtendTypeDeclaration type) {
        return type instanceof XtendClass || type instanceof XtendInterface || type instanceof XtendEnum || type instanceof XtendAnnotationType;
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkAnnotationTarget(XAnnotation annotation) {
        JvmType annotationType = annotation.getAnnotationType();
        if (annotationType == null || annotationType.eIsProxy() || !(annotationType instanceof JvmAnnotationType)) {
            return;
        }
        Set targets = this.annotationUtil.getAnnotationTargets((JvmAnnotationType)annotationType);
        if (targets.isEmpty()) {
            return;
        }
        EObject eContainer = SARLAnnotationValidator.getContainingAnnotationTarget(annotation);
        Class<XtendFunction> clazz = eContainer.getClass();
        if (eContainer instanceof XtendField && eContainer.eContainer() instanceof XtendAnnotationType) {
            clazz = XtendFunction.class;
        }
        for (Map.Entry mapping : this.targetInfos.asMap().entrySet()) {
            if (!((Class)mapping.getKey()).isAssignableFrom(clazz)) continue;
            targets.retainAll((Collection)mapping.getValue());
            if (!targets.isEmpty()) continue;
            this.error(MessageFormat.format(Messages.SARLAnnotationValidator_5, annotation.getAnnotationType().getSimpleName()), (EObject)annotation, null, -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_annotation_target", new String[0]);
        }
        if (this.isForbiddenActiveAnnotation(annotation)) {
            this.error(Messages.SARLAnnotationValidator_6, (EObject)annotation, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
        } else if (this.isOOActiveAnnotation(annotation) || this.isAOActiveAnnotation(annotation)) {
            XtendTypeDeclaration container = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)annotation.eContainer(), XtendTypeDeclaration.class);
            while (container != null && (container.isAnonymous() || container.getName() == null)) {
                container = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)container.eContainer(), XtendTypeDeclaration.class);
            }
            if (container != null) {
                if (this.isOOType(container)) {
                    if (!this.isOOActiveAnnotation(annotation)) {
                        this.error(MessageFormat.format(Messages.SARLAnnotationValidator_7, container.getName()), (EObject)annotation, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
                    }
                } else if (!this.isAOActiveAnnotation(annotation) || !this.isAOActiveAnnotationReceiver(container)) {
                    this.error(MessageFormat.format(Messages.SARLAnnotationValidator_8, container.getName()), (EObject)annotation, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
                }
            }
        }
    }

    private static EObject getContainingAnnotationTarget(XAnnotation annotation) {
        EObject eContainer = annotation.eContainer();
        if (eContainer.eClass() == XtendPackage.Literals.XTEND_MEMBER || eContainer.eClass() == XtendPackage.Literals.XTEND_TYPE_DECLARATION) {
            return eContainer.eContainer();
        }
        return eContainer;
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkMultipleAnnotations(XtendAnnotationTarget annotationTarget) {
        if (annotationTarget.getAnnotations().size() <= 1 || !this.isRelevantAnnotationTarget(annotationTarget)) {
            return;
        }
        ImmutableListMultimap groupByIdentifier = Multimaps.index((Iterable)annotationTarget.getAnnotations(), input -> input.getAnnotationType().getIdentifier());
        for (String qName : groupByIdentifier.keySet()) {
            JvmType type;
            ImmutableList sameType = groupByIdentifier.get((Object)qName);
            if (sameType.size() <= 1 || !((type = ((XAnnotation)sameType.get(0)).getAnnotationType()) instanceof JvmAnnotationType) || type.eIsProxy() || this.annotationLookup.isRepeatable((JvmAnnotationType)type)) continue;
            for (XAnnotation xAnnotation : sameType) {
                this.error(MessageFormat.format(Messages.SARLAnnotationValidator_9, xAnnotation.getAnnotationType().getSimpleName()), (EObject)xAnnotation, (EStructuralFeature)XAnnotationsPackage.Literals.XANNOTATION__ANNOTATION_TYPE, -1, "org.eclipse.xtend.core.validation.IssueCodes.multiple_annotations_used", new String[0]);
            }
        }
    }
}

