/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.inject.Inject;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.typesystem.SARLOperationHelper;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SARLBehaviorUnitValidator
extends AbstractSARLSubValidator {
    @Inject
    private SARLOperationHelper operationHelper;

    @Check(value=CheckType.EXPENSIVE)
    public void checkBehaviorUnitGuardType(SarlBehaviorUnit behaviorUnit) {
        XExpression guard = behaviorUnit.getGuard();
        if (guard != null) {
            if (this.operationHelper.hasSideEffects(null, guard)) {
                this.error(Messages.SARLBehaviorUnitValidator_1, (EObject)guard, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_inner_expression", new String[0]);
                return;
            }
            if (guard instanceof XBooleanLiteral) {
                XBooleanLiteral booleanLiteral = (XBooleanLiteral)guard;
                if (booleanLiteral.isIsTrue()) {
                    if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_boolean_expression")) {
                        this.addIssue(Messages.SARLBehaviorUnitValidator_2, (EObject)booleanLiteral, null, -1, "io.sarl.lang.validation.IssueCodes.discouraged_boolean_expression", new String[0]);
                    }
                } else if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.unreachable_behavior_unit")) {
                    this.addIssue(Messages.SARLBehaviorUnitValidator_3, (EObject)behaviorUnit, null, -1, "io.sarl.lang.validation.IssueCodes.unreachable_behavior_unit", new String[]{behaviorUnit.getName().getSimpleName()});
                }
                return;
            }
            LightweightTypeReference fromType = this.getActualType(guard);
            if (!fromType.isAssignableFrom(Boolean.TYPE)) {
                this.error(MessageFormat.format(Messages.SARLBehaviorUnitValidator_4, this.getNameOfTypes(fromType), Boolean.TYPE.getName()), (EObject)guard, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
            }
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkUnmodifiableEventAccess(SarlBehaviorUnit unit) {
        boolean enable = !this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use");
        XExpression root = unit.getExpression();
        String occurrenceKw = this.getGrammarAccess().getOccurrenceKeyword();
        for (XFeatureCall child : EcoreUtil2.getAllContentsOfType((EObject)root, XFeatureCall.class)) {
            if (!occurrenceKw.equals(child.getFeature().getIdentifier())) continue;
            this.checkUnmodifiableFeatureAccess(enable, (EObject)child, occurrenceKw);
        }
    }

    private void checkUnmodifiableFeatureAccess(boolean enableWarning, EObject readOnlyExpression, String keywordName) {
        EObject directContainerChildInstance;
        EObject expression;
        OutParameter container = new OutParameter();
        OutParameter directContainerChild = new OutParameter();
        OutParameter failure = new OutParameter((Object)Boolean.FALSE);
        XMemberFeatureCall sequence = SARLBehaviorUnitValidator.getRootOfMemberFeatureCallSequence(readOnlyExpression, null, (Procedures.Procedure1<XMemberFeatureCall>)((Procedures.Procedure1)it -> {
            if (enableWarning && this.getExpressionHelper().hasSideEffects((XExpression)it)) {
                this.addIssue(MessageFormat.format(Messages.SARLBehaviorUnitValidator_5, keywordName), (EObject)it, "io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use");
                failure.set((Object)Boolean.TRUE);
            }
        }));
        if (((Boolean)failure.get()).booleanValue()) {
            return;
        }
        Object object = expression = sequence == null ? readOnlyExpression : sequence;
        if (Utils.getContainerOfType(expression, (OutParameter<EObject>)container, (OutParameter<EObject>)directContainerChild, XAssignment.class, XVariableDeclaration.class)) {
            Object object2 = container.get();
            if (object2 instanceof XAssignment) {
                XAssignment assignment = (XAssignment)object2;
                EObject leftMember = (EObject)directContainerChild.get();
                if (expression == leftMember && leftMember == assignment.getActualReceiver()) {
                    this.error(MessageFormat.format(Messages.SARLBehaviorUnitValidator_6, keywordName), readOnlyExpression, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_occurrence_readonly_use", new String[0]);
                    return;
                }
            } else if (enableWarning && container.get() instanceof XVariableDeclaration) {
                directContainerChildInstance = (EObject)directContainerChild.get();
                if (this.isImmutable(directContainerChildInstance)) {
                    return;
                }
                XVariableDeclaration declaration = (XVariableDeclaration)container.get();
                if (directContainerChild.get() == declaration.getRight()) {
                    LightweightTypeReference variableType = this.getActualType((XExpression)sequence);
                    if (!(this.getImmutableTypeValidator().isImmutable(variableType) || expression != null && expression != declaration.getRight())) {
                        this.addIssue(MessageFormat.format(Messages.SARLBehaviorUnitValidator_7, keywordName), (EObject)sequence, "io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use");
                        return;
                    }
                }
            }
        }
        if (enableWarning && Utils.getContainerOfType(expression, (OutParameter<EObject>)container, (OutParameter<EObject>)directContainerChild, XAbstractFeatureCall.class, XConstructorCall.class)) {
            boolean isVariadic;
            boolean hasSideEffects;
            List<LightweightTypeReference> parameters;
            EList arguments;
            EObject directExpressionContainer = (EObject)container.get();
            directContainerChildInstance = (EObject)directContainerChild.get();
            if (this.isImmutable(directContainerChildInstance)) {
                return;
            }
            if (directExpressionContainer instanceof XBinaryOperation || directExpressionContainer instanceof XUnaryOperation) {
                return;
            }
            if (directExpressionContainer instanceof XPostfixOperation) {
                this.error(MessageFormat.format(Messages.SARLBehaviorUnitValidator_8, keywordName), readOnlyExpression, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_occurrence_readonly_use", new String[0]);
                return;
            }
            if (directExpressionContainer instanceof XConstructorCall) {
                XConstructorCall cons = (XConstructorCall)directExpressionContainer;
                arguments = cons.getArguments();
                JvmConstructor constructor = cons.getConstructor();
                parameters = this.getParamTypeReferences((JvmExecutable)constructor, false, true);
                hasSideEffects = false;
                isVariadic = constructor.isVarArgs();
            } else {
                XAbstractFeatureCall call = (XAbstractFeatureCall)directExpressionContainer;
                JvmIdentifiableElement jvmIdentifiableElement = call.getFeature();
                if (jvmIdentifiableElement instanceof JvmOperation) {
                    JvmOperation operation = (JvmOperation)jvmIdentifiableElement;
                    arguments = call.getActualArguments();
                    parameters = this.getParamTypeReferences((JvmExecutable)operation, false, true);
                    hasSideEffects = this.getExpressionHelper().hasSideEffects((XExpression)call);
                    isVariadic = operation.isVarArgs();
                } else {
                    arguments = null;
                    parameters = null;
                    hasSideEffects = false;
                    isVariadic = false;
                }
            }
            if (arguments != null && hasSideEffects) {
                assert (parameters != null);
                int index = arguments.indexOf(directContainerChildInstance);
                if (index >= 0 && !parameters.isEmpty()) {
                    boolean isPrimitive;
                    int endIndex = parameters.size() - 1;
                    if (index < endIndex || !isVariadic && index == endIndex) {
                        isPrimitive = this.getImmutableTypeValidator().isImmutable(parameters.get(index));
                    } else if (isVariadic && index == endIndex) {
                        LightweightTypeReference parameter = parameters.get(endIndex);
                        assert (parameter.isArray());
                        parameter = parameter.getComponentType().getWrapperTypeIfPrimitive();
                        isPrimitive = this.getImmutableTypeValidator().isImmutable(parameter);
                    } else {
                        isPrimitive = true;
                    }
                    if (!isPrimitive) {
                        this.addIssue(MessageFormat.format(Messages.SARLBehaviorUnitValidator_9, keywordName), (EObject)sequence, "io.sarl.lang.validation.IssueCodes.discouraged_occurrence_readonly_use");
                        return;
                    }
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkBehaviorUnitEventType(SarlBehaviorUnit behaviorUnit) {
        JvmParameterizedTypeReference event = behaviorUnit.getName();
        LightweightTypeReference ref = this.toLightweightTypeReference((JvmTypeReference)event);
        if (ref == null || !this.getInheritanceHelper().isSarlEvent(ref)) {
            this.error(MessageFormat.format(Messages.SARLBehaviorUnitValidator_11, event.getQualifiedName(), Messages.SARLBehaviorUnitValidator_10, this.getGrammarAccess().getOnKeyword()), (EObject)event, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.type_bounds_missmatch", new String[0]);
        }
    }
}

