/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import io.sarl.lang.sarl.SarlCastedExpression;
import io.sarl.lang.typesystem.FeatureCallAdapter;
import io.sarl.lang.validation.ISARLValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SARLCastValidator {
    public boolean checkCasts(ISARLValidator validator, XCastedExpression cast) {
        if (cast instanceof SarlCastedExpression) {
            SarlCastedExpression sarlCast = (SarlCastedExpression)cast;
            return this.checkOverrideableCasts(validator, sarlCast);
        }
        return false;
    }

    public void checkCast(ISARLValidator validator, JvmTypeReference concreteSyntax, LightweightTypeReference toType, LightweightTypeReference fromType) {
        if (toType.isAssignableFrom(fromType) && !toType.getIdentifier().equals(fromType.getIdentifier()) && !this.isAmbiguousCastContext(concreteSyntax, toType, fromType)) {
            this.reportCastWarnings(validator, concreteSyntax, toType, fromType);
        }
    }

    protected boolean isAmbiguousCastContext(JvmTypeReference concreteSyntax, LightweightTypeReference toType, LightweightTypeReference fromType) {
        XAbstractFeatureCall call;
        FeatureCallAdapter adapter;
        EObject eObject;
        SarlCastedExpression cast = (SarlCastedExpression)EcoreUtil2.getContainerOfType((EObject)concreteSyntax, SarlCastedExpression.class);
        if (cast != null && (eObject = cast.eContainer()) instanceof XAbstractFeatureCall && (adapter = (FeatureCallAdapter)EcoreUtil.getAdapter((List)(call = (XAbstractFeatureCall)eObject).eAdapters(), FeatureCallAdapter.class)) != null) {
            return adapter.getCallCandidates().size() > 1;
        }
        return false;
    }

    protected boolean checkOverrideableCasts(ISARLValidator validator, SarlCastedExpression cast) {
        JvmOperation operation = cast.getFeature();
        if (operation != null) {
            JvmTypeReference concreteSyntax = cast.getType();
            if (concreteSyntax != null) {
                LightweightTypeReference toType = validator.toLightweightTypeReference(cast.getType());
                this.reportCastWarnings(validator, concreteSyntax, toType, validator.getActualType(cast.getTarget()));
                if (!validator.isIgnored("io.sarl.lang.validation.IssueCodes.potential_inefficient_value_conversion")) {
                    LightweightTypeReference fromType = validator.toLightweightTypeReference(operation.getReturnType());
                    String message = Strings.equal((String)concreteSyntax.getIdentifier(), (String)fromType.getIdentifier()) ? MessageFormat.format(Messages.SARLCastValidator_1, operation.getSimpleName()) : MessageFormat.format(Messages.SARLCastValidator_2, operation.getSimpleName(), toType.getHumanReadableName(), fromType.getHumanReadableName());
                    validator.addIssue(message, (EObject)concreteSyntax, "io.sarl.lang.validation.IssueCodes.potential_inefficient_value_conversion");
                }
            }
            return true;
        }
        return false;
    }

    protected void reportCastWarnings(ISARLValidator validator, JvmTypeReference concreteSyntax, LightweightTypeReference toType, LightweightTypeReference fromType) {
        if (!validator.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast") && toType.isAssignableFrom(fromType)) {
            validator.addIssue(MessageFormat.format(Messages.SARLCastValidator_3, fromType.getHumanReadableName(), toType.getHumanReadableName()), (EObject)concreteSyntax, "org.eclipse.xtext.xbase.validation.IssueCodes.obsolete_cast");
        }
    }
}

