/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.inject.Inject;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.documentation.IEObjectDocumentationProvider;
import org.eclipse.xtext.documentation.IEObjectDocumentationProviderExtension;
import org.eclipse.xtext.documentation.IJavaDocTypeReferenceProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class SARLDocumentationValidator
extends AbstractSARLSubValidator {
    @Inject
    private IEObjectDocumentationProvider documentationProvider;
    @Inject
    private IJavaDocTypeReferenceProvider javaDocTypeReferenceProvider;
    @Inject
    private IScopeProvider scopeProvider;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;

    @Check(value=CheckType.EXPENSIVE)
    public void checkJavaDocRefs(XtendMember member) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) {
            return;
        }
        List documentationNodes = ((IEObjectDocumentationProviderExtension)this.documentationProvider).getDocumentationNodes((EObject)member);
        for (INode node : documentationNodes) {
            for (ReplaceRegion region : this.javaDocTypeReferenceProvider.computeTypeRefRegions(node)) {
                Severity severity;
                IScope scope;
                IEObjectDescription candidate;
                String typeRefString = region.getText();
                if (typeRefString == null || typeRefString.length() <= 0 || (candidate = (scope = this.scopeProvider.getScope((EObject)member, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE)).getSingleElement(this.qualifiedNameConverter.toQualifiedName(typeRefString))) != null || (severity = this.getIssueSeverities(this.getContext(), this.getCurrentObject()).getSeverity("org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking")) == null) continue;
                this.getChain().add(this.createDiagnostic(severity, MessageFormat.format(Messages.SARLDocumentationValidator_1, typeRefString), (EObject)member, region.getOffset(), region.getLength(), "org.eclipse.xtend.core.validation.IssueCodes.java_doc_linking", new String[0]));
            }
        }
    }
}

