/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.inject.Inject;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.typesystem.SARLExpressionHelper;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.IFeatureCallValidator;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureNames;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

public class SARLFeatureCallsValidator
extends AbstractSARLSubValidator {
    @Inject
    private IFeatureCallValidator featureCallValidator;
    @Inject
    private OperatorMapping operatorMapping;

    @Check(value=CheckType.NORMAL)
    public void checkForbiddenCalls(XAbstractFeatureCall expression) {
        if (this.featureCallValidator.isDisallowedCall(expression)) {
            this.error(MessageFormat.format(Messages.SARLFeatureCallsValidator_1, expression.getFeature().getIdentifier()), (EObject)expression, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDiscouragedCalls(XAbstractFeatureCall expression) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference") && this.featureCallValidator.isDiscouragedCall(expression)) {
            this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_2, expression.getConcreteSyntaxFeatureName()), (EObject)expression, "org.eclipse.xtext.xbase.validation.IssueCodes.discouraged_reference");
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkAmbiguousInterpretationMinusUnaryOperator(XUnaryOperation expression) {
        Object object;
        XAbstractFeatureCall fc;
        if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.ambiguous_interpretation_by_developper") && this.getGrammarAccess().getHyphenMinusKeyword().equals(expression.getConcreteSyntaxFeatureName()) && (expression.getOperand() instanceof XFeatureCall || expression.getOperand() instanceof XMemberFeatureCall) && (fc = (XAbstractFeatureCall)expression.getOperand()).isExtension() && fc.getActualArguments() != null && fc.getActualArguments().size() > 0 && (object = fc.getActualArguments().get(0)) instanceof XNumberLiteral) {
            XNumberLiteral cvalue = (XNumberLiteral)object;
            this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_3, Utils.getSarlCodeFor((EObject)expression), fc.getFeature().getSimpleName(), cvalue.getValue()), (EObject)expression, "io.sarl.lang.validation.IssueCodes.ambiguous_interpretation_by_developper");
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkBreakKeywordUse(SarlBreakExpression expression) {
        EObject container = Utils.getFirstContainerForPredicate((EObject)expression, (Functions.Function1<? super EObject, ? extends Boolean>)((Functions.Function1)it -> !(it instanceof XExpression) || it instanceof XAbstractWhileExpression || it instanceof XBasicForLoopExpression || it instanceof XForLoopExpression));
        if (container instanceof XExpression) {
            if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_loop_breaking_keyword_use") && container instanceof XBasicForLoopExpression) {
                this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_4, this.getGrammarAccess().getBreakKeyword()), (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.discouraged_loop_breaking_keyword_use", new String[0]);
            }
        } else {
            this.error(MessageFormat.format(Messages.SARLFeatureCallsValidator_5, this.getGrammarAccess().getBreakKeyword()), (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_use_of_loop_breaking_keyword", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkContinueKeywordUse(SarlContinueExpression expression) {
        EObject container = Utils.getFirstContainerForPredicate((EObject)expression, (Functions.Function1<? super EObject, ? extends Boolean>)((Functions.Function1)it -> !(it instanceof XExpression) || it instanceof XAbstractWhileExpression || it instanceof XBasicForLoopExpression || it instanceof XForLoopExpression));
        if (container instanceof XExpression) {
            if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_loop_breaking_keyword_use") && container instanceof XBasicForLoopExpression) {
                this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_4, this.getGrammarAccess().getContinueKeyword()), (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.discouraged_loop_breaking_keyword_use", new String[0]);
            }
        } else {
            this.error(MessageFormat.format(Messages.SARLFeatureCallsValidator_5, this.getGrammarAccess().getContinueKeyword()), (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_use_of_loop_breaking_keyword", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkAssertKeywordUse(SarlAssertExpression expression) {
        XExpression condition = expression.getCondition();
        if (condition != null) {
            SARLExpressionHelper helper;
            Boolean constant;
            LightweightTypeReference fromType = this.getActualType(condition);
            if (!fromType.isAssignableFrom(Boolean.TYPE)) {
                this.error(MessageFormat.format(Messages.SARLFeatureCallsValidator_8, this.getNameOfTypes(fromType), Boolean.TYPE.getName()), (EObject)condition, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[0]);
                return;
            }
            XExpressionHelper xExpressionHelper = this.getExpressionHelper();
            if (xExpressionHelper instanceof SARLExpressionHelper && (constant = (helper = (SARLExpressionHelper)xExpressionHelper).toBooleanPrimitiveWrapperConstant(condition)) == Boolean.TRUE && !this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_boolean_expression")) {
                this.addIssue(Messages.SARLFeatureCallsValidator_6, (EObject)condition, null, -1, "io.sarl.lang.validation.IssueCodes.discouraged_boolean_expression", new String[0]);
                return;
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAssumeKeywordUse(SarlAssertExpression expression) {
        if (expression.isIsStatic()) {
            this.warning(MessageFormat.format(Messages.SARLFeatureCallsValidator_7, this.getGrammarAccess().getIsStaticAssumeKeyword()), (EObject)expression, null, -1, "io.sarl.lang.validation.IssueCodes.unsupported_statement", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkOperatorSignature(XtendFunction function) {
        JvmOperation operation;
        QualifiedName qualifiedName;
        QualifiedName operator;
        String functionName = function.getName();
        if (functionName != null && (operator = this.operatorMapping.getOperator(qualifiedName = QualifiedName.create((String)functionName))) != null && (operation = this.getAssociations().getDirectlyInferredOperation(function)) != null) {
            int parameterSize = operation.getParameters().size();
            if (function.isStatic()) {
                if (this.operatorMapping.isUnaryOperator(operator) && this.operatorMapping.isBinaryOperator(operator)) {
                    if (parameterSize < 1) {
                        this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_9, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    } else if (parameterSize > 2) {
                        this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_10, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    }
                } else if (this.operatorMapping.isUnaryOperator(operator)) {
                    if (parameterSize != 1) {
                        this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_11, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                    }
                } else if (parameterSize != 2) {
                    this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_12, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (this.operatorMapping.isUnaryOperator(operator) && this.operatorMapping.isBinaryOperator(operator)) {
                if (parameterSize > 2) {
                    this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_13, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (this.operatorMapping.isUnaryOperator(operator)) {
                if (parameterSize > 1) {
                    this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_14, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
                }
            } else if (parameterSize == 0) {
                this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_15, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
            } else if (parameterSize > 2) {
                this.addIssue(MessageFormat.format(Messages.SARLFeatureCallsValidator_16, operator), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.invalid_operator_signature", new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkLeftHandSideIsVariable(XAssignment assignment) {
        String concreteSyntaxFeatureName = assignment.getConcreteSyntaxFeatureName();
        if (concreteSyntaxFeatureName.equals(IFeatureNames.THIS.toString())) {
            this.error(Messages.SARLFeatureCallsValidator_17, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, "left_hand_side_must_be_variable", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkTernaryExpressionUsed(XIfExpression exp) {
        if (exp.isConditionalExpression()) {
            XIfExpression cvalue;
            EObject container = exp.eContainer();
            if (container instanceof XIfExpression && (cvalue = (XIfExpression)container).isConditionalExpression()) {
                return;
            }
            this.addIssue(Messages.SARLFeatureCallsValidator_18, (EObject)exp, "org.eclipse.xtend.core.validation.IssueCodes.ternary_if_operator_is_not_allowed");
        }
    }
}

