/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import io.sarl.lang.validation.subvalidators.SARLModifierValidator;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;

public class SARLFeatureModifierValidator
extends AbstractSARLSubValidator {
    @Inject
    private SARLGrammarKeywordAccess grammarAccess;
    @Inject
    private Injector injector;
    private SARLModifierValidator constructorModifierValidatorForSpecialContainer;
    private SARLModifierValidator staticConstructorModifierValidator;
    private SARLModifierValidator agentModifierValidator;
    private SARLModifierValidator methodInAgentModifierValidator;
    private SARLModifierValidator fieldInAgentModifierValidator;
    private SARLModifierValidator behaviorModifierValidator;
    private SARLModifierValidator methodInBehaviorModifierValidator;
    private SARLModifierValidator fieldInBehaviorModifierValidator;
    private SARLModifierValidator capacityModifierValidator;
    private SARLModifierValidator methodInCapacityModifierValidator;
    private SARLModifierValidator eventModifierValidator;
    private SARLModifierValidator fieldInEventModifierValidator;
    private SARLModifierValidator skillModifierValidator;
    private SARLModifierValidator methodInSkillModifierValidator;
    private SARLModifierValidator fieldInSkillModifierValidator;
    private SARLModifierValidator classModifierValidator;
    private SARLModifierValidator interfaceModifierValidator;
    private SARLModifierValidator enumModifierValidator;
    private SARLModifierValidator annotationTypeModifierValidator;
    private SARLModifierValidator nestedClassModifierValidator;
    private SARLModifierValidator nestedInterfaceModifierValidator;
    private SARLModifierValidator nestedEnumModifierValidator;
    private SARLModifierValidator nestedAnnotationTypeModifierValidator;
    private SARLModifierValidator fieldModifierValidator;
    private SARLModifierValidator fieldInInterfaceModifierValidator;
    private SARLModifierValidator constructorModifierValidator;
    private SARLModifierValidator methodModifierValidator;
    private SARLModifierValidator methodInInterfaceModifierValidator;
    private SARLModifierValidator nestedClassInAgentModifierValidator;
    private SARLModifierValidator nestedInterfaceInAgentModifierValidator;
    private SARLModifierValidator nestedEnumerationInAgentModifierValidator;
    private SARLModifierValidator nestedAnnotationTypeInAgentModifierValidator;
    private SARLModifierValidator mainFunctionModifierValidator;

    @Check(value=CheckType.FAST)
    protected void checkModifierMatchesTypename(XtendClass xtendClass) {
        String name = xtendClass.getName();
        if (name != null && name.equals("Abstract") && !xtendClass.isAbstract()) {
            this.addIssue(MessageFormat.format(Messages.SARLModifierValidator_12, name), (EObject)xtendClass, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_modifier", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendConstructor constructor) {
        XtendTypeDeclaration declaringType = constructor.getDeclaringType();
        if (declaringType != null) {
            String typeName = declaringType.getName();
            String msg = MessageFormat.format(Messages.SARLFeatureModifierValidator_1, typeName);
            if (constructor.isStatic()) {
                this.getStaticConstructorModifierValidator().checkModifiers((XtendMember)constructor, msg);
            } else if (this.isAOConstructorContainer(declaringType)) {
                this.getConstructorModifierValidatorForSpecialContainer().checkModifiers((XtendMember)constructor, msg);
            } else if (!(constructor.getDeclaringType() instanceof XtendClass)) {
                this.error(Messages.SARLFeatureModifierValidator_2, null, "org.eclipse.xtend.core.validation.IssueCodes.constructor_not_permitted", new String[0]);
            } else {
                XtendTypeDeclaration container = (XtendTypeDeclaration)constructor.eContainer();
                this.getConstructorModifierValidator().checkModifiers((XtendMember)constructor, this.typeName(container));
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendFunction function) {
        XtendTypeDeclaration declaringType = function.getDeclaringType();
        if (declaringType != null) {
            if (declaringType instanceof SarlAgent) {
                String typeName = ((XtendTypeDeclaration)function.eContainer()).getName();
                this.getMethodInAgentModifierValidator().checkModifiers((XtendMember)function, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, function.getName(), typeName));
            } else if (declaringType instanceof SarlCapacity) {
                String typeName = ((XtendTypeDeclaration)function.eContainer()).getName();
                this.getMethodInCapacityModifierValidator().checkModifiers((XtendMember)function, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, function.getName(), typeName));
            } else if (declaringType instanceof SarlSkill) {
                String typeName = ((XtendTypeDeclaration)function.eContainer()).getName();
                this.getMethodInSkillModifierValidator().checkModifiers((XtendMember)function, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, function.getName(), typeName));
            } else if (declaringType instanceof SarlBehavior) {
                String typeName = ((XtendTypeDeclaration)function.eContainer()).getName();
                this.getMethodInBehaviorModifierValidator().checkModifiers((XtendMember)function, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, function.getName(), typeName));
            } else if (declaringType instanceof XtendClass && Utils.isNameForJavaMainFunction(function.getName())) {
                this.getMainFunctionModifierValidator().checkModifiers((XtendMember)function, this.memberName(function));
            } else {
                int abstractIndex = function.getModifiers().indexOf((Object)this.getGrammarAccess().getAbstractKeyword());
                if (declaringType instanceof XtendClass || declaringType instanceof AnonymousClass) {
                    this.getMethodModifierValidator().checkModifiers((XtendMember)function, this.memberName(function));
                    int nativeIndex = function.getModifiers().indexOf((Object)this.getGrammarAccess().getNativeKeyword());
                    if (function.getExpression() != null) {
                        if (abstractIndex != -1) {
                            this.error(MessageFormat.format(Messages.SARLFeatureModifierValidator_5, function.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, abstractIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                        } else if (function.isNative()) {
                            this.error(Messages.SARLFeatureModifierValidator_6, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                        }
                    } else if (nativeIndex == -1) {
                        int staticIndex;
                        int privateIndex;
                        int finalIndex = function.getModifiers().indexOf((Object)this.getGrammarAccess().getFinalKeyword());
                        if (finalIndex != -1) {
                            this.error(MessageFormat.format(Messages.SARLFeatureModifierValidator_7, function.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, finalIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                        }
                        if ((privateIndex = function.getModifiers().indexOf((Object)this.getGrammarAccess().getPrivateKeyword())) != -1) {
                            this.error(MessageFormat.format(Messages.SARLFeatureModifierValidator_8, function.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, privateIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                        }
                        if ((staticIndex = function.getModifiers().indexOf((Object)this.getGrammarAccess().getStaticStaticKeyword())) != -1) {
                            this.error(MessageFormat.format(Messages.SARLFeatureModifierValidator_9, function.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, staticIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                        }
                    }
                } else if (declaringType instanceof XtendInterface) {
                    this.getMethodInInterfaceModifierValidator().checkModifiers((XtendMember)function, this.memberName(function));
                    if (function.getExpression() != null && abstractIndex != -1) {
                        this.error(MessageFormat.format(Messages.SARLFeatureModifierValidator_10, function.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, abstractIndex, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                    }
                }
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendField field) {
        XtendTypeDeclaration declaringType = field.getDeclaringType();
        if (declaringType != null) {
            boolean generateMemorySharingWarning = false;
            if (declaringType instanceof SarlEvent) {
                String typeName = ((XtendTypeDeclaration)field.eContainer()).getName();
                this.getFieldInEventModifierValidator().checkModifiers((XtendMember)field, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, field.getName(), typeName));
            } else if (declaringType instanceof SarlAgent) {
                generateMemorySharingWarning = true;
                String typeName = ((XtendTypeDeclaration)field.eContainer()).getName();
                this.getFieldInAgentModifierValidator().checkModifiers((XtendMember)field, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, field.getName(), typeName));
            } else if (declaringType instanceof SarlSkill) {
                generateMemorySharingWarning = true;
                String typeName = ((XtendTypeDeclaration)field.eContainer()).getName();
                this.getFieldInSkillModifierValidator().checkModifiers((XtendMember)field, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, field.getName(), typeName));
            } else if (declaringType instanceof SarlBehavior) {
                generateMemorySharingWarning = true;
                String typeName = ((XtendTypeDeclaration)field.eContainer()).getName();
                this.getFieldInBehaviorModifierValidator().checkModifiers((XtendMember)field, MessageFormat.format(Messages.SARLFeatureModifierValidator_3, field.getName(), typeName));
            } else if (declaringType instanceof XtendClass || declaringType instanceof AnonymousClass) {
                if (field.isFinal() && field.isVolatile()) {
                    this.error(MessageFormat.format(Messages.SARLFeatureModifierValidator_4, field.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
                }
                this.getFieldModifierValidator().checkModifiers((XtendMember)field, this.memberName(field));
            } else if (declaringType instanceof XtendInterface || declaringType instanceof XtendAnnotationType) {
                this.getFieldInInterfaceModifierValidator().checkModifiers((XtendMember)field, this.memberName(field));
            }
            if (generateMemorySharingWarning && field.isStatic() && !this.isIgnored("io.sarl.lang.validation.IssueCodes.potential_memory_sharing_outside_agent_control") && (!field.isFinal() || field.getInitialValue() == null || this.getExpressionHelper().hasSideEffects(field.getInitialValue()))) {
                this.addIssue(MessageFormat.format(Messages.SARLFeatureModifierValidator_13, field.getName()), (EObject)field, "io.sarl.lang.validation.IssueCodes.potential_memory_sharing_outside_agent_control");
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(SarlEvent event) {
        this.getEventModifierValidator().checkModifiers((XtendMember)event, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, event.getName()));
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(SarlAgent agent) {
        this.getAgentModifierValidator().checkModifiers((XtendMember)agent, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, agent.getName()));
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(SarlBehavior behavior) {
        this.getBehaviorModifierValidator().checkModifiers((XtendMember)behavior, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, behavior.getName()));
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(SarlCapacity capacity) {
        this.getCapacityModifierValidator().checkModifiers((XtendMember)capacity, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, capacity.getName()));
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(SarlSkill skill) {
        this.getSkillModifierValidator().checkModifiers((XtendMember)skill, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, skill.getName()));
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendInterface oopInterface) {
        EObject econtainer = oopInterface.eContainer();
        if (econtainer instanceof SarlAgent) {
            this.getNestedInterfaceInAgentModifierValidator().checkModifiers((XtendMember)oopInterface, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, oopInterface.getName()));
        } else {
            EObject eContainer = oopInterface.eContainer();
            if (eContainer instanceof XtendFile) {
                this.getInterfaceModifierValidator().checkModifiers((XtendMember)oopInterface, this.typeName((XtendTypeDeclaration)oopInterface));
            } else {
                this.getNestedInterfaceModifierValidator().checkModifiers((XtendMember)oopInterface, this.typeName((XtendTypeDeclaration)oopInterface));
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendClass oopClass) {
        EObject econtainer = oopClass.eContainer();
        if (econtainer instanceof SarlAgent) {
            this.getNestedClassInAgentModifierValidator().checkModifiers((XtendMember)oopClass, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, oopClass.getName()));
        } else {
            EObject eContainer = oopClass.eContainer();
            if (eContainer instanceof XtendFile) {
                this.getClassModifierValidator().checkModifiers((XtendMember)oopClass, this.typeName((XtendTypeDeclaration)oopClass));
            } else {
                this.getNestedClassModifierValidator().checkModifiers((XtendMember)oopClass, this.typeName((XtendTypeDeclaration)oopClass));
            }
        }
        if (!oopClass.isStatic() && econtainer instanceof XtendTypeDeclaration) {
            this.error(Messages.SARLFeatureModifierValidator_12, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendEnum oopEnum) {
        EObject econtainer = oopEnum.eContainer();
        if (econtainer instanceof SarlAgent) {
            this.getNestedEnumerationInAgentModifierValidator().checkModifiers((XtendMember)oopEnum, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, oopEnum.getName()));
        } else {
            EObject eContainer = oopEnum.eContainer();
            if (eContainer instanceof XtendFile) {
                this.getEnumModifierValidator().checkModifiers((XtendMember)oopEnum, this.typeName((XtendTypeDeclaration)oopEnum));
            } else {
                this.getNestedEnumModifierValidator().checkModifiers((XtendMember)oopEnum, this.typeName((XtendTypeDeclaration)oopEnum));
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkModifiers(XtendAnnotationType oopAnnotationType) {
        EObject econtainer = oopAnnotationType.eContainer();
        if (econtainer instanceof SarlAgent) {
            this.getNestedAnnotationTypeInAgentModifierValidator().checkModifiers((XtendMember)oopAnnotationType, MessageFormat.format(Messages.SARLFeatureModifierValidator_11, oopAnnotationType.getName()));
        } else {
            EObject eContainer = oopAnnotationType.eContainer();
            if (eContainer instanceof XtendFile) {
                this.getAnnotationTypeModifierValidator().checkModifiers((XtendMember)oopAnnotationType, this.typeName((XtendTypeDeclaration)oopAnnotationType));
            } else {
                this.getNestedAnnotationTypeModifierValidator().checkModifiers((XtendMember)oopAnnotationType, this.typeName((XtendTypeDeclaration)oopAnnotationType));
            }
        }
    }

    protected SARLModifierValidator newSARLModifierValidator(List<String> modifiers) {
        SARLModifierValidator validator = new SARLModifierValidator(modifiers, this.getVisibilityModifiers(), (x$0, x$1, x$2, x$3, x$4, x$5) -> this.error(x$0, x$1, x$2, x$3, x$4, x$5), (x$0, x$1, x$2, x$3, x$4, x$5) -> this.addIssue(x$0, x$1, x$2, x$3, x$4, x$5));
        this.injector.injectMembers((Object)validator);
        return validator;
    }

    protected SARLModifierValidator getConstructorModifierValidatorForSpecialContainer() {
        if (this.constructorModifierValidatorForSpecialContainer == null) {
            this.constructorModifierValidatorForSpecialContainer = this.newSARLModifierValidator(this.getVisibilityModifiers());
        }
        return this.constructorModifierValidatorForSpecialContainer;
    }

    protected SARLModifierValidator getStaticConstructorModifierValidator() {
        if (this.staticConstructorModifierValidator == null) {
            this.staticConstructorModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getStaticStaticKeyword()}));
        }
        return this.staticConstructorModifierValidator;
    }

    protected SARLModifierValidator getAgentModifierValidator() {
        if (this.agentModifierValidator == null) {
            this.agentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getFinalKeyword()}));
        }
        return this.agentModifierValidator;
    }

    protected SARLModifierValidator getMethodInAgentModifierValidator() {
        if (this.methodInAgentModifierValidator == null) {
            this.methodInAgentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getDispatchKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getDefKeyword(), this.grammarAccess.getOverrideKeyword(), this.grammarAccess.getSynchronizedKeyword()}));
        }
        return this.methodInAgentModifierValidator;
    }

    protected SARLModifierValidator getFieldInAgentModifierValidator() {
        if (this.fieldInAgentModifierValidator == null) {
            this.fieldInAgentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getExtensionExtensionKeyword(), this.grammarAccess.getWriteableVarKeyword(), this.grammarAccess.getValKeyword(), this.grammarAccess.getStaticStaticKeyword()}));
        }
        return this.fieldInAgentModifierValidator;
    }

    protected SARLModifierValidator getBehaviorModifierValidator() {
        if (this.behaviorModifierValidator == null) {
            this.behaviorModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getFinalKeyword()}));
        }
        return this.behaviorModifierValidator;
    }

    protected SARLModifierValidator getMethodInBehaviorModifierValidator() {
        if (this.methodInBehaviorModifierValidator == null) {
            this.methodInBehaviorModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getDispatchKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getDefKeyword(), this.grammarAccess.getOverrideKeyword(), this.grammarAccess.getSynchronizedKeyword()}));
        }
        return this.methodInBehaviorModifierValidator;
    }

    protected SARLModifierValidator getFieldInBehaviorModifierValidator() {
        if (this.fieldInBehaviorModifierValidator == null) {
            this.fieldInBehaviorModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getExtensionExtensionKeyword(), this.grammarAccess.getWriteableVarKeyword(), this.grammarAccess.getValKeyword()}));
        }
        return this.fieldInBehaviorModifierValidator;
    }

    protected SARLModifierValidator getCapacityModifierValidator() {
        if (this.capacityModifierValidator == null) {
            this.capacityModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword()}));
        }
        return this.capacityModifierValidator;
    }

    protected SARLModifierValidator getMethodInCapacityModifierValidator() {
        if (this.methodInCapacityModifierValidator == null) {
            this.methodInCapacityModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getDefKeyword(), this.grammarAccess.getOverrideKeyword()}));
        }
        return this.methodInCapacityModifierValidator;
    }

    protected SARLModifierValidator getEventModifierValidator() {
        if (this.eventModifierValidator == null) {
            this.eventModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getAbstractKeyword()}));
        }
        return this.eventModifierValidator;
    }

    protected SARLModifierValidator getFieldInEventModifierValidator() {
        if (this.fieldInEventModifierValidator == null) {
            this.fieldInEventModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getWriteableVarKeyword(), this.grammarAccess.getValKeyword()}));
        }
        return this.fieldInEventModifierValidator;
    }

    protected SARLModifierValidator getSkillModifierValidator() {
        if (this.skillModifierValidator == null) {
            this.skillModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getAbstractKeyword()}));
        }
        return this.skillModifierValidator;
    }

    protected SARLModifierValidator getMethodInSkillModifierValidator() {
        if (this.methodInSkillModifierValidator == null) {
            this.methodInSkillModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getDispatchKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getDefKeyword(), this.grammarAccess.getOverrideKeyword(), this.grammarAccess.getSynchronizedKeyword()}));
        }
        return this.methodInSkillModifierValidator;
    }

    protected SARLModifierValidator getFieldInSkillModifierValidator() {
        if (this.fieldInSkillModifierValidator == null) {
            this.fieldInSkillModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getExtensionExtensionKeyword(), this.grammarAccess.getWriteableVarKeyword(), this.grammarAccess.getValKeyword()}));
        }
        return this.fieldInSkillModifierValidator;
    }

    protected SARLModifierValidator getClassModifierValidator() {
        if (this.classModifierValidator == null) {
            this.classModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getStrictfpKeyword()}));
        }
        return this.classModifierValidator;
    }

    protected SARLModifierValidator getInterfaceModifierValidator() {
        if (this.interfaceModifierValidator == null) {
            this.interfaceModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getAbstractKeyword()}));
        }
        return this.interfaceModifierValidator;
    }

    protected SARLModifierValidator getEnumModifierValidator() {
        if (this.enumModifierValidator == null) {
            this.enumModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword()}));
        }
        return this.enumModifierValidator;
    }

    protected SARLModifierValidator getAnnotationTypeModifierValidator() {
        if (this.annotationTypeModifierValidator == null) {
            this.annotationTypeModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getAbstractKeyword()}));
        }
        return this.annotationTypeModifierValidator;
    }

    protected SARLModifierValidator getNestedClassModifierValidator() {
        if (this.nestedClassModifierValidator == null) {
            this.nestedClassModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getStrictfpKeyword()}));
        }
        return this.nestedClassModifierValidator;
    }

    protected SARLModifierValidator getNestedInterfaceModifierValidator() {
        if (this.nestedInterfaceModifierValidator == null) {
            this.nestedInterfaceModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getStrictfpKeyword()}));
        }
        return this.nestedInterfaceModifierValidator;
    }

    protected SARLModifierValidator getNestedEnumModifierValidator() {
        if (this.nestedEnumModifierValidator == null) {
            this.nestedEnumModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword()}));
        }
        return this.nestedEnumModifierValidator;
    }

    protected SARLModifierValidator getNestedAnnotationTypeModifierValidator() {
        if (this.nestedAnnotationTypeModifierValidator == null) {
            this.nestedAnnotationTypeModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getAbstractKeyword()}));
        }
        return this.nestedAnnotationTypeModifierValidator;
    }

    protected SARLModifierValidator getFieldModifierValidator() {
        if (this.fieldModifierValidator == null) {
            this.fieldModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getValKeyword(), this.grammarAccess.getWriteableVarKeyword(), this.grammarAccess.getExtensionExtensionKeyword(), this.grammarAccess.getVolatileKeyword(), this.grammarAccess.getTransientKeyword()}));
        }
        return this.fieldModifierValidator;
    }

    protected SARLModifierValidator getFieldInInterfaceModifierValidator() {
        if (this.fieldInInterfaceModifierValidator == null) {
            this.fieldInInterfaceModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getValKeyword()}));
        }
        return this.fieldInInterfaceModifierValidator;
    }

    protected SARLModifierValidator getConstructorModifierValidator() {
        if (this.constructorModifierValidator == null) {
            this.constructorModifierValidator = this.newSARLModifierValidator(this.getVisibilityModifiers());
        }
        return this.constructorModifierValidator;
    }

    protected SARLModifierValidator getMethodModifierValidator() {
        if (this.methodModifierValidator == null) {
            this.methodModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getDispatchKeyword(), this.grammarAccess.getDefKeyword(), this.grammarAccess.getOverrideKeyword(), this.grammarAccess.getStrictfpKeyword(), this.grammarAccess.getNativeKeyword(), this.grammarAccess.getSynchronizedKeyword()}));
        }
        return this.methodModifierValidator;
    }

    protected SARLModifierValidator getMethodInInterfaceModifierValidator() {
        if (this.methodInInterfaceModifierValidator == null) {
            this.methodInInterfaceModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getDefKeyword(), this.grammarAccess.getOverrideKeyword()}));
        }
        return this.methodInInterfaceModifierValidator;
    }

    protected SARLModifierValidator getNestedClassInAgentModifierValidator() {
        if (this.nestedClassInAgentModifierValidator == null) {
            this.nestedClassInAgentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getFinalKeyword(), this.grammarAccess.getStaticStaticKeyword()}));
        }
        return this.nestedClassInAgentModifierValidator;
    }

    protected SARLModifierValidator getNestedInterfaceInAgentModifierValidator() {
        if (this.nestedInterfaceInAgentModifierValidator == null) {
            this.nestedInterfaceInAgentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getAbstractKeyword(), this.grammarAccess.getStaticStaticKeyword()}));
        }
        return this.nestedInterfaceInAgentModifierValidator;
    }

    protected SARLModifierValidator getNestedEnumerationInAgentModifierValidator() {
        if (this.annotationTypeModifierValidator == null) {
            this.nestedEnumerationInAgentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword()}));
        }
        return this.nestedEnumerationInAgentModifierValidator;
    }

    protected SARLModifierValidator getNestedAnnotationTypeInAgentModifierValidator() {
        if (this.nestedAnnotationTypeInAgentModifierValidator == null) {
            this.nestedAnnotationTypeInAgentModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPackageKeyword(), this.grammarAccess.getProtectedKeyword(), this.grammarAccess.getPrivateKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getAbstractKeyword()}));
        }
        return this.nestedAnnotationTypeInAgentModifierValidator;
    }

    protected SARLModifierValidator getMainFunctionModifierValidator() {
        if (this.mainFunctionModifierValidator == null) {
            this.mainFunctionModifierValidator = this.newSARLModifierValidator(Lists.newArrayList((Object[])new String[]{this.grammarAccess.getPublicKeyword(), this.grammarAccess.getStaticStaticKeyword(), this.grammarAccess.getDefKeyword()}));
        }
        return this.mainFunctionModifierValidator;
    }
}

