/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlInterface;
import io.sarl.lang.sarl.SarlPackage;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.subvalidators.AbstractSARLJvmGenericTypeValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.typesystem.override.IOverrideCheckResult;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SARLInheritanceValidator
extends AbstractSARLJvmGenericTypeValidator {
    @Inject
    private DispatchHelper dispatchHelper;

    private boolean checkRedundantInterfaceInSameType(XtendTypeDeclaration element, EReference structuralElement, LightweightTypeReference lightweightInterfaceReference, List<LightweightTypeReference> knownInterfaces) {
        String iid = lightweightInterfaceReference.getUniqueIdentifier();
        int index = 1;
        for (LightweightTypeReference previousInterface : knownInterfaces) {
            String pid = previousInterface.getUniqueIdentifier();
            if (Objects.equal((Object)iid, (Object)pid)) {
                this.error(MessageFormat.format(Messages.SARLInheritanceValidator_2, SARLInheritanceValidator.canonicalName(lightweightInterfaceReference)), (EObject)element, (EStructuralFeature)structuralElement, index, "io.sarl.lang.validation.IssueCodes.redundant_interface_implementation", new String[]{SARLInheritanceValidator.canonicalName(lightweightInterfaceReference), "pre"});
                return true;
            }
            if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.redundant_interface_implementation", (EObject)element) && this.getParentValidator().memberOfTypeHierarchy(previousInterface, lightweightInterfaceReference)) {
                this.addIssue(MessageFormat.format(Messages.SARLInheritanceValidator_1, SARLInheritanceValidator.canonicalName(lightweightInterfaceReference), SARLInheritanceValidator.canonicalName(previousInterface)), (EObject)element, (EStructuralFeature)structuralElement, index, "io.sarl.lang.validation.IssueCodes.redundant_interface_implementation", new String[]{SARLInheritanceValidator.canonicalName(lightweightInterfaceReference), "pre"});
                return true;
            }
            ++index;
        }
        return false;
    }

    private void checkRedundantInterfaces(XtendTypeDeclaration element, EReference structuralElement, Iterable<? extends JvmTypeReference> interfaces, Iterable<? extends JvmTypeReference> superTypes) {
        ArrayList knownInterfaces = CollectionLiterals.newArrayList();
        for (JvmTypeReference jvmTypeReference : interfaces) {
            LightweightTypeReference lightweightInterfaceReference = this.getParentValidator().toLightweightTypeReference(jvmTypeReference);
            if (!this.checkRedundantInterfaceInSameType(element, structuralElement, lightweightInterfaceReference, knownInterfaces) && superTypes != null && !this.isIgnored("io.sarl.lang.validation.IssueCodes.redundant_interface_implementation", (EObject)element)) {
                for (JvmTypeReference jvmTypeReference2 : superTypes) {
                    LightweightTypeReference lightweightSuperType = this.getParentValidator().toLightweightTypeReference(jvmTypeReference2);
                    if (!this.getParentValidator().memberOfTypeHierarchy(lightweightSuperType, lightweightInterfaceReference)) continue;
                    this.addIssue(MessageFormat.format(Messages.SARLInheritanceValidator_1, SARLInheritanceValidator.canonicalName(lightweightInterfaceReference), SARLInheritanceValidator.canonicalName(lightweightSuperType)), (EObject)element, (EStructuralFeature)structuralElement, knownInterfaces.size(), "io.sarl.lang.validation.IssueCodes.redundant_interface_implementation", new String[]{SARLInheritanceValidator.canonicalName(lightweightInterfaceReference), "unknow"});
                }
            }
            knownInterfaces.add(lightweightInterfaceReference);
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkRedundantImplementedInterfaces(SarlSkill skill) {
        this.checkRedundantInterfaces(skill, SarlPackage.Literals.SARL_SKILL__IMPLEMENTS, (Iterable<? extends JvmTypeReference>)skill.getImplements(), (Iterable<? extends JvmTypeReference>)Utils.singletonList(skill.getExtends()));
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkRedundantImplementedInterfaces(SarlClass xtendClass) {
        this.checkRedundantInterfaces((XtendTypeDeclaration)xtendClass, XtendPackage.Literals.XTEND_CLASS__IMPLEMENTS, (Iterable<? extends JvmTypeReference>)xtendClass.getImplements(), Utils.singletonList(xtendClass.getExtends()));
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkRedundantImplementedInterfaces(SarlInterface xtendInterface) {
        this.checkRedundantInterfaces((XtendTypeDeclaration)xtendInterface, XtendPackage.Literals.XTEND_INTERFACE__EXTENDS, (Iterable<? extends JvmTypeReference>)xtendInterface.getExtends(), Collections.emptyList());
    }

    protected void checkSuperTypes(EObject sourceType, JvmGenericType type) {
        if (sourceType instanceof SarlAgent) {
            SarlAgent agent = (SarlAgent)sourceType;
            this.checkSuperTypes(agent, (EStructuralFeature)SarlPackage.Literals.SARL_AGENT__EXTENDS, Utils.singletonList(agent.getExtends()), Agent.class, false);
        } else if (sourceType instanceof SarlCapacity) {
            SarlCapacity capacity = (SarlCapacity)sourceType;
            this.checkSuperTypes(capacity, (EStructuralFeature)SarlPackage.Literals.SARL_CAPACITY__EXTENDS, (List<? extends JvmTypeReference>)capacity.getExtends(), Capacity.class, false);
        } else if (sourceType instanceof SarlBehavior) {
            SarlBehavior behavior = (SarlBehavior)sourceType;
            this.checkSuperTypes(behavior, (EStructuralFeature)SarlPackage.Literals.SARL_BEHAVIOR__EXTENDS, Utils.singletonList(behavior.getExtends()), Behavior.class, false);
        } else if (sourceType instanceof SarlEvent) {
            SarlEvent event = (SarlEvent)sourceType;
            this.checkSuperTypes(event, (EStructuralFeature)SarlPackage.Literals.SARL_EVENT__EXTENDS, Utils.singletonList(event.getExtends()), Event.class, false);
        } else if (sourceType instanceof SarlSkill) {
            SarlSkill skill = (SarlSkill)sourceType;
            int nbSuperTypes = this.checkSuperTypes(skill, (EStructuralFeature)SarlPackage.Literals.SARL_SKILL__EXTENDS, Utils.singletonList(skill.getExtends()), Skill.class, false);
            this.checkImplementedTypes(skill, SarlPackage.Literals.SARL_SKILL__IMPLEMENTS, (List<? extends JvmTypeReference>)skill.getImplements(), Capacity.class, nbSuperTypes > 0 ? 0 : 1, true);
        } else {
            super.checkSuperTypes(sourceType, type);
            EList superTypes = type.getSuperTypes();
            for (int i = 0; i < superTypes.size(); ++i) {
                JvmTypeReference superType = (JvmTypeReference)superTypes.get(i);
                EObject associated = this.getSuperTypeSourceElement(superType);
                if (associated == null) continue;
                EStructuralFeature eContainingFeature = associated.eContainingFeature();
                LightweightTypeReference lighweightSuperType = this.getParentValidator().toLightweightTypeReference(superType);
                this.getParentValidator().doCheckValidSuperTypeArgumentDefinition(lighweightSuperType, sourceType, eContainingFeature, i, false, true, this.getMessageAcceptor());
            }
        }
    }

    private int checkSuperTypes(XtendTypeDeclaration element, EStructuralFeature sourceFeature, List<? extends JvmTypeReference> superTypes, Class<?> expectedType, boolean onlySubTypes) {
        int nbSuperTypes = 0;
        JvmDeclaredType inferredType = this.getAssociations().getInferredType(element);
        if (inferredType instanceof JvmGenericType) {
            LinkedList inferredSuperTypes = CollectionLiterals.newLinkedList();
            inferredSuperTypes.addAll(inferredType.getSuperTypes());
            boolean isExpectingInterface = expectedType.isInterface();
            int superTypeIndex = 0;
            for (JvmTypeReference jvmTypeReference : superTypes) {
                boolean success = true;
                if (jvmTypeReference != null) {
                    EStructuralFeature feature = sourceFeature == null ? jvmTypeReference.eContainingFeature() : sourceFeature;
                    JvmType jvmSuperType = jvmTypeReference.getType();
                    if (jvmSuperType != null) {
                        JvmGenericType cvalue;
                        JvmTypeReference inferredSuperType = inferredSuperTypes.isEmpty() ? null : (JvmTypeReference)inferredSuperTypes.removeFirst();
                        LightweightTypeReference lighweightSuperType = this.getParentValidator().toLightweightTypeReference(jvmTypeReference);
                        if (!(jvmSuperType instanceof JvmGenericType) || isExpectingInterface != (cvalue = (JvmGenericType)jvmSuperType).isInterface()) {
                            if (isExpectingInterface) {
                                this.getMessageAcceptor().acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_3, Messages.SARLInheritanceValidator_4), (EObject)element, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.interface_expected", new String[]{jvmSuperType.getIdentifier()});
                            } else {
                                this.getMessageAcceptor().acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_3, Messages.SARLInheritanceValidator_5), (EObject)element, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.class_expected", new String[]{jvmSuperType.getIdentifier()});
                            }
                            success = false;
                        } else if (this.getParentValidator().isFinal(lighweightSuperType)) {
                            this.getMessageAcceptor().acceptError(Messages.SARLInheritanceValidator_6, (EObject)element, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.overridden_final", new String[]{inferredType.getIdentifier(), jvmSuperType.getIdentifier()});
                            success = false;
                        } else if (!lighweightSuperType.isSubtypeOf(expectedType) || onlySubTypes && lighweightSuperType.isType(expectedType)) {
                            if (onlySubTypes) {
                                this.getMessageAcceptor().acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_7, expectedType.getName()), (EObject)element, feature, superTypeIndex, "io.sarl.lang.validation.IssueCodes.invalid_extended_type", new String[]{jvmSuperType.getIdentifier()});
                            } else {
                                this.getMessageAcceptor().acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_8, expectedType.getName()), (EObject)element, feature, superTypeIndex, "io.sarl.lang.validation.IssueCodes.invalid_extended_type", new String[]{jvmSuperType.getIdentifier()});
                            }
                            success = false;
                        } else if (inferredSuperType == null || !SARLInheritanceValidator.sameRawType(inferredSuperType.getType(), lighweightSuperType) || SARLInheritanceValidator.sameRawType((JvmType)inferredType, lighweightSuperType) || this.hasCycleInHierarchy((JvmGenericType)inferredType, Sets.newHashSet())) {
                            this.getMessageAcceptor().acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_9, inferredType.getQualifiedName()), (EObject)element, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.cyclic_inheritance", new String[]{jvmSuperType.getIdentifier()});
                            success = false;
                        } else {
                            success = this.getParentValidator().doCheckValidSuperTypeArgumentDefinition(lighweightSuperType, (EObject)element, feature, superTypeIndex, false, true, this.getMessageAcceptor());
                        }
                    } else {
                        this.getMessageAcceptor().acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_9, inferredType.getQualifiedName()), (EObject)element, feature, superTypeIndex, "org.eclipse.xtext.xbase.validation.IssueCodes.cyclic_inheritance", new String[]{jvmTypeReference.getIdentifier()});
                        success = false;
                    }
                    if (success) {
                        this.checkWildcardSupertype(element, jvmTypeReference, feature, superTypeIndex);
                    }
                }
                ++superTypeIndex;
                if (!success) continue;
                ++nbSuperTypes;
            }
        }
        return nbSuperTypes;
    }

    private static boolean sameRawType(JvmType type0, LightweightTypeReference type1) {
        String id0 = type0.getIdentifier();
        String id1 = type1.getRawTypeReference().getIdentifier();
        return Objects.equal((Object)id0, (Object)id1);
    }

    private boolean checkImplementedTypes(XtendTypeDeclaration element, EReference feature, List<? extends JvmTypeReference> implementedTypes, Class<?> expectedType, int mandatoryNumberOfTypes, boolean onlySubTypes) {
        boolean success = true;
        int nb = 0;
        int index = 0;
        for (JvmTypeReference jvmTypeReference : implementedTypes) {
            LightweightTypeReference ref = this.getParentValidator().toLightweightTypeReference(jvmTypeReference);
            if (ref != null && (!ref.isInterfaceType() || !ref.isSubtypeOf(expectedType) || onlySubTypes && ref.isType(expectedType))) {
                String msg = onlySubTypes ? Messages.SARLInheritanceValidator_10 : Messages.SARLInheritanceValidator_11;
                this.error(MessageFormat.format(msg, jvmTypeReference.getQualifiedName(), expectedType.getName(), element.getName()), (EObject)element, (EStructuralFeature)feature, index, "io.sarl.lang.validation.IssueCodes.invalid_implemented_type", new String[]{jvmTypeReference.getSimpleName()});
                success = false;
            } else {
                ++nb;
            }
            ++index;
        }
        if (nb < mandatoryNumberOfTypes) {
            this.error(MessageFormat.format(Messages.SARLInheritanceValidator_12, expectedType.getName(), element.getName()), (EObject)element, (EStructuralFeature)feature, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.missing_type", new String[0]);
            success = false;
        }
        return success;
    }

    private void checkWildcardSupertype(XtendTypeDeclaration xtendType, JvmTypeReference superTypeReference, EStructuralFeature feature, int index) {
        if (this.isInvalidWildcard(superTypeReference)) {
            this.error(MessageFormat.format(Messages.SARLInheritanceValidator_13, xtendType.getName(), superTypeReference.getIdentifier()), feature, index, "org.eclipse.xtext.xbase.validation.IssueCodes.wildcard_in_supertype", new String[0]);
        }
    }

    private boolean hasCycleInHierarchy(JvmGenericType type, Set<JvmGenericType> processedSuperTypes) {
        JvmGenericType container = type;
        do {
            if (!processedSuperTypes.contains(container)) continue;
            return true;
        } while ((container = container.getDeclaringType()) != null);
        processedSuperTypes.add(type);
        for (JvmTypeReference superTypeRef : type.getSuperTypes()) {
            JvmGenericType cvalue;
            JvmType jvmType = superTypeRef.getType();
            if (!(jvmType instanceof JvmGenericType) || !this.hasCycleInHierarchy(cvalue = (JvmGenericType)jvmType, processedSuperTypes)) continue;
            return true;
        }
        processedSuperTypes.remove(type);
        return false;
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkNoTypeNameShadowing(XtendTypeDeclaration type) {
        String name = type.getName();
        if (name != null && name.length() > 0) {
            XtendTypeDeclaration outer = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)type.eContainer(), XtendTypeDeclaration.class);
            while (outer != null) {
                if (name.equals(outer.getName())) {
                    this.acceptError(MessageFormat.format(Messages.SARLInheritanceValidator_14, name), (EObject)type, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[0]);
                    return;
                }
                outer = (XtendTypeDeclaration)EcoreUtil2.getContainerOfType((EObject)outer.eContainer(), XtendTypeDeclaration.class);
            }
        }
    }

    protected void checkMemberNamesAreUnique(JvmGenericType genericType) {
        super.checkMemberNamesAreUnique(genericType);
        EObject primarySourceElement = this.getPrimarySourceElement(genericType);
        if (primarySourceElement instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration xtendType = (XtendTypeDeclaration)primarySourceElement;
            HashMultimap type2extension = HashMultimap.create();
            for (XtendMember member : xtendType.getMembers()) {
                JvmType type;
                JvmTypeReference typeReference;
                XtendField field;
                if (!(member instanceof XtendField) || !Strings.isEmpty((String)(field = (XtendField)member).getName()) || !field.isExtension() || (typeReference = field.getType()) == null || (type = typeReference.getType()) == null) continue;
                type2extension.put((Object)type, (Object)field);
            }
            for (JvmType type : type2extension.keySet()) {
                Set fields = type2extension.get((Object)type);
                if (fields.size() <= 1) continue;
                for (XtendField field : fields) {
                    this.error(Messages.SARLInheritanceValidator_15, (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_field", new String[0]);
                }
            }
        }
    }

    protected void checkFunctionOverrides(IResolvedOperation operation, Set<EObject> flaggedOperations) {
        List allInherited;
        super.checkFunctionOverrides(operation, flaggedOperations);
        EObject sourceElement = this.findPrimarySourceElement(operation);
        if (sourceElement != null && (allInherited = operation.getOverriddenAndImplementedMethods()).isEmpty() && sourceElement instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)sourceElement;
            if (flaggedOperations.add(sourceElement)) {
                if (function.isOverride()) {
                    this.error(MessageFormat.format(Messages.SARLInheritanceValidator_16, operation.getSimpleSignature(), this.getDeclaratorName((JvmFeature)operation.getDeclaration())), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)this.getGrammarAccess().getOverrideKeyword()), "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override", new String[0]);
                } else {
                    for (XAnnotation anno : function.getAnnotations()) {
                        if (anno == null || anno.getAnnotationType() == null || !Override.class.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
                        this.error(Messages.SARLInheritanceValidator_17, (EObject)anno, null, "org.eclipse.xtend.core.validation.IssueCodes.obsolete_annotation_override", new String[0]);
                    }
                }
            }
        }
    }

    protected void checkFunctionOverrides(EObject sourceElement, IResolvedOperation resolved, List<IResolvedOperation> allInherited) {
        boolean overrideProblems = false;
        ArrayList<IResolvedOperation> exceptionMismatch = null;
        for (IResolvedOperation inherited : allInherited) {
            SarlAction function;
            if (inherited.getOverrideCheckResult().hasProblems()) {
                overrideProblems = true;
                EnumSet details = inherited.getOverrideCheckResult().getDetails();
                if (details.contains(IOverrideCheckResult.OverrideCheckDetails.IS_FINAL)) {
                    this.error(MessageFormat.format(Messages.SARLInheritanceValidator_21, inherited.getSimpleSignature()), sourceElement, this.getFeatureForIssue(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.overridden_final", new String[0]);
                    continue;
                }
                if (details.contains(IOverrideCheckResult.OverrideCheckDetails.REDUCED_VISIBILITY)) {
                    this.error(MessageFormat.format(Messages.SARLInheritanceValidator_22, inherited.getSimpleSignature()), sourceElement, this.getFeatureForIssue(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.override_reduces_visibility", new String[0]);
                    continue;
                }
                if (details.contains(IOverrideCheckResult.OverrideCheckDetails.EXCEPTION_MISMATCH)) {
                    if (exceptionMismatch == null) {
                        exceptionMismatch = new ArrayList<IResolvedOperation>(allInherited.size());
                    }
                    exceptionMismatch.add(inherited);
                    continue;
                }
                if (details.contains(IOverrideCheckResult.OverrideCheckDetails.RETURN_MISMATCH)) {
                    this.error(MessageFormat.format(Messages.SARLInheritanceValidator_23, inherited.getSimpleSignature()), sourceElement, this.returnTypeFeature(sourceElement, resolved), "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
                    continue;
                }
                if (!details.contains(IOverrideCheckResult.OverrideCheckDetails.SYNCHRONIZED_MISMATCH)) continue;
                this.warning(Messages.SARLInheritanceValidator_24, sourceElement, this.getFeatureForIssue(sourceElement), "org.eclipse.xtext.xbase.validation.IssueCodes.missing_synchronized", new String[0]);
                continue;
            }
            if (this.isIgnored("io.sarl.lang.validation.IssueCodes.return_type_specification_is_recommended", sourceElement) || !(sourceElement instanceof SarlAction) || (function = (SarlAction)sourceElement).getReturnType() != null || inherited.getResolvedReturnType().isPrimitiveVoid()) continue;
            this.addIssue(MessageFormat.format(Messages.SARLInheritanceValidator_20, resolved.getResolvedReturnType().getHumanReadableName()), sourceElement, this.returnTypeFeature(sourceElement), "io.sarl.lang.validation.IssueCodes.return_type_specification_is_recommended", new String[]{inherited.getResolvedReturnType().getIdentifier()});
        }
        if (exceptionMismatch != null) {
            this.createExceptionMismatchError(resolved, sourceElement, exceptionMismatch);
        }
        if (sourceElement instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)sourceElement;
            if (!(overrideProblems || function.isOverride() || function.isStatic())) {
                this.addIssue(MessageFormat.format(Messages.SARLInheritanceValidator_18, resolved.getSimpleSignature(), this.getDeclaratorName(resolved)), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.missing_override", new String[0]);
            }
            if (!overrideProblems && function.isOverride() && function.isStatic()) {
                for (IResolvedOperation inherited : allInherited) {
                    this.error(MessageFormat.format(Messages.SARLInheritanceValidator_19, resolved.getSimpleSignature(), this.getDeclaratorName(resolved), resolved.getSimpleSignature(), this.getDeclaratorName(inherited)), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, function.getModifiers().indexOf((Object)this.getGrammarAccess().getOverrideKeyword()), "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override", new String[0]);
                }
            }
            if (function.isOverride()) {
                for (XAnnotation anno : function.getAnnotations()) {
                    if (anno == null || anno.getAnnotationType() == null || !Override.class.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
                    this.warning(Messages.SARLInheritanceValidator_17, (EObject)anno, null, "org.eclipse.xtend.core.validation.IssueCodes.obsolete_annotation_override", new String[0]);
                }
            }
        }
    }

    protected void checkDefaultSuperConstructor(EObject sourceType, JvmGenericType type) {
        Iterable sarlConstructors;
        XtendTypeDeclaration container = this.filterConstructorContainer(sourceType);
        if (container != null && (sarlConstructors = Iterables.filter((Iterable)container.getMembers(), XtendConstructor.class)).iterator().hasNext()) {
            super.checkDefaultSuperConstructor(sourceType, type);
        }
    }

    private XtendTypeDeclaration filterConstructorContainer(EObject object) {
        if (object instanceof SarlAgent) {
            SarlAgent cvalue = (SarlAgent)object;
            return cvalue;
        }
        if (object instanceof SarlBehavior) {
            SarlBehavior cvalue = (SarlBehavior)object;
            return cvalue;
        }
        if (object instanceof SarlSkill) {
            SarlSkill cvalue = (SarlSkill)object;
            return cvalue;
        }
        if (object instanceof SarlEvent) {
            SarlEvent cvalue = (SarlEvent)object;
            return cvalue;
        }
        if (object instanceof SarlClass) {
            SarlClass cvalue = (SarlClass)object;
            return cvalue;
        }
        return null;
    }

    protected EStructuralFeature returnTypeFeature(EObject member, IResolvedOperation resolved) {
        EStructuralFeature returnTypeFeature = super.returnTypeFeature(member, resolved);
        if (returnTypeFeature == null && member instanceof XtendField) {
            return XtendPackage.Literals.XTEND_FIELD__TYPE;
        }
        return returnTypeFeature;
    }

    protected boolean shouldBeValidated(JvmIdentifiableElement element) {
        JvmOperation op;
        if (element instanceof JvmOperation && this.dispatchHelper.isDispatcherFunction(op = (JvmOperation)element)) {
            return false;
        }
        return super.shouldBeValidated(element);
    }
}

