/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.sarl.lang.controlflow.ISarlEarlyExitComputer;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.SarlPackage;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidatorWithParentLink;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.typesystem.LocalClassAwareTypeNames;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFormalParameter;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.core.xtend.XtendVariableDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.validation.ImplicitReturnFinder;
import org.eclipse.xtext.xbase.validation.ProxyAwareUIStrings;
import org.eclipse.xtext.xbase.validation.UIStrings;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class SARLMemberValidator
extends AbstractSARLSubValidatorWithParentLink {
    @Inject
    private ISarlEarlyExitComputer earlyExitComputer;
    @Inject
    private UIStrings uiStrings;
    @Inject
    private ProxyAwareUIStrings proxyAwareUIStrings;
    @Inject
    private LocalClassAwareTypeNames localClassAwareTypeNames;
    @Inject
    private IBatchTypeResolver batchTypeResolver;
    @Inject
    private ImplicitReturnFinder implicitReturnFinder;

    @Check(value=CheckType.FAST)
    public void checkEarlyExitEventInFires(SarlAction action) {
        int i = 0;
        for (JvmTypeReference event : action.getFiredEvents()) {
            if (!this.earlyExitComputer.isEarlyExitEvent(event)) {
                this.info(MessageFormat.format(Messages.SARLMemberValidator_2, event.getSimpleName()), (EObject)action, (EStructuralFeature)SarlPackage.eINSTANCE.getSarlAction_FiredEvents(), i, "io.sarl.lang.validation.IssueCodes.unnecessary_fired_event", new String[0]);
            }
            ++i;
        }
    }

    @Check(value=CheckType.FAST)
    public void checkRequiredCapacityUse(SarlRequiredCapacity statement) {
        this.warning(MessageFormat.format(Messages.SARLMemberValidator_1, this.getGrammarAccess().getRequiresKeyword()), (EObject)statement, null, -1, "io.sarl.lang.validation.IssueCodes.unsupported_statement", new String[0]);
    }

    @Check(value=CheckType.FAST)
    public void checkCapacityTypeForUses(SarlCapacityUses uses) {
        for (JvmParameterizedTypeReference usedType : uses.getCapacities()) {
            LightweightTypeReference ref = this.toLightweightTypeReference((JvmTypeReference)usedType);
            if (ref == null || this.getInheritanceHelper().isSarlCapacity(ref)) continue;
            this.error(MessageFormat.format(Messages.SARLMemberValidator_3, usedType.getQualifiedName(), Messages.SARLMemberValidator_4, this.getGrammarAccess().getUsesKeyword()), (EObject)usedType, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_capacity_type", new String[]{usedType.getSimpleName()});
        }
    }

    @Check(value=CheckType.FAST)
    public void checkActionFires(SarlAction action) {
        for (JvmTypeReference event : action.getFiredEvents()) {
            LightweightTypeReference ref = this.toLightweightTypeReference(event);
            if (ref == null || this.getInheritanceHelper().isSarlEvent(ref)) continue;
            this.error(MessageFormat.format(Messages.SARLMemberValidator_3, event.getQualifiedName(), Messages.SARLMemberValidator_5, this.getGrammarAccess().getFiresKeyword()), (EObject)event, null, -1, "io.sarl.lang.validation.IssueCodes.invalid_firing_event_type", new String[]{event.getSimpleName()});
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkFinalFieldInitialization(SarlEvent event) {
        JvmGenericType inferredType = this.getAssociations().getInferredType(event);
        if (inferredType != null) {
            this.getParentValidator().doCheckFinalFieldInitialization(inferredType, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkFinalFieldInitialization(SarlBehavior behavior) {
        JvmGenericType inferredType = this.getAssociations().getInferredType(behavior);
        if (inferredType != null) {
            this.getParentValidator().doCheckFinalFieldInitialization(inferredType, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkFinalFieldInitialization(SarlSkill skill) {
        JvmGenericType inferredType = this.getAssociations().getInferredType(skill);
        if (inferredType != null) {
            this.getParentValidator().doCheckFinalFieldInitialization(inferredType, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkFinalFieldInitialization(SarlAgent agent) {
        JvmGenericType inferredType = this.getAssociations().getInferredType(agent);
        if (inferredType != null) {
            this.getParentValidator().doCheckFinalFieldInitialization(inferredType, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkFinalFieldInitialization(XtendClass clazz) {
        JvmGenericType inferredType = this.getAssociations().getInferredType(clazz);
        if (inferredType != null) {
            this.getParentValidator().doCheckFinalFieldInitialization(inferredType, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkFinalFieldInitialization(XtendInterface oopInterface) {
        JvmGenericType inferredType = this.getAssociations().getInferredType(oopInterface);
        if (inferredType != null) {
            this.getParentValidator().doCheckFinalFieldInitialization(inferredType, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkSuperConstructor(SarlAgent agent) {
        this.checkSuperConstructor(agent, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, this.doGetConstructorParameterTypes(Agent.class, (Notifier)agent));
    }

    @Check(value=CheckType.NORMAL)
    public void checkSuperConstructor(SarlBehavior behavior) {
        this.checkSuperConstructor(behavior, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, this.doGetConstructorParameterTypes(Behavior.class, (Notifier)behavior));
    }

    @Check(value=CheckType.NORMAL)
    public void checkSuperConstructor(SarlSkill skill) {
        this.checkSuperConstructor(skill, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, this.doGetConstructorParameterTypes(Skill.class, (Notifier)skill));
    }

    @Check(value=CheckType.NORMAL)
    public void checkSuperConstructor(SarlEvent event) {
        this.checkSuperConstructor(event, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, this.doGetConstructorParameterTypes(Event.class, (Notifier)event));
    }

    @Check(value=CheckType.NORMAL)
    public void checkDefaultSuperConstructor(XtendClass xtendClass) {
        this.checkSuperConstructor((XtendTypeDeclaration)xtendClass, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, this.doGetConstructorParameterTypes(Object.class, (Notifier)xtendClass));
    }

    protected void checkSuperConstructor(XtendTypeDeclaration container, EStructuralFeature feature, Collection<ActionParameterTypes> defaultSignatures) {
        JvmDeclaredType jvmElement = this.getAssociations().getInferredType(container);
        if (jvmElement != null) {
            JvmType supertype;
            TreeMap superConstructors = CollectionLiterals.newTreeMap((Comparator)null);
            JvmTypeReference typeRef = jvmElement.getExtendedClass();
            JvmType jvmType = supertype = typeRef == null ? null : typeRef.getType();
            if (supertype instanceof JvmGenericType) {
                JvmGenericType jvmSuperElement = (JvmGenericType)supertype;
                for (JvmConstructor superConstructor : jvmSuperElement.getDeclaredConstructors()) {
                    ActionParameterTypes sig = this.getSarlActionSignatures().createParameterTypesFromJvmModel(superConstructor.isVarArgs(), (List<JvmFormalParameter>)superConstructor.getParameters());
                    superConstructors.put(sig, superConstructor);
                }
            }
            ActionParameterTypes voidKey = this.getSarlActionSignatures().createParameterTypesForVoid();
            for (XtendMember member : container.getMembers()) {
                XFeatureCall cvalue;
                JvmIdentifiableElement calledFeature;
                SarlConstructor constructor;
                if (!(member instanceof SarlConstructor) || (constructor = (SarlConstructor)member).isStatic()) continue;
                boolean invokeDefaultConstructor = true;
                XExpression body = constructor.getExpression();
                if (body instanceof XBlockExpression) {
                    XBlockExpression block = (XBlockExpression)body;
                    if (!block.getExpressions().isEmpty()) {
                        XFeatureCall cvalue2;
                        JvmIdentifiableElement calledFeature2;
                        XExpression firstStatement = (XExpression)block.getExpressions().get(0);
                        if (firstStatement instanceof XConstructorCall) {
                            invokeDefaultConstructor = false;
                        } else if (firstStatement instanceof XFeatureCall && (calledFeature2 = (cvalue2 = (XFeatureCall)firstStatement).getFeature()) instanceof JvmConstructor) {
                            invokeDefaultConstructor = false;
                        }
                    }
                } else if (body instanceof XConstructorCall) {
                    invokeDefaultConstructor = false;
                } else if (body instanceof XFeatureCall && (calledFeature = (cvalue = (XFeatureCall)body).getFeature()) instanceof JvmConstructor) {
                    invokeDefaultConstructor = false;
                }
                if (!invokeDefaultConstructor || superConstructors.containsKey(voidKey)) continue;
                ArrayList<String> issueData = new ArrayList<String>();
                for (ActionParameterTypes defaultSignature : defaultSignatures) {
                    issueData.add(defaultSignature.toString());
                }
                assert (supertype != null);
                this.error(MessageFormat.format(Messages.SARLMemberValidator_6, supertype.getSimpleName()), (EObject)member, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.must_invoke_super_constructor", issueData.toArray(new String[issueData.size()]));
            }
        }
    }

    private Collection<ActionParameterTypes> doGetConstructorParameterTypes(Class<?> type, Notifier context) {
        ArrayList<ActionParameterTypes> parameters = new ArrayList<ActionParameterTypes>();
        JvmTypeReference typeReference = this.getTypeReferences().getTypeForName(type, context, new JvmTypeReference[0]);
        JvmType jvmType = typeReference.getType();
        if (jvmType instanceof JvmDeclaredType) {
            JvmDeclaredType declaredType = (JvmDeclaredType)jvmType;
            for (JvmConstructor constructor : declaredType.getDeclaredConstructors()) {
                ActionParameterTypes types = this.getSarlActionSignatures().createParameterTypesFromJvmModel(constructor.isVarArgs(), (List<JvmFormalParameter>)constructor.getParameters());
                if (types == null) continue;
                parameters.add(types);
            }
        }
        if (parameters.isEmpty()) {
            parameters.add(this.getSarlActionSignatures().createParameterTypesForVoid());
        }
        return parameters;
    }

    @Check(value=CheckType.NORMAL)
    public void checkDefaultValueTypeCompatibleWithParameterType(SarlFormalParameter param) {
        XExpression defaultValue = param.getDefaultValue();
        if (defaultValue != null) {
            LightweightTypeReference fromType;
            JvmTypeReference rawType = param.getParameterType();
            assert (rawType != null);
            LightweightTypeReference toType = this.toLightweightTypeReference(rawType, true);
            if (toType == null) {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_7, param.getName()), (EObject)param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__PARAMETER_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type", new String[0]);
                return;
            }
            if (this.isTypeFreeExpression(defaultValue)) {
                fromType = toType.isPrimitive() ? this.toLightweightTypeReference(this.getTypeReferences().getTypeForName(Object.class, (Notifier)param, new JvmTypeReference[0]), true) : toType;
            } else {
                fromType = this.getExpectedType(defaultValue);
                if (fromType == null && (fromType = this.getActualType(defaultValue)) == null) {
                    JvmFormalParameter jvmParam = this.getAssociations().getJvmParameter(param);
                    boolean generateError = true;
                    if (jvmParam != null) {
                        String defaultValueId = this.getSarlActionSignatures().extractDefaultValueString(jvmParam);
                        generateError = Strings.isEmpty((String)defaultValueId);
                    }
                    if (generateError) {
                        this.error(MessageFormat.format(Messages.SARLMemberValidator_8, param.getName()), (EObject)param, (EStructuralFeature)SarlPackage.Literals.SARL_FORMAL_PARAMETER__DEFAULT_VALUE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type", new String[0]);
                    }
                    return;
                }
            }
            if (fromType != toType && !Utils.canCast(fromType, toType, true, false, true)) {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_9, this.getNameOfTypes(fromType), SARLMemberValidator.canonicalName(toType)), (EObject)param, (EStructuralFeature)SarlPackage.Literals.SARL_FORMAL_PARAMETER__DEFAULT_VALUE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incompatible_types", new String[]{SARLMemberValidator.canonicalName(fromType), SARLMemberValidator.canonicalName(toType)});
                return;
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDefaultValuePureExpression(SarlFormalParameter param) {
        XExpression defaultValue = param.getDefaultValue();
        if (defaultValue != null) {
            InferredPrototype prototype;
            JvmIdentifiableElement container = this.getLogicalContainerProvider().getNearestLogicalContainer((EObject)param);
            if (container instanceof JvmOperation) {
                JvmOperation cvalue = (JvmOperation)container;
                prototype = this.getOperationHelper().getInferredPrototype(cvalue);
            } else if (container instanceof JvmConstructor) {
                JvmConstructor cvalue = (JvmConstructor)container;
                prototype = this.getOperationHelper().getInferredPrototype(cvalue);
            } else {
                throw new Error("internal error: not an operation or a constructor");
            }
            Iterable<XExpression> sideEffects = this.getOperationHelper().getSideEffectExpressions(prototype, defaultValue);
            for (XExpression call : sideEffects) {
                Object code;
                if (call instanceof XAbstractFeatureCall) {
                    XAbstractFeatureCall acall = (XAbstractFeatureCall)call;
                    JvmIdentifiableElement element = acall.getFeature();
                    if (element instanceof JvmExecutable) {
                        JvmExecutable cvalue = (JvmExecutable)element;
                        code = this.uiStrings.signature(cvalue);
                    } else {
                        code = Utils.getSarlCodeFor((EObject)call);
                    }
                } else if (call instanceof XConstructorCall) {
                    XConstructorCall cons = (XConstructorCall)call;
                    code = this.getGrammarAccess().getNewKeyword() + this.uiStrings.arguments(cons);
                } else {
                    code = Utils.getSarlCodeFor((EObject)call);
                }
                this.error(MessageFormat.format(Messages.SARLMemberValidator_10, code), (EObject)call, null, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
            }
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkDefaultValueFinalFieldReferenceInConstructor(SarlFormalParameter param) {
        JvmIdentifiableElement container;
        XExpression defaultValue = param.getDefaultValue();
        if (defaultValue != null && (container = this.getLogicalContainerProvider().getNearestLogicalContainer((EObject)param)) instanceof JvmConstructor) {
            Iterator<? extends XAbstractFeatureCall> iter = this.getAllFeatureCalls(defaultValue);
            while (iter.hasNext()) {
                JvmField field;
                XAbstractFeatureCall call = iter.next();
                JvmIdentifiableElement feature = call.getFeature();
                if (!(feature instanceof JvmField) || (field = (JvmField)feature).isFinal()) continue;
                this.error(MessageFormat.format(Messages.SARLMemberValidator_11, field.getSimpleName()), (EObject)call, (EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.forbidden_reference", new String[0]);
            }
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkDefaultValueRedefinition(SarlFormalParameter param) {
        JvmIdentifiableElement container;
        XExpression defaultValue = param.getDefaultValue();
        if (defaultValue != null && (container = this.getLogicalContainerProvider().getNearestLogicalContainer((EObject)param)) instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)container;
            TreeMap<ActionPrototype, JvmOperation> overridableOperations = new TreeMap<ActionPrototype, JvmOperation>();
            TreeMap<ActionPrototype, JvmOperation> operationsToImplement = new TreeMap<ActionPrototype, JvmOperation>();
            Utils.populateInheritanceContext(operation.getDeclaringType(), null, overridableOperations, null, operationsToImplement, null, this.getSarlActionSignatures());
            InferredPrototype inferredPrototype = this.getOperationHelper().getInferredPrototype(operation);
            ActionPrototype actionPrototype = this.getSarlActionSignatures().createActionPrototype(operation.getSimpleName(), inferredPrototype.getFormalParameterTypes());
            JvmOperation inheritedOperation = overridableOperations.get(actionPrototype);
            if (inheritedOperation == null) {
                inheritedOperation = operationsToImplement.get(actionPrototype);
            }
            if (inheritedOperation != null) {
                JvmFormalParameter currentParam = this.getAssociations().getJvmParameter(param);
                String referencedCode = this.getSarlActionSignatures().extractDefaultValueString(currentParam);
                String currentCode = Utils.getSarlCodeFor((EObject)defaultValue);
                if (Strings.equal((String)currentCode, (String)referencedCode)) {
                    if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.parameter_default_value_redefinition")) {
                        this.addIssue(MessageFormat.format(Messages.SARLMemberValidator_12, param.getName()), (EObject)param, (EStructuralFeature)SarlPackage.Literals.SARL_FORMAL_PARAMETER__DEFAULT_VALUE, -1, "io.sarl.lang.validation.IssueCodes.parameter_default_value_redefinition", new String[0]);
                    }
                } else {
                    this.error(MessageFormat.format(Messages.SARLMemberValidator_13, param.getName(), Utils.toReadableString(referencedCode), Utils.toReadableString(currentCode)), (EObject)param, (EStructuralFeature)SarlPackage.Literals.SARL_FORMAL_PARAMETER__DEFAULT_VALUE, -1, "io.sarl.lang.validation.IssueCodes.illegal_parameter_default_value_redefinition", new String[0]);
                }
            }
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkUnusedCapacities(SarlCapacityUses uses) {
        if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.unused_agent_capacity")) {
            XtendTypeDeclaration container = uses.getDeclaringType();
            JvmDeclaredType jvmContainer = (JvmDeclaredType)this.getAssociations().getPrimaryJvmElement((EObject)container);
            HashMap importedFeatures = CollectionLiterals.newHashMap();
            for (JvmOperation operation : jvmContainer.getDeclaredOperations()) {
                if (!Utils.isNameForHiddenCapacityImplementationCallingMethod(operation.getSimpleName())) continue;
                importedFeatures.put(operation.getSimpleName(), operation);
            }
            boolean isSkill = container instanceof SarlSkill;
            int index = 0;
            for (JvmParameterizedTypeReference capacity : uses.getCapacities()) {
                LightweightTypeReference lreference = this.toLightweightTypeReference((JvmTypeReference)capacity);
                if (isSkill && lreference.isAssignableFrom((JvmType)jvmContainer)) {
                    this.addIssue(MessageFormat.format(Messages.SARLMemberValidator_14, capacity.getSimpleName()), (EObject)uses, (EStructuralFeature)SarlPackage.Literals.SARL_CAPACITY_USES__CAPACITIES, index, "io.sarl.lang.validation.IssueCodes.unused_agent_capacity", new String[]{capacity.getSimpleName()});
                } else {
                    String fieldName = Utils.createNameForHiddenCapacityImplementationAttribute(capacity.getIdentifier());
                    String operationName = Utils.createNameForHiddenCapacityImplementationCallingMethodFromFieldName(fieldName);
                    JvmOperation operation = (JvmOperation)importedFeatures.get(operationName);
                    if (operation != null && !this.getParentValidator().isLocallyUsed((EObject)operation, (EObject)container)) {
                        this.addIssue(MessageFormat.format(Messages.SARLMemberValidator_15, capacity.getSimpleName()), (EObject)uses, (EStructuralFeature)SarlPackage.Literals.SARL_CAPACITY_USES__CAPACITIES, index, "io.sarl.lang.validation.IssueCodes.unused_agent_capacity", new String[]{capacity.getSimpleName()});
                    }
                }
                ++index;
            }
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkMultipleCapacityUses(SarlCapacityUses uses) {
        XtendTypeDeclaration declaringType;
        if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.redundant_capacity_use") && (declaringType = uses.getDeclaringType()) != null) {
            Set<String> previousCapacityUses = SARLMemberValidator.doGetPreviousCapacities(uses, declaringType.getMembers().iterator());
            int index = 0;
            for (JvmParameterizedTypeReference capacity : uses.getCapacities()) {
                if (previousCapacityUses.contains(capacity.getIdentifier())) {
                    this.addIssue(MessageFormat.format(Messages.SARLMemberValidator_16, capacity.getSimpleName()), (EObject)uses, (EStructuralFeature)SarlPackage.Literals.SARL_CAPACITY_USES__CAPACITIES, index, "io.sarl.lang.validation.IssueCodes.redundant_capacity_use", new String[]{capacity.getSimpleName()});
                } else {
                    previousCapacityUses.add(capacity.getIdentifier());
                }
                ++index;
            }
        }
    }

    private static Set<String> doGetPreviousCapacities(SarlCapacityUses uses, Iterator<XtendMember> iterator) {
        boolean continueToFill = true;
        TreeSet capacityUses = CollectionLiterals.newTreeSet((Comparator)null);
        while (continueToFill && iterator.hasNext()) {
            XtendMember elt = iterator.next();
            if (!(elt instanceof SarlCapacityUses)) continue;
            SarlCapacityUses usesElt = (SarlCapacityUses)elt;
            if (usesElt == uses) {
                continueToFill = false;
                continue;
            }
            for (JvmParameterizedTypeReference use : usesElt.getCapacities()) {
                capacityUses.add(use.getIdentifier());
            }
        }
        return capacityUses;
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkLocalUsageOfDeclaredXtendFunction(XtendFunction function) {
        JvmOperation mainOperation;
        if (this.doCheckValidMemberName((XtendMember)function) && !this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member") && (mainOperation = function.isDispatch() ? this.getAssociations().getDispatchOperation(function) : this.getAssociations().getDirectlyInferredOperation(function)) != null && mainOperation.getVisibility() == JvmVisibility.PRIVATE) {
            EObject outerType = this.getOutermostType((XtendMember)function);
            boolean isUsed = this.getParentValidator().isLocallyUsed((EObject)mainOperation, outerType);
            if (!isUsed && this.isDefaultValuedParameterFunction(function)) {
                for (EObject jvmElement : this.getAssociations().getJvmElements((EObject)function)) {
                    if (jvmElement == mainOperation || !(jvmElement instanceof JvmOperation) || !this.getParentValidator().isLocallyUsed(jvmElement, outerType)) continue;
                    isUsed = true;
                    break;
                }
            }
            if (!isUsed) {
                String message = MessageFormat.format(Messages.SARLMemberValidator_17, mainOperation.getSimpleName(), this.uiStrings.parameters((JvmIdentifiableElement)mainOperation), this.getDeclaratorName((JvmFeature)mainOperation));
                this.addIssueToState("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member", message, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME);
            }
        }
    }

    protected boolean isDefaultValuedParameterFunction(XtendFunction function) {
        for (XtendParameter parameter : function.getParameters()) {
            SarlFormalParameter sarlParameter;
            if (!(parameter instanceof SarlFormalParameter) || (sarlParameter = (SarlFormalParameter)parameter).getDefaultValue() == null) continue;
            return true;
        }
        return false;
    }

    @Check(value=CheckType.FAST)
    public void checkStaticConstructorPrototype(XtendConstructor constructor) {
        if (constructor.isStatic()) {
            if (!constructor.getAnnotations().isEmpty()) {
                this.error(Messages.SARLMemberValidator_18, (EObject)constructor, (EStructuralFeature)XtendPackage.eINSTANCE.getXtendAnnotationTarget_Annotations(), -1, "org.eclipse.xtend.core.validation.IssueCodes.wrong_annotation_target", new String[0]);
            }
            if (!constructor.getTypeParameters().isEmpty()) {
                this.error(Messages.SARLMemberValidator_19, (EObject)constructor, (EStructuralFeature)XtendPackage.eINSTANCE.getXtendExecutable_TypeParameters(), -1, "org.eclipse.xtend.core.validation.IssueCodes.constructor_type_params_not_supported", new String[0]);
            }
            if (!constructor.getParameters().isEmpty()) {
                this.error(Messages.SARLMemberValidator_20, (EObject)constructor, (EStructuralFeature)XtendPackage.eINSTANCE.getXtendExecutable_Parameters(), -1, "io.sarl.lang.validation.IssueCodes.unexpected_formal_parameter", new String[0]);
            }
            if (!constructor.getExceptions().isEmpty()) {
                this.error(Messages.SARLMemberValidator_21, (EObject)constructor, (EStructuralFeature)XtendPackage.eINSTANCE.getXtendExecutable_Parameters(), -1, "io.sarl.lang.validation.IssueCodes.unexpected_exception_throw", new String[0]);
            }
            if (constructor.getExpression() == null) {
                this.error(Messages.SARLMemberValidator_22, (EObject)constructor, (EStructuralFeature)XtendPackage.eINSTANCE.getXtendExecutable_Expression(), -1, "io.sarl.lang.validation.IssueCodes.missing_body", new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkAbstract(XtendFunction function) {
        XtendTypeDeclaration declarator = function.getDeclaringType();
        if (function.getExpression() == null || function.isAbstract()) {
            if (declarator instanceof XtendClass || declarator.isAnonymous() || declarator instanceof SarlAgent || declarator instanceof SarlBehavior || declarator instanceof SarlSkill) {
                if (function.isDispatch()) {
                    this.error(MessageFormat.format(Messages.SARLMemberValidator_27, function.getName(), this.localClassAwareTypeNames.getReadableName(declarator)), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "dispatch_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (function.getCreateExtensionInfo() != null) {
                    this.error(MessageFormat.format(Messages.SARLMemberValidator_28, function.getName(), this.localClassAwareTypeNames.getReadableName(declarator)), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "create_functions_must_not_be_abstract", new String[0]);
                    return;
                }
                if (declarator.isAnonymous()) {
                    this.error(MessageFormat.format(Messages.SARLMemberValidator_26, function.getName(), this.localClassAwareTypeNames.getReadableName(declarator)), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract_in_anonymous", new String[0]);
                } else {
                    boolean isAbstract;
                    if (declarator instanceof XtendClass) {
                        XtendClass cvalue = (XtendClass)declarator;
                        isAbstract = cvalue.isAbstract();
                    } else if (declarator instanceof SarlAgent) {
                        SarlAgent cvalue = (SarlAgent)declarator;
                        isAbstract = cvalue.isAbstract();
                    } else if (declarator instanceof SarlBehavior) {
                        SarlBehavior cvalue = (SarlBehavior)declarator;
                        isAbstract = cvalue.isAbstract();
                    } else if (declarator instanceof SarlSkill) {
                        SarlSkill cvalue = (SarlSkill)declarator;
                        isAbstract = cvalue.isAbstract();
                    } else {
                        return;
                    }
                    if (!isAbstract && !function.isNative()) {
                        this.error(MessageFormat.format(Messages.SARLMemberValidator_26, function.getName(), this.localClassAwareTypeNames.getReadableName(declarator)), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract", new String[0]);
                        return;
                    }
                }
                if (!function.getModifiers().contains((Object)this.getGrammarAccess().getAbstractKeyword())) {
                    this.warning(MessageFormat.format(Messages.SARLMemberValidator_25, function.getName(), this.localClassAwareTypeNames.getReadableName(declarator)), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.missing_abstract", new String[]{function.getName(), this.localClassAwareTypeNames.getReadableName(declarator)});
                }
            } else if ((declarator instanceof XtendInterface || declarator instanceof SarlCapacity) && function.getCreateExtensionInfo() != null) {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_24, function.getName()), (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "create_functions_must_not_be_abstract", new String[0]);
                return;
            }
        } else if (declarator instanceof SarlCapacity) {
            this.error(Messages.SARLMemberValidator_23, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.abstract_method_with_body", new String[0]);
        }
    }

    protected void checkValidExtensionType(JvmIdentifiableElement identifiable, EObject source, EStructuralFeature feature) {
        LightweightTypeReference type = this.getActualType(identifiable);
        if (type != null && type.isPrimitive()) {
            this.error(MessageFormat.format(Messages.SARLMemberValidator_29, type.getHumanReadableName()), source, feature, "org.eclipse.xtend.core.validation.IssueCodes.invalid_extension_type", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValidExtension(XtendField field) {
        JvmField jvmField;
        if (field.isExtension() && (jvmField = this.getAssociations().getJvmField(field)) != null) {
            this.checkValidExtensionType((JvmIdentifiableElement)jvmField, (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValidExtension(XtendFormalParameter parameter) {
        if (parameter.isExtension() && !(parameter.eContainer() instanceof XCatchClause)) {
            this.checkValidExtensionType((JvmIdentifiableElement)parameter, (EObject)parameter, (EStructuralFeature)TypesPackage.Literals.JVM_FORMAL_PARAMETER__PARAMETER_TYPE);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValidExtension(XtendVariableDeclaration variableDeclaration) {
        if (variableDeclaration.isExtension()) {
            this.checkValidExtensionType((JvmIdentifiableElement)variableDeclaration, (EObject)variableDeclaration, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkValidExtension(XtendParameter parameter) {
        JvmFormalParameter jvmParameter;
        if (parameter.isExtension() && (jvmParameter = this.getAssociations().getJvmParameter(parameter)) != null) {
            this.checkValidExtensionType((JvmIdentifiableElement)jvmParameter, (EObject)parameter, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__PARAMETER_TYPE);
        }
    }

    private void validateInferredType(JvmTypeReference inferredType, XtendMember member, String messagePrefix, EAttribute location) {
        if (inferredType != null) {
            TreeIterator iterator = EcoreUtil2.eAll((EObject)inferredType);
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next instanceof JvmParameterizedTypeReference) {
                    JvmGenericType cvalue;
                    JvmParameterizedTypeReference candidate = (JvmParameterizedTypeReference)next;
                    JvmType type = candidate.getType();
                    if (!(type instanceof JvmGenericType) || (cvalue = (JvmGenericType)type).getTypeParameters().isEmpty() || !candidate.getArguments().isEmpty()) continue;
                    StringBuilder message = new StringBuilder(messagePrefix);
                    if ((message = this.proxyAwareUIStrings.visit(inferredType, message)) != null && !this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.raw_type")) {
                        StringBuilder msg2 = new StringBuilder();
                        msg2 = this.proxyAwareUIStrings.appendTypeSignature(type, msg2);
                        String m = MessageFormat.format(Messages.SARLMemberValidator_30, message.toString(), type.getSimpleName(), msg2.toString());
                        this.addIssue(m.toString(), (EObject)member, (EStructuralFeature)location, "org.eclipse.xtext.xbase.validation.IssueCodes.raw_type", new String[0]);
                    }
                    return;
                }
                if (!(next instanceof XComputedTypeReference)) continue;
                XComputedTypeReference cvalue = (XComputedTypeReference)next;
                this.validateInferredType(cvalue.getEquivalent(), member, messagePrefix, location);
                iterator.prune();
            }
        }
    }

    @Check
    public void checkNonRawTypeInferred(XtendField field) {
        JvmField jvmField;
        if (field.getType() == null && (jvmField = this.getAssociations().getJvmField(field)) != null && jvmField.eResource() != null) {
            JvmTypeReference fieldType = jvmField.getType();
            this.validateInferredType(fieldType, (XtendMember)field, Messages.SARLMemberValidator_31, XtendPackage.Literals.XTEND_FIELD__NAME);
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkNonRawTypeInferred(XtendFunction function) {
        JvmOperation operation;
        if (function.getReturnType() == null && (operation = this.getAssociations().getDirectlyInferredOperation(function)) != null && operation.eResource() != null) {
            JvmTypeReference returnType = operation.getReturnType();
            this.validateInferredType(returnType, (XtendMember)function, Messages.SARLMemberValidator_32, XtendPackage.Literals.XTEND_FUNCTION__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkVarArgIsNotExtension(XtendParameter param) {
        if (param.isVarArg() && param.isExtension()) {
            this.error(Messages.SARLMemberValidator_33, (EObject)param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__EXTENSION, "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkVarArgComesLast(XtendParameter param) {
        List params;
        if (param.isVarArg() && param != Iterables.getLast((Iterable)(params = (List)param.eContainer().eGet(param.eContainingFeature())))) {
            this.error(Messages.SARLMemberValidator_34, (EObject)param, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__VAR_ARG, "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_varArg", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkParameterNames(XtendFunction function) {
        for (int i = 0; i < function.getParameters().size(); ++i) {
            String leftParameterName = ((XtendParameter)function.getParameters().get(i)).getName();
            if (function.getCreateExtensionInfo() == null || !Objects.equals(leftParameterName, function.getCreateExtensionInfo().getName())) continue;
            this.error(MessageFormat.format(Messages.SARLMemberValidator_35, leftParameterName), (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
            if (function.getCreateExtensionInfo().eIsSet((EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME)) {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_35, leftParameterName), (EObject)function.getCreateExtensionInfo(), (EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
                continue;
            }
            this.error(MessageFormat.format(Messages.SARLMemberValidator_36, this.getGrammarAccess().getItKeyword()), (EObject)function.getCreateExtensionInfo(), (EStructuralFeature)XtendPackage.Literals.CREATE_EXTENSION_INFO__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_parameter_name", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void dispatchFuncWithTypeParams(XtendFunction function) {
        if (function.isDispatch()) {
            String dkw = this.getGrammarAccess().getDispatchKeyword();
            if (function.getParameters().isEmpty()) {
                this.error(Messages.SARLMemberValidator_37, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)dkw), "org.eclipse.xtend.core.validation.IssueCodes.case_function_without_params", new String[0]);
            }
            if (!function.getTypeParameters().isEmpty()) {
                this.error(Messages.SARLMemberValidator_38, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)dkw), "org.eclipse.xtend.core.validation.IssueCodes.case_function_with_type_params", new String[0]);
            }
            if (function.getName().startsWith("_")) {
                this.error(Messages.SARLMemberValidator_39, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.case_func_name_starts_with_underscore", new String[0]);
            }
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkNoReturnsInCreateExtensions(XtendFunction function) {
        if (function.getCreateExtensionInfo() == null) {
            return;
        }
        ArrayList<XReturnExpression> found = new ArrayList<XReturnExpression>();
        SARLMemberValidator.collectReturnExpressions((EObject)function.getCreateExtensionInfo().getCreateExpression(), found);
        for (XReturnExpression xReturnExpression : found) {
            this.error(Messages.SARLMemberValidator_40, (EObject)xReturnExpression, null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_early_exit", new String[0]);
        }
    }

    private static void collectReturnExpressions(EObject expr, List<XReturnExpression> found) {
        LinkedList<EObject> candidates = new LinkedList<EObject>();
        candidates.add(expr);
        while (!candidates.isEmpty()) {
            EObject candidate = (EObject)candidates.removeFirst();
            if (candidate instanceof XReturnExpression) {
                XReturnExpression cvalue = (XReturnExpression)candidate;
                found.add(cvalue);
            } else if (expr instanceof XClosure) continue;
            candidates.addAll((Collection<EObject>)expr.eContents());
        }
    }

    @Check(value=CheckType.FAST)
    public void checkCreateFunctionIsNotTypeVoid(XtendFunction function) {
        if (function.getCreateExtensionInfo() == null) {
            return;
        }
        if (function.getReturnType() == null) {
            JvmOperation operation = this.getAssociations().getDirectlyInferredOperation(function);
            if (operation != null && this.getParentValidator().isPrimitiveVoid(operation.getReturnType())) {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_41, function.getName()), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        } else if (this.getParentValidator().isPrimitiveVoid(function.getReturnType())) {
            if (function.getReturnType() != null) {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_42, function.getName()), (EObject)function.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            } else {
                this.error(MessageFormat.format(Messages.SARLMemberValidator_43, function.getName()), (EObject)function.getReturnType(), null, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_use_of_void", new String[0]);
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkCreateFunctionIsNotGeneric(XtendFunction function) {
        if (function.getCreateExtensionInfo() != null && !function.getTypeParameters().isEmpty()) {
            this.error(Messages.SARLMemberValidator_44, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)this.getGrammarAccess().getStaticStaticKeyword()), "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkCreateFunctionIsNotStatic(XtendFunction function) {
        if (function.getCreateExtensionInfo() != null && function.isStatic()) {
            this.error(Messages.SARLMemberValidator_45, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)this.getGrammarAccess().getStaticStaticKeyword()), "org.eclipse.xtend.core.validation.IssueCodes.invalid_use_of_static", new String[0]);
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkLocalUsageOfDeclaredFields(XtendField field) {
        if (this.doCheckValidMemberName((XtendMember)field) && !this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member")) {
            JvmField jvmField = this.getAssociations().getJvmField(field);
            if (jvmField == null || jvmField.getVisibility() != JvmVisibility.PRIVATE || jvmField.eContainer() == null) {
                return;
            }
            if (this.getParentValidator().isLocallyUsed((EObject)jvmField, this.getOutermostType((XtendMember)field))) {
                return;
            }
            String message = field.isExtension() ? (field.getName() == null && jvmField.getType() != null ? MessageFormat.format(Messages.SARLMemberValidator_46, jvmField.getType().getIdentifier(), this.getDeclaratorName((JvmFeature)jvmField)) : MessageFormat.format(Messages.SARLMemberValidator_47, this.getDeclaratorName((JvmFeature)jvmField), jvmField.getSimpleName())) : MessageFormat.format(Messages.SARLMemberValidator_48, this.getDeclaratorName((JvmFeature)jvmField), jvmField.getSimpleName());
            this.addIssueToState("org.eclipse.xtend.core.validation.IssueCodes.unused_private_member", message, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkTypeParameterForwardReferences(XtendFunction xtendFunction) {
        this.getParentValidator().doCheckTypeParameterForwardReference((List<JvmTypeParameter>)xtendFunction.getTypeParameters());
    }

    @Check(value=CheckType.FAST)
    public void checkTypeParametersAreUnsupported(XtendConstructor constructor) {
        if (!constructor.getTypeParameters().isEmpty()) {
            this.error(Messages.SARLMemberValidator_49, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__TYPE_PARAMETERS, -1, "org.eclipse.xtend.core.validation.IssueCodes.constructor_type_params_not_supported", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkJavaKeywordConflict(XtendField field) {
        this.checkNoJavaKeyword((EObject)field, XtendPackage.Literals.XTEND_FIELD__NAME);
    }

    @Check(value=CheckType.FAST)
    public void checkJavaKeywordConflict(XtendFunction function) {
        if (function.eContainer() instanceof XtendAnnotationType && this.getGrammarAccess().getDoKeyword().equals(function.getName())) {
            return;
        }
        this.checkNoJavaKeyword((EObject)function, XtendPackage.Literals.XTEND_FUNCTION__NAME);
        for (JvmTypeParameter p : function.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkJavaKeywordConflict(XtendConstructor constructor) {
        for (JvmTypeParameter p : constructor.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkNonInitializedFieldsHaveAType(XtendField field) {
        if (field.getType() == null && field.getInitialValue() == null) {
            this.error(MessageFormat.format(Messages.SARLMemberValidator_50, field.getName()), (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.too_little_type_information", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkFieldsAreCalledSelf(XtendField field) {
        if ("self".equals(field.getName())) {
            this.addIssue(Messages.SARLMemberValidator_51, (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged", new String[0]);
        }
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkImplicitReturn(XtendFunction function) {
        if (!this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.implicit_return")) {
            JvmOperation jvmOperation = this.getAssociations().getDirectlyInferredOperation(function);
            IResolvedTypes types = this.batchTypeResolver.resolveTypes((EObject)function);
            if (jvmOperation == null || !types.getActualType((JvmIdentifiableElement)jvmOperation).isPrimitiveVoid()) {
                this.implicitReturnFinder.findImplicitReturns(function.getExpression(), implicitReturn -> {
                    if (function.getExpression() != implicitReturn) {
                        this.addIssue(Messages.SARLMemberValidator_52, (EObject)implicitReturn, "org.eclipse.xtend.core.validation.IssueCodes.implicit_return");
                    }
                });
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkBehaviourUnitEventTypeConformance(SarlBehaviorUnit unit) {
        JvmParameterizedTypeReference event = unit.getName();
        if (event != null) {
            LightweightTypeReference lref = this.getParentValidator().toLightweightTypeReference((JvmTypeReference)event);
            this.getParentValidator().doCheckValidSuperTypeArgumentDefinition(lref, (EObject)unit, (EStructuralFeature)SarlPackage.Literals.SARL_BEHAVIOR_UNIT__NAME, -1, true, false, this.getMessageAcceptor());
        }
    }

    @Check(value=CheckType.FAST)
    public void checkJavaMainFunction(SarlAction function) {
        XtendTypeDeclaration container;
        if (Utils.isNameForJavaMainFunction(function.getName()) && (container = function.getDeclaringType()) instanceof SarlClass) {
            if (!function.isStatic()) {
                if (!this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier")) {
                    String staticKeyword = this.getGrammarAccess().getStaticStaticKeyword();
                    this.addIssue(MessageFormat.format(Messages.SARLMemberValidator_54, staticKeyword), (EObject)function, "org.eclipse.xtend.core.validation.IssueCodes.missing_static_modifier");
                }
            } else {
                if (!function.getTypeParameters().isEmpty()) {
                    this.error(Messages.SARLMemberValidator_56, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__TYPE_PARAMETERS, "io.sarl.lang.validation.IssueCodes.unexpected_type_parameter", new String[0]);
                }
                int i = 0;
                for (XtendParameter formalParameter : function.getParameters()) {
                    SarlFormalParameter sarlParameter;
                    LightweightTypeReference type = this.toLightweightTypeReference(formalParameter.getParameterType());
                    if (type.isArray()) {
                        type = type.getComponentType();
                    }
                    if (!type.isType(String.class)) {
                        this.error(MessageFormat.format(Messages.SARLMemberValidator_55, String.class.getSimpleName(), formalParameter.getName()), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtext.xbase.validation.IssueCodes.invalid_type", new String[0]);
                    }
                    if (formalParameter instanceof SarlFormalParameter && (sarlParameter = (SarlFormalParameter)formalParameter).getDefaultValue() != null) {
                        this.error(MessageFormat.format(Messages.SARLMemberValidator_53, formalParameter.getName()), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "io.sarl.lang.validation.IssueCodes.unexpected_default_value", new String[0]);
                    }
                    ++i;
                }
            }
        }
    }
}

