/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.inject.Inject;
import io.sarl.lang.jvmmodel.IDefaultVisibilityProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.validation.Check;

public class SARLModifierValidator {
    private IDefaultVisibilityProvider defaultVisibilityProvider;
    private SARLGrammarKeywordAccess grammarAccess;
    private final ErrorRegisterer errorRegisterer;
    private final IssueRegisterer issueRegisterer;
    private final Set<String> allowedModifiers;
    private final String allowedModifiersAsStringWithAnd;
    private final String allowedModifiersAsStringWithOr;
    private final List<String> visibilityModifiers;

    public SARLModifierValidator(List<String> modifiers, List<String> visibilityModifiers, ErrorRegisterer errorRegisterer, IssueRegisterer issueRegisterer) {
        assert (modifiers != null && !modifiers.isEmpty());
        this.errorRegisterer = errorRegisterer;
        this.issueRegisterer = issueRegisterer;
        this.visibilityModifiers = visibilityModifiers;
        this.allowedModifiers = new HashSet<String>(modifiers);
        StringBuffer andBuffer = new StringBuffer();
        StringBuffer orBuffer = new StringBuffer();
        String modifier = modifiers.get(0);
        andBuffer.append(modifier);
        orBuffer.append(modifier);
        int endSize = modifiers.size() - 1;
        if (endSize > 0) {
            for (int i = 1; i < endSize; ++i) {
                modifier = modifiers.get(i);
                andBuffer.append(", ").append(modifier);
                orBuffer.append(", ").append(modifier);
            }
            modifier = modifiers.get(endSize);
            andBuffer.append(' ').append(Messages.SARLModifierValidator_4).append(' ').append(modifier);
            orBuffer.append(' ').append(Messages.SARLModifierValidator_5).append(' ').append(modifier);
        }
        this.allowedModifiersAsStringWithAnd = andBuffer.toString();
        this.allowedModifiersAsStringWithOr = orBuffer.toString();
    }

    @Inject
    public void setGrammarAccess(SARLGrammarKeywordAccess grammarAccess) {
        this.grammarAccess = grammarAccess;
    }

    @Inject
    public void setDefaultVisibilityProvider(IDefaultVisibilityProvider provider) {
        this.defaultVisibilityProvider = provider;
    }

    @Check
    protected void checkModifiers(XtendMember member, String memberName) {
        HashSet<String> seenModifiers = new HashSet<String>();
        boolean visibilitySeen = false;
        boolean abstractSeen = false;
        boolean defSeen = false;
        boolean staticSeen = false;
        boolean finalSeen = false;
        boolean varSeen = false;
        int defKeywordIndex = -1;
        int finalKeywordIndex = -1;
        String privateKeyword = this.grammarAccess.getPrivateKeyword();
        String protectedKeyword = this.grammarAccess.getProtectedKeyword();
        String packageKeyword = this.grammarAccess.getPackageKeyword();
        String publicKeyword = this.grammarAccess.getPublicKeyword();
        String abstractKeyword = this.grammarAccess.getAbstractKeyword();
        String staticKeyword = this.grammarAccess.getStaticStaticKeyword();
        String finalKeyword = this.grammarAccess.getFinalKeyword();
        String varKeyword = this.grammarAccess.getWriteableVarKeyword();
        String valKeyword = this.grammarAccess.getValKeyword();
        String defKeyword = this.grammarAccess.getDefKeyword();
        String overrideKeyword = this.grammarAccess.getOverrideKeyword();
        int i = 0;
        for (String modifier : member.getModifiers()) {
            if (!this.allowedModifiers.contains(modifier)) {
                this.error(MessageFormat.format(Messages.SARLModifierValidator_2, memberName, this.allowedModifiersAsStringWithAnd), (EObject)member, i);
            }
            if (seenModifiers.contains(modifier)) {
                this.error(MessageFormat.format(Messages.SARLModifierValidator_3, memberName), (EObject)member, i);
            } else {
                seenModifiers.add(modifier);
                if (this.visibilityModifiers.contains(modifier)) {
                    if (visibilitySeen) {
                        this.error(MessageFormat.format(Messages.SARLModifierValidator_6, memberName, this.allowedModifiersAsStringWithOr), (EObject)member, i);
                    }
                    visibilitySeen = true;
                    if (privateKeyword.equals(modifier) && this.isPrivateByDefault(member)) {
                        this.unnecessaryModifierIssue(privateKeyword, memberName, (EObject)member, i);
                    }
                    if (protectedKeyword.equals(modifier) && this.isProtectedByDefault(member)) {
                        this.unnecessaryModifierIssue(protectedKeyword, memberName, (EObject)member, i);
                    }
                    if (packageKeyword.equals(modifier) && this.isPackageByDefault(member)) {
                        this.unnecessaryModifierIssue(packageKeyword, memberName, (EObject)member, i);
                    }
                    if (publicKeyword.equals(modifier) && this.isPublicByDefault(member)) {
                        this.unnecessaryModifierIssue(publicKeyword, memberName, (EObject)member, i);
                    }
                }
            }
            if (Objects.equals(modifier, abstractKeyword)) {
                if (finalSeen) {
                    this.error(MessageFormat.format(Messages.SARLModifierValidator_7, memberName), (EObject)member, i);
                }
                if (staticSeen && !(member instanceof XtendTypeDeclaration)) {
                    this.error(MessageFormat.format(Messages.SARLModifierValidator_8, memberName), (EObject)member, i);
                }
                abstractSeen = true;
            } else if (Objects.equals(modifier, staticKeyword)) {
                if (abstractSeen && !(member instanceof XtendTypeDeclaration)) {
                    this.error(MessageFormat.format(Messages.SARLModifierValidator_9, memberName), (EObject)member, i);
                }
                staticSeen = true;
            } else if (Objects.equals(modifier, finalKeyword) || Objects.equals(modifier, valKeyword)) {
                if (abstractSeen) {
                    this.error(MessageFormat.format(Messages.SARLModifierValidator_10, memberName), (EObject)member, i);
                }
                if (varSeen) {
                    this.error(MessageFormat.format(Messages.SARLModifierValidator_11, memberName), (EObject)member, i);
                }
                if (Objects.equals(modifier, finalKeyword)) {
                    finalKeywordIndex = i;
                }
                if (finalSeen) {
                    this.unnecessaryModifierIssue(finalKeyword, memberName, (EObject)member, finalKeywordIndex);
                }
                finalSeen = true;
            } else if (Objects.equals(modifier, varKeyword)) {
                if (finalSeen) {
                    this.error(MessageFormat.format(Messages.SARLModifierValidator_11, memberName), (EObject)member, i);
                }
                varSeen = true;
            } else if ((Objects.equals(modifier, defKeyword) || Objects.equals(modifier, overrideKeyword)) && member instanceof XtendFunction) {
                if (Objects.equals(modifier, defKeyword)) {
                    defKeywordIndex = i;
                }
                if (defSeen) {
                    this.unnecessaryModifierIssue(defKeyword, memberName, (EObject)member, defKeywordIndex);
                }
                defSeen = true;
            }
            ++i;
        }
    }

    protected void unnecessaryModifierIssue(String modifier, String memberName, EObject source, int index) {
        this.issue(MessageFormat.format(Messages.SARLModifierValidator_1, modifier, memberName), source, index, "org.eclipse.xtend.core.validation.IssueCodes.unnecessary_modifier", modifier);
    }

    protected void issue(String message, EObject source, int index, String code, String ... issueData) {
        this.issueRegisterer.issue(message, source, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, index, code, issueData);
    }

    protected void error(String message, EObject source, int index) {
        this.errorRegisterer.error(message, source, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, index, "org.eclipse.xtend.core.validation.IssueCodes.invalid_modifier", new String[0]);
    }

    protected boolean isPrivateByDefault(XtendMember member) {
        JvmVisibility defaultVisibility = this.defaultVisibilityProvider.getDefaultJvmVisibility((EObject)member);
        return defaultVisibility == JvmVisibility.PRIVATE;
    }

    protected boolean isProtectedByDefault(XtendMember member) {
        JvmVisibility defaultVisibility = this.defaultVisibilityProvider.getDefaultJvmVisibility((EObject)member);
        return defaultVisibility == JvmVisibility.PROTECTED;
    }

    protected boolean isPackageByDefault(XtendMember member) {
        JvmVisibility defaultVisibility = this.defaultVisibilityProvider.getDefaultJvmVisibility((EObject)member);
        return defaultVisibility == JvmVisibility.DEFAULT;
    }

    protected boolean isPublicByDefault(XtendMember member) {
        JvmVisibility defaultVisibility = this.defaultVisibilityProvider.getDefaultJvmVisibility((EObject)member);
        return defaultVisibility == JvmVisibility.PUBLIC;
    }

    @FunctionalInterface
    public static interface ErrorRegisterer {
        public void error(String var1, EObject var2, EStructuralFeature var3, int var4, String var5, String ... var6);
    }

    @FunctionalInterface
    public static interface IssueRegisterer {
        public void issue(String var1, EObject var2, EStructuralFeature var3, int var4, String var5, String ... var6);
    }
}

