/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbasePackage;

public class SARLNamingValidator
extends AbstractSARLSubValidator {
    @Check(value=CheckType.FAST)
    public void checkActionName(SarlAction action) {
        JvmOperation inferredOperation = this.getAssociations().getDirectlyInferredOperation(action);
        QualifiedName name = QualifiedName.create((String[])inferredOperation.getQualifiedName('.').split("\\."));
        if (this.isReallyDisallowedName(name)) {
            String validName = Utils.fixHiddenMember(action.getName());
            this.error(MessageFormat.format(Messages.SARLNamingValidator_1, action.getName()), (EObject)action, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "org.eclipse.xtend.core.validation.IssueCodes.invalid_member_name", new String[]{validName});
        } else if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_function_name") && this.getFeatureNameValidator().isDiscouragedName(name)) {
            this.addIssue(MessageFormat.format(Messages.SARLNamingValidator_1, action.getName()), (EObject)action, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, -1, "io.sarl.lang.validation.IssueCodes.discouraged_function_name", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkFieldName(SarlField field) {
        JvmField inferredField = this.getAssociations().getJvmField(field);
        QualifiedName name = Utils.getQualifiedName((JvmIdentifiableElement)inferredField);
        if (this.isReallyDisallowedName(name)) {
            String validName = Utils.fixHiddenMember(field.getName());
            this.error(MessageFormat.format(Messages.SARLNamingValidator_2, field.getName(), Messages.SARLNamingValidator_3), (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[]{validName});
        } else if (this.getGrammarAccess().getOccurrenceKeyword().equals(field.getName())) {
            this.error(MessageFormat.format(Messages.SARLNamingValidator_4, this.getGrammarAccess().getOccurrenceKeyword(), Messages.SARLNamingValidator_3), (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkGenericTypeNameShadowing(JvmTypeParameter type) {
        XtendMember declarator = (XtendMember)EcoreUtil2.getContainerOfType((EObject)type.eContainer(), XtendMember.class);
        if (declarator instanceof XtendFunction && !SarlUtils.isHiddenMember((String)type.getName())) {
            XtendTypeDeclaration enclosingType = declarator.getDeclaringType();
            EList params = null;
            if (enclosingType instanceof XtendClass) {
                XtendClass cvalue = (XtendClass)enclosingType;
                params = cvalue.getTypeParameters();
            } else if (enclosingType instanceof XtendInterface) {
                XtendInterface cvalue = (XtendInterface)enclosingType;
                params = cvalue.getTypeParameters();
            }
            if (params != null && !params.isEmpty()) {
                for (JvmTypeParameter declaredType : params) {
                    if (!Strings.equal((String)type.getSimpleName(), (String)declaredType.getSimpleName())) continue;
                    this.error(MessageFormat.format(Messages.SARLNamingValidator_5, type.getSimpleName(), enclosingType.getName()), (EObject)type, (EStructuralFeature)TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME, -1, "io.sarl.lang.validation.IssueCodes.generic_type_name_shadowing", new String[0]);
                    return;
                }
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkFieldNameShadowing(SarlField field) {
        if (!this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing") && !SarlUtils.isHiddenMember((String)field.getName())) {
            JvmField inferredField = this.getAssociations().getJvmField(field);
            TreeMap<String, JvmField> inheritedFields = new TreeMap<String, JvmField>();
            Utils.populateInheritanceContext(inferredField.getDeclaringType(), null, null, inheritedFields, null, null, this.getSarlActionSignatures());
            JvmField inheritedField = inheritedFields.get(field.getName());
            if (inheritedField != null) {
                int nameIndex = 0;
                String newName = field.getName() + nameIndex;
                while (inheritedFields.containsKey(newName)) {
                    newName = field.getName() + ++nameIndex;
                }
                this.addIssue(MessageFormat.format(Messages.SARLNamingValidator_6, field.getName(), inferredField.getDeclaringType().getQualifiedName(), inheritedField.getQualifiedName()), (EObject)field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing", new String[]{newName});
            }
        }
    }

    @Check(value=CheckType.FAST)
    public void checkParameterName(SarlFormalParameter parameter) {
        JvmFormalParameter inferredParam = this.getAssociations().getJvmParameter(parameter);
        QualifiedName name = Utils.getQualifiedName((JvmIdentifiableElement)inferredParam);
        if (this.isReallyDisallowedName(name)) {
            this.error(MessageFormat.format(Messages.SARLNamingValidator_2, parameter.getName(), Messages.SARLNamingValidator_7), (EObject)parameter, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
        } else if (this.getGrammarAccess().getOccurrenceKeyword().equals(parameter.getName())) {
            this.error(MessageFormat.format(Messages.SARLNamingValidator_4, this.getGrammarAccess().getOccurrenceKeyword(), Messages.SARLNamingValidator_7), (EObject)parameter, (EStructuralFeature)XtendPackage.Literals.XTEND_PARAMETER__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkParameterName(XClosure closure) {
        int index = 0;
        for (JvmFormalParameter param : closure.getDeclaredFormalParameters()) {
            QualifiedName name = Utils.getQualifiedName((JvmIdentifiableElement)param);
            if (this.isReallyDisallowedName(name)) {
                this.error(MessageFormat.format(Messages.SARLNamingValidator_2, param.getName(), Messages.SARLNamingValidator_7), (EObject)closure, (EStructuralFeature)XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS, index, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
            } else if (this.getGrammarAccess().getOccurrenceKeyword().equals(param.getName())) {
                this.error(MessageFormat.format(Messages.SARLNamingValidator_4, this.getGrammarAccess().getOccurrenceKeyword(), Messages.SARLNamingValidator_7), (EObject)closure, (EStructuralFeature)XbasePackage.Literals.XCLOSURE__DECLARED_FORMAL_PARAMETERS, index, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
            }
            ++index;
        }
    }

    @Check(value=CheckType.FAST)
    public void checkVariableName(XVariableDeclaration variable) {
        QualifiedName name = QualifiedName.create((String[])variable.getQualifiedName('.').split("\\."));
        if (this.isReallyDisallowedName(name)) {
            this.error(MessageFormat.format(Messages.SARLNamingValidator_2, variable.getName(), Messages.SARLNamingValidator_8), (EObject)variable, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
        } else if (this.getGrammarAccess().getOccurrenceKeyword().equals(variable.getName())) {
            this.error(MessageFormat.format(Messages.SARLNamingValidator_4, this.getGrammarAccess().getOccurrenceKeyword(), Messages.SARLNamingValidator_8), (EObject)variable, (EStructuralFeature)XbasePackage.Literals.XVARIABLE_DECLARATION__NAME, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", new String[0]);
        }
    }
}

