/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.collect.HashMultimap;
import io.sarl.lang.core.SARLVersion;
import io.sarl.lang.core.util.OutParameter;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.util.Utils;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidatorWithParentLink;
import io.sarl.lang.validation.subvalidators.Messages;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;

public class SARLScriptValidator
extends AbstractSARLSubValidatorWithParentLink {
    @Check(value=CheckType.FAST)
    public void checkClassPath(XtendFile sarlScript) {
        TypeReferences typeReferences = this.getServices().getTypeReferences();
        if (!Utils.isCompatibleJDKVersionWithSARLCompilationEnvironment()) {
            this.error(MessageFormat.format(Messages.SARLScriptValidator_1, System.getProperty("java.specification.version"), "21", "27"), (EObject)sarlScript, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "org.eclipse.xtend.core.validation.IssueCodes.jdk_not_on_classpath", new String[0]);
        } else {
            GeneratorConfig generatorConfiguration = this.getParentValidator().getGeneratorConfig((EObject)sarlScript);
            JavaVersion generatorVersion = generatorConfiguration.getJavaSourceVersion();
            if (generatorVersion == null || !Utils.isCompatibleJDKVersionWhenInSARLProjectClasspath(generatorVersion.getQualifier())) {
                this.error(MessageFormat.format(Messages.SARLScriptValidator_2, generatorVersion, "21", "27"), (EObject)sarlScript, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "org.eclipse.xtend.core.validation.IssueCodes.jdk_not_on_classpath", new String[0]);
            }
        }
        OutParameter sarlLibraryVersion = new OutParameter();
        Utils.SarlLibraryErrorCode errorCode = Utils.getSARLLibraryVersionOnClasspath(typeReferences, (Notifier)sarlScript, (OutParameter<String>)sarlLibraryVersion);
        if (errorCode != Utils.SarlLibraryErrorCode.SARL_FOUND) {
            ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)sarlScript);
            StringBuilder classPath = new StringBuilder();
            for (Resource resource : resourceSet.getResources()) {
                classPath.append(resource.getURI().toString());
                classPath.append("\n");
            }
            StringBuilder fields = new StringBuilder();
            try {
                JvmDeclaredType type = (JvmDeclaredType)typeReferences.findDeclaredType(SARLVersion.class, (Notifier)sarlScript);
                for (JvmField field : type.getDeclaredFields()) {
                    fields.append(field.getIdentifier());
                    fields.append(" / ");
                    fields.append(field.getSimpleName());
                    fields.append("\n");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (fields.length() == 0) {
                for (Field field : SARLVersion.class.getDeclaredFields()) {
                    fields.append(field.getName());
                    fields.append("\n");
                }
            }
            this.error(MessageFormat.format(Messages.SARLScriptValidator_3, errorCode.name(), classPath.toString(), fields.toString()), (EObject)sarlScript, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "io.sarl.lang.validation.IssueCodes.sarl_lib_not_on_classpath", new String[0]);
        } else if (!Utils.isCompatibleSARLLibraryVersion((String)sarlLibraryVersion.get())) {
            this.error(MessageFormat.format(Messages.SARLScriptValidator_4, sarlLibraryVersion.get(), "0.15"), (EObject)sarlScript, (EStructuralFeature)XtendPackage.Literals.XTEND_FILE__PACKAGE, "io.sarl.lang.validation.IssueCodes.invalid_sarl_lib_on_classpath", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkTopElementsAreUnique(SarlScript script) {
        HashMultimap name2type = HashMultimap.create();
        for (XtendTypeDeclaration declaration : script.getXtendTypes()) {
            String name = declaration.getName();
            if (Strings.isEmpty((String)name)) continue;
            name2type.put((Object)name, (Object)declaration);
        }
        for (String name : name2type.keySet()) {
            Set types = name2type.get((Object)name);
            if (types.size() <= 1) continue;
            for (XtendTypeDeclaration type : types) {
                this.error(MessageFormat.format(Messages.SARLScriptValidator_5, name), (EObject)type, (EStructuralFeature)XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME, "io.sarl.lang.validation.IssueCodes.duplicate_type_name", new String[0]);
            }
        }
    }
}

