/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidator;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.util.XbaseUsageCrossReferencer;

public class SARLSynchronizationValidator
extends AbstractSARLSubValidator {
    @Check(value=CheckType.EXPENSIVE)
    public void checkUnsynchronizedField(XtendField field) {
        if (this.doCheckValidMemberName((XtendMember)field) && !this.isIgnored("io.sarl.lang.validation.IssueCodes.potential_field_synchronization_problem")) {
            JvmField jvmField = this.getAssociations().getJvmField(field);
            if (jvmField == null || jvmField.eContainer() == null || jvmField.isConstant() || jvmField.isFinal()) {
                return;
            }
            EObject scope = this.getOutermostType((XtendMember)field);
            if ((scope instanceof SarlAgent || scope instanceof SarlBehavior || scope instanceof SarlSkill) && this.isLocallyAssigned((EObject)jvmField, scope)) {
                Collection usages = XbaseUsageCrossReferencer.find((EObject)jvmField, (EObject)scope);
                HashSet<XtendMember> blocks = new HashSet<XtendMember>();
                boolean isAccessibleFromOutside = jvmField.getVisibility() != JvmVisibility.PRIVATE;
                ArrayList<EStructuralFeature.Setting> pbUsages = new ArrayList<EStructuralFeature.Setting>();
                for (EStructuralFeature.Setting usage : usages) {
                    XtendMember member = (XtendMember)EcoreUtil2.getContainerOfType((EObject)usage.getEObject(), XtendMember.class);
                    if (member instanceof XtendFunction) {
                        XtendFunction fct = (XtendFunction)member;
                        blocks.add(member);
                        if (member.getVisibility() != JvmVisibility.PRIVATE) {
                            isAccessibleFromOutside = true;
                        }
                        if (fct.isSynchonized()) continue;
                        pbUsages.add(usage);
                        continue;
                    }
                    if (!(member instanceof SarlBehaviorUnit)) continue;
                    blocks.add(member);
                    isAccessibleFromOutside = true;
                    pbUsages.add(usage);
                }
                for (EStructuralFeature.Setting usage : pbUsages) {
                    XSynchronizedExpression syncExpr;
                    boolean synchronizationIssue = false;
                    synchronizationIssue = isAccessibleFromOutside || blocks.size() > 1 ? true : true;
                    if (synchronizationIssue && (syncExpr = (XSynchronizedExpression)EcoreUtil2.getContainerOfType((EObject)usage.getEObject(), XSynchronizedExpression.class)) != null) {
                        synchronizationIssue = false;
                    }
                    if (!synchronizationIssue || this.isIgnored("io.sarl.lang.validation.IssueCodes.potential_field_synchronization_problem", usage.getEObject())) continue;
                    this.addIssue(MessageFormat.format(Messages.SARLSynchronizationValidator_1, field.getName()), usage.getEObject(), usage.getEStructuralFeature(), "io.sarl.lang.validation.IssueCodes.potential_field_synchronization_problem", new String[0]);
                }
            }
        }
    }
}

