/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.validation.subvalidators;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlArtifact;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlPackage;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.SarlSpace;
import io.sarl.lang.validation.subvalidators.AbstractSARLSubValidatorWithParentLink;
import io.sarl.lang.validation.subvalidators.Messages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.typesystem.override.OverrideHelper;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SARLTypeValidator
extends AbstractSARLSubValidatorWithParentLink {
    @Inject
    private DispatchHelper dispatchHelper;
    @Inject
    private OverrideHelper overrideHelper;

    @Check
    public void checkSpaceUse(SarlSpace space) {
        this.warning(MessageFormat.format(Messages.SARLTypeValidator_1, this.getGrammarAccess().getSpaceKeyword()), (EObject)space, null, -1, "io.sarl.lang.validation.IssueCodes.unsupported_statement", new String[0]);
    }

    @Check(value=CheckType.FAST)
    public void checkArtifactUse(SarlArtifact artifact) {
        this.error(MessageFormat.format(Messages.SARLTypeValidator_1, this.getGrammarAccess().getSpaceKeyword()), (EObject)artifact, null);
    }

    @Check(value=CheckType.FAST)
    public void checkContainerType(SarlAgent agent) {
        XtendTypeDeclaration declaringType = agent.getDeclaringType();
        if (declaringType != null) {
            String name = this.canonicalName((EObject)declaringType);
            assert (name != null);
            this.error(MessageFormat.format(Messages.SARLTypeValidator_2, name), (EObject)agent, null, "io.sarl.lang.validation.IssueCodes.invalid_nested_definition", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkContainerType(SarlBehavior behavior) {
        XtendTypeDeclaration declaringType = behavior.getDeclaringType();
        if (declaringType != null) {
            String name = this.canonicalName((EObject)declaringType);
            assert (name != null);
            this.error(MessageFormat.format(Messages.SARLTypeValidator_3, name), (EObject)behavior, null, "io.sarl.lang.validation.IssueCodes.invalid_nested_definition", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkContainerType(SarlCapacity capacity) {
        XtendTypeDeclaration declaringType = capacity.getDeclaringType();
        if (declaringType != null) {
            String name = this.canonicalName((EObject)declaringType);
            assert (name != null);
            this.error(MessageFormat.format(Messages.SARLTypeValidator_4, name), (EObject)capacity, null, "io.sarl.lang.validation.IssueCodes.invalid_nested_definition", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkContainerType(SarlSkill skill) {
        XtendTypeDeclaration declaringType = skill.getDeclaringType();
        if (declaringType != null) {
            String name = this.canonicalName((EObject)declaringType);
            assert (name != null);
            this.error(MessageFormat.format(Messages.SARLTypeValidator_5, name), (EObject)skill, null, "io.sarl.lang.validation.IssueCodes.invalid_nested_definition", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkContainerType(SarlEvent event) {
        XtendTypeDeclaration declaringType = event.getDeclaringType();
        if (declaringType != null) {
            String name = this.canonicalName((EObject)declaringType);
            assert (name != null);
            this.error(MessageFormat.format(Messages.SARLTypeValidator_6, name), (EObject)event, null, "io.sarl.lang.validation.IssueCodes.invalid_nested_definition", new String[0]);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkCapacityFeatures(SarlCapacity capacity) {
        if (capacity.getMembers().isEmpty() && !this.isIgnored("io.sarl.lang.validation.IssueCodes.discouraged_capacity_definition")) {
            this.addIssue(Messages.SARLTypeValidator_7, (EObject)capacity, null, -1, "io.sarl.lang.validation.IssueCodes.discouraged_capacity_definition", new String[]{capacity.getName(), "aFunction"});
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkDispatchFunctions(XtendClass clazz) {
        JvmGenericType type = this.getAssociations().getInferredType(clazz);
        if (type != null) {
            ListMultimap dispatchMethods = this.dispatchHelper.getDeclaredOrEnhancedDispatchMethods((JvmDeclaredType)type);
            this.checkDispatchNonDispatchConflict(clazz, (Multimap<DispatchHelper.DispatchSignature, JvmOperation>)dispatchMethods);
            for (DispatchHelper.DispatchSignature signature : dispatchMethods.keySet()) {
                LightweightTypeReference operationType;
                List dispatchOperations = dispatchMethods.get((Object)signature);
                JvmOperation syntheticDispatchMethod = this.dispatchHelper.getDispatcherOperation((JvmDeclaredType)type, signature);
                if (syntheticDispatchMethod == null) continue;
                JvmOperation overriddenOperation = this.overrideHelper.findOverriddenOperation(syntheticDispatchMethod);
                Boolean expectStatic = null;
                if (overriddenOperation != null) {
                    if (SARLTypeValidator.isMorePrivateThan(syntheticDispatchMethod.getVisibility(), overriddenOperation.getVisibility())) {
                        String msg = MessageFormat.format(Messages.SARLTypeValidator_10, overriddenOperation.getIdentifier());
                        this.addDispatchError(type, dispatchOperations, msg, null, "org.eclipse.xtext.xbase.validation.IssueCodes.override_reduces_visibility");
                    }
                    expectStatic = overriddenOperation.isStatic();
                }
                LightweightTypeReference dispatchMethodReturnType = this.getActualType((EObject)clazz, (JvmIdentifiableElement)syntheticDispatchMethod);
                if (dispatchOperations.size() == 1) {
                    if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.single_case_function")) continue;
                    JvmOperation singleOp = (JvmOperation)dispatchOperations.iterator().next();
                    XtendFunction function = this.getAssociations().getXtendFunction(singleOp);
                    this.addIssue(Messages.SARLTypeValidator_11, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)this.getGrammarAccess().getDispatchKeyword()), "org.eclipse.xtend.core.validation.IssueCodes.single_case_function", new String[0]);
                    continue;
                }
                HashMultimap signatures = HashMultimap.create();
                boolean[] allPrimitive = new boolean[signature.getArity()];
                Arrays.fill(allPrimitive, true);
                boolean isFirstLocalOperation = true;
                JvmVisibility commonVisibility = null;
                Boolean commonStatic = null;
                for (JvmOperation jvmOperation : dispatchOperations) {
                    XtendFunction function;
                    signatures.put(this.getParamTypes(jvmOperation, true), (Object)jvmOperation);
                    for (int i = 0; i < jvmOperation.getParameters().size(); ++i) {
                        JvmFormalParameter parameter = (JvmFormalParameter)jvmOperation.getParameters().get(i);
                        if (parameter.getParameterType().getType() instanceof JvmPrimitiveType) continue;
                        allPrimitive[i] = false;
                    }
                    if (jvmOperation.getDeclaringType() != type) continue;
                    if (expectStatic != null) {
                        if (expectStatic.booleanValue() && !jvmOperation.isStatic()) {
                            this.addDispatchError(jvmOperation, Messages.SARLTypeValidator_12, this.getGrammarAccess().getStaticStaticKeyword(), "dispatch_functions_static_expected");
                        }
                        if (!expectStatic.booleanValue() && jvmOperation.isStatic()) {
                            this.addDispatchError(jvmOperation, Messages.SARLTypeValidator_13, this.getGrammarAccess().getStaticStaticKeyword(), "dispatch_functions_non_static_expected");
                        }
                    }
                    if (isFirstLocalOperation) {
                        commonVisibility = jvmOperation.getVisibility();
                        commonStatic = jvmOperation.isStatic();
                        isFirstLocalOperation = false;
                    } else {
                        if (jvmOperation.getVisibility() != commonVisibility) {
                            commonVisibility = null;
                        }
                        if (commonStatic != null && commonStatic.booleanValue() != jvmOperation.isStatic()) {
                            commonStatic = null;
                        }
                    }
                    if (dispatchMethodReturnType == null || (function = this.getAssociations().getXtendFunction(jvmOperation)) == null || dispatchMethodReturnType.isAssignableFrom(operationType = this.getActualType((EObject)function.getExpression(), (JvmIdentifiableElement)jvmOperation))) continue;
                    this.error(MessageFormat.format(Messages.SARLTypeValidator_14, dispatchMethodReturnType.getHumanReadableName(), operationType.getHumanReadableName()), (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__RETURN_TYPE, -1, "org.eclipse.xtext.xbase.validation.IssueCodes.incomptible_return_type", new String[0]);
                }
                if (commonVisibility == null) {
                    this.addDispatchError(type, dispatchOperations, Messages.SARLTypeValidator_15, null, "dispatch_functions_with_different_visibility");
                }
                if (expectStatic == null && commonStatic == null) {
                    this.addDispatchError(type, dispatchOperations, Messages.SARLTypeValidator_16, this.getGrammarAccess().getStaticStaticKeyword(), "dispatch_functions_mixed_static_and_non_static");
                }
                for (List paramTypes : signatures.keySet()) {
                    Set ops = signatures.get((Object)paramTypes);
                    if (ops.size() <= 1 || !Iterables.any((Iterable)ops, input -> !this.getParamTypes((JvmOperation)input, false).equals(paramTypes))) continue;
                    operationType = ops.iterator();
                    while (operationType.hasNext()) {
                        JvmOperation jvmOperation = (JvmOperation)operationType.next();
                        XtendFunction function = this.getAssociations().getXtendFunction(jvmOperation);
                        this.error(Messages.SARLTypeValidator_18, (EObject)function, null, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_method", new String[0]);
                    }
                }
                if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.dispatch_functions_different_primitive_args")) continue;
                for (int i = 0; i < allPrimitive.length; ++i) {
                    if (!allPrimitive[i]) continue;
                    Iterator operationIter = dispatchOperations.iterator();
                    JvmType paramType1 = ((JvmFormalParameter)((JvmOperation)operationIter.next()).getParameters().get(i)).getParameterType().getType();
                    while (operationIter.hasNext()) {
                        JvmType paramType2 = ((JvmFormalParameter)((JvmOperation)operationIter.next()).getParameters().get(i)).getParameterType().getType();
                        if (paramType2.equals((Object)paramType1)) continue;
                        for (JvmOperation jvmOperation : dispatchOperations) {
                            XtendFunction function = this.getAssociations().getXtendFunction(jvmOperation);
                            this.addIssue(Messages.SARLTypeValidator_17, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_EXECUTABLE__PARAMETERS, i, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_functions_different_primitive_args", new String[0]);
                        }
                    }
                }
            }
        }
    }

    private void addDispatchError(JvmGenericType type, Iterable<JvmOperation> operations, String message, String modifier, String ISSUE_ID) {
        for (JvmOperation jvmOperation : operations) {
            if (jvmOperation.getDeclaringType() != type) continue;
            this.addDispatchError(jvmOperation, message, modifier, ISSUE_ID);
        }
    }

    private void addDispatchError(JvmOperation jvmOperation, String message, String modifier, String ISSUE_ID) {
        XtendFunction function = this.getAssociations().getXtendFunction(jvmOperation);
        if (function != null) {
            int modifierIndex = -1;
            if (modifier != null) {
                modifierIndex = function.getModifiers().indexOf((Object)modifier);
            } else {
                for (int i = 0; i < function.getModifiers().size(); ++i) {
                    if (!this.getVisibilityModifiers().contains(function.getModifiers().get(i))) continue;
                    modifierIndex = i;
                    break;
                }
            }
            if (modifierIndex == -1) {
                modifierIndex = function.getModifiers().indexOf((Object)this.getGrammarAccess().getDispatchKeyword());
            }
            this.error(message, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, modifierIndex, ISSUE_ID, new String[0]);
        }
    }

    private List<JvmType> getParamTypes(JvmOperation jvmOperation, boolean wrapPrimitives) {
        ArrayList<JvmType> types = new ArrayList<JvmType>();
        for (JvmFormalParameter p : jvmOperation.getParameters()) {
            LightweightTypeReference typeReference = this.toLightweightTypeReference(p.getParameterType());
            if (wrapPrimitives) {
                typeReference = typeReference.getWrapperTypeIfPrimitive();
            }
            types.add(typeReference.getType());
        }
        return types;
    }

    private static boolean isMorePrivateThan(JvmVisibility o1, JvmVisibility o2) {
        if (o1 == o2) {
            return false;
        }
        switch (o1) {
            case DEFAULT: {
                return o2 != JvmVisibility.PRIVATE;
            }
            case PRIVATE: {
                return true;
            }
            case PROTECTED: {
                return o2 == JvmVisibility.PUBLIC;
            }
            case PUBLIC: {
                return false;
            }
        }
        throw new IllegalArgumentException("Unknown JvmVisibility " + String.valueOf(o1));
    }

    private void checkDispatchNonDispatchConflict(XtendClass clazz, Multimap<DispatchHelper.DispatchSignature, JvmOperation> dispatchMethods) {
        if (this.isIgnored("org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash")) {
            return;
        }
        HashMultimap nonDispatchMethods = HashMultimap.create();
        for (XtendFunction method : Iterables.filter((Iterable)clazz.getMembers(), XtendFunction.class)) {
            if (method.isDispatch()) continue;
            nonDispatchMethods.put((Object)new DispatchHelper.DispatchSignature(method.getName(), method.getParameters().size()), (Object)method);
        }
        for (DispatchHelper.DispatchSignature dispatchSignature : dispatchMethods.keySet()) {
            if (!nonDispatchMethods.containsKey((Object)dispatchSignature)) continue;
            for (XtendFunction function : nonDispatchMethods.get((Object)dispatchSignature)) {
                this.addIssue(Messages.SARLTypeValidator_8, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash", new String[0]);
            }
            for (JvmOperation operation : dispatchMethods.get((Object)dispatchSignature)) {
                XtendFunction function = this.getAssociations().getXtendFunction(operation);
                if (function.eResource() != clazz.eResource()) continue;
                this.addIssue(Messages.SARLTypeValidator_9, (EObject)function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.dispatch_plain_function_name_clash", new String[0]);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkTypeParameterForwardReferences(XtendClass xtendClass) {
        this.getParentValidator().doCheckTypeParameterForwardReference((List<JvmTypeParameter>)xtendClass.getTypeParameters());
    }

    @Check(value=CheckType.NORMAL)
    public void checkTypeParameterForwardReferences(XtendInterface xtendInterface) {
        this.getParentValidator().doCheckTypeParameterForwardReference((List<JvmTypeParameter>)xtendInterface.getTypeParameters());
    }

    @Check(value=CheckType.FAST)
    public void checkJavaKeywordConflict(XtendTypeDeclaration member) {
        this.checkNoJavaKeyword((EObject)member, XtendPackage.Literals.XTEND_TYPE_DECLARATION__NAME);
    }

    @Check(value=CheckType.FAST)
    public void checkJavaKeywordConflict(XtendClass member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkJavaKeywordConflict(XtendInterface member) {
        for (JvmTypeParameter p : member.getTypeParameters()) {
            this.checkNoJavaKeyword((EObject)p, TypesPackage.Literals.JVM_TYPE_PARAMETER__NAME);
        }
    }

    @Check(value=CheckType.FAST)
    public void checkEventTypeParameters(SarlEvent event) {
        EList<JvmTypeParameter> parameters;
        if (!this.isIgnored("io.sarl.lang.validation.IssueCodes.unused_type_parameter") && !(parameters = event.getTypeParameters()).isEmpty()) {
            int i = 0;
            for (JvmTypeParameter parameter : parameters) {
                if (!this.getParentValidator().isTypeParameterLocallyUsedInEvent(parameter, event)) {
                    this.addIssue(MessageFormat.format(Messages.SARLTypeValidator_19, parameter.getSimpleName()), (EObject)event, (EStructuralFeature)SarlPackage.Literals.SARL_EVENT__TYPE_PARAMETERS, i, "io.sarl.lang.validation.IssueCodes.unused_type_parameter", new String[0]);
                }
                ++i;
            }
        }
    }
}

