/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import com.google.common.reflect.TypeToken;
import io.sarl.lang.core.AgentProtectedAPIObject;
import io.sarl.lang.core.AtomicSkillReference;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.DefaultSkill;
import io.sarl.lang.core.DynamicSkillProvider;
import io.sarl.lang.core.Identifiable;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.UnimplementedCapacityException;
import java.lang.reflect.Constructor;
import java.security.InvalidParameterException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class AbstractSkillContainer
extends AgentProtectedAPIObject
implements Identifiable {
    private final ConcurrentMap<Class<? extends Capacity>, AtomicSkillReference> skillRepository = new ConcurrentHashMap<Class<? extends Capacity>, AtomicSkillReference>();
    private DynamicSkillProvider skillProvider;

    public AbstractSkillContainer(DynamicSkillProvider skillProvider) {
        this.skillProvider = skillProvider == null ? DynamicSkillProvider.EMPTY_PROVIDER : skillProvider;
    }

    void $setDynamicSkillProvider(DynamicSkillProvider provider) {
        this.skillProvider = provider == null ? DynamicSkillProvider.EMPTY_PROVIDER : provider;
    }

    final ConcurrentMap<Class<? extends Capacity>, AtomicSkillReference> $getSkillRepository() {
        return this.skillRepository;
    }

    @Override
    @SafeVarargs
    protected final <S extends Skill> S setSkill(S skill, Class<? extends Capacity> ... capacities) {
        this.$setSkill(skill, false, capacities);
        return skill;
    }

    @Override
    @SafeVarargs
    protected final void setSkillIfAbsent(Skill skill, Class<? extends Capacity> ... capacities) {
        this.$setSkill(skill, true, capacities);
    }

    @SafeVarargs
    protected final AtomicSkillReference $setSkill(Skill skill, boolean ifabsent, Class<? extends Capacity> ... capacities) {
        assert (skill != null) : "the skill parameter must not be null";
        this.$attachOwner(skill);
        AtomicSkillReference newRef = null;
        if (capacities == null || capacities.length == 0) {
            for (TypeToken element : TypeToken.of(skill.getClass()).getTypes().interfaces()) {
                Class type = element.getRawType();
                if (!Capacity.class.isAssignableFrom(type) || Capacity.class.equals((Object)type)) continue;
                Class<Capacity> capacityType = type.asSubclass(Capacity.class);
                newRef = this.registerSkill(skill, ifabsent, capacityType, newRef);
            }
        } else {
            for (Class<? extends Capacity> capacity : capacities) {
                assert (capacity != null) : "the capacity parameter must not be null";
                assert (capacity.isInterface()) : "the capacity parameter must be an interface";
                if (!capacity.isInstance(skill)) {
                    throw new InvalidParameterException("the skill must implement the given capacity " + capacity.getName());
                }
                newRef = this.registerSkill(skill, ifabsent, capacity, newRef);
            }
        }
        return newRef;
    }

    protected abstract void $attachOwner(Skill var1);

    private AtomicSkillReference registerSkill(Skill skill, boolean ifabsent, Class<? extends Capacity> capacity, AtomicSkillReference firstRef) {
        AtomicSkillReference newReference;
        if (ifabsent) {
            newReference = this.$getSkillRepository().computeIfAbsent(capacity, it -> new AtomicSkillReference(skill));
        } else {
            newReference = new AtomicSkillReference(skill);
            AtomicSkillReference oldReference = this.$getSkillRepository().put(capacity, newReference);
            if (oldReference != null) {
                oldReference.clear();
            }
        }
        if (firstRef == null) {
            return newReference;
        }
        return firstRef;
    }

    @Override
    @Pure
    protected final <S extends Capacity> S getSkill(Class<S> capacity) {
        assert (capacity != null);
        AtomicSkillReference skill = this.$getSkill(capacity);
        assert (skill != null);
        return this.$castSkill(capacity, skill);
    }

    @Pure
    protected <S extends Capacity> S $castSkill(Class<S> capacity, AtomicSkillReference skillReference) {
        Capacity skill = (Capacity)capacity.cast(skillReference.get());
        if (skill == null) {
            throw new UnimplementedCapacityException(capacity, this.getID());
        }
        return (S)skill;
    }

    @Override
    @Pure
    protected AtomicSkillReference $getSkill(Class<? extends Capacity> capacity) {
        return this.$getSkillRepository().compute(capacity, (capacityType, oldSkillReferenceValue) -> this.createSkillDynamically((Class<? extends Capacity>)capacityType, (AtomicSkillReference)oldSkillReferenceValue));
    }

    private AtomicSkillReference createSkillDynamically(Class<? extends Capacity> capacity, AtomicSkillReference existingSkill) {
        Skill s;
        if (existingSkill != null && (s = existingSkill.get()) != null) {
            return existingSkill;
        }
        Skill skill = this.skillProvider.createSkill(capacity);
        if (skill != null) {
            this.$attachOwner(skill);
            return new AtomicSkillReference(skill);
        }
        DefaultSkill annotation = capacity.getAnnotation(DefaultSkill.class);
        if (annotation != null) {
            try {
                Class<? extends Skill> type = annotation.value();
                Constructor<? extends Skill> cons = type.getConstructor(new Class[0]);
                cons.setAccessible(true);
                Skill skillInstance = cons.newInstance(new Object[0]);
                this.$attachOwner(skillInstance);
                return new AtomicSkillReference(skillInstance);
            }
            catch (Throwable exception) {
                throw new UnimplementedCapacityException(capacity, this.getID(), exception);
            }
        }
        throw new UnimplementedCapacityException(capacity, this.getID());
    }

    @Override
    @Pure
    protected boolean hasSkill(Class<? extends Capacity> capacity) {
        assert (capacity != null);
        if (!this.$getSkillRepository().containsKey(capacity)) {
            if (this.skillProvider != null && this.skillProvider.isSkillProviding(capacity)) {
                return true;
            }
            DefaultSkill annotation = capacity.getAnnotation(DefaultSkill.class);
            return annotation != null && annotation.value() != null;
        }
        return true;
    }

    @Override
    protected <S extends Capacity> S clearSkill(Class<S> capacity) {
        Skill skill;
        assert (capacity != null);
        AtomicSkillReference reference = (AtomicSkillReference)this.$getSkillRepository().remove(capacity);
        if (reference != null && (skill = reference.clear()) != null) {
            return (S)((Capacity)capacity.cast(skill));
        }
        return null;
    }

    @Override
    @Inline(value="setSkill($2, $1)")
    protected <S extends Skill> void operator_mappedTo(Class<? extends Capacity> capacity, S skill) {
        this.setSkill(skill, capacity);
    }
}

