/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.SRESpecificDataContainer;
import io.sarl.lang.core.SpaceID;
import java.io.Serializable;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class Address
extends SRESpecificDataContainer
implements Serializable,
Comparable<Address>,
Cloneable {
    private static final long serialVersionUID = 1519844913685586094L;
    private final UUID participantId;
    private final SpaceID spaceId;

    public Address(SpaceID spaceId, UUID participantId) {
        assert (participantId != null);
        assert (spaceId != null);
        this.participantId = participantId;
        this.spaceId = spaceId;
    }

    @Pure
    public Address clone() {
        try {
            return (Address)super.clone();
        }
        catch (Throwable exception) {
            throw new Error(exception);
        }
    }

    @Pure
    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.add("type", (Object)this.getClass().getSimpleName());
        builder.add("participantId", (Object)this.participantId);
        builder.add("spaceId", (Object)this.spaceId);
        return builder.toString();
    }

    @Deprecated(forRemoval=true, since="0.12")
    @Pure
    @Inline(value="getID()")
    public UUID getUUID() {
        return this.getID();
    }

    @Pure
    public UUID getID() {
        return this.participantId;
    }

    @Pure
    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.participantId == null ? 0 : this.participantId.hashCode());
        result = 31 * result + (this.spaceId == null ? 0 : this.spaceId.hashCode());
        return result;
    }

    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Address) {
            Address cvalue = (Address)obj;
            return this.equals(cvalue);
        }
        return false;
    }

    @Pure
    public boolean equals(Address address) {
        return address != null && this.participantId.equals(address.getID()) && this.spaceId.equals(address.getSpaceID());
    }

    @Override
    @Pure
    public int compareTo(Address address) {
        if (address == null) {
            return 1;
        }
        return this.participantId.compareTo(address.getID());
    }

    @Pure
    public SpaceID getSpaceID() {
        return this.spaceId;
    }

    @Pure
    @Deprecated(forRemoval=true, since="0.7")
    public SpaceID getSpaceId() {
        return this.getSpaceID();
    }

    @Pure
    @Inline(value="(($1) != null && ($1).equals($0getID()))", constantExpression=true)
    public boolean operator_equals(UUID id) {
        return id != null && id.equals(this.getID());
    }

    @Pure
    @Inline(value="(($1) != null && ($1).equals($0getSpaceID()))", constantExpression=true)
    public boolean operator_equals(SpaceID id) {
        return id != null && id.equals(this.getSpaceID());
    }

    @Pure
    @Inline(value="(($1) == null || !($1).equals($0getID()))", constantExpression=true)
    public boolean operator_notEquals(UUID id) {
        return id == null || !id.equals(this.getID());
    }

    @Pure
    @Inline(value="(($1) == null || !($1).equals($0getSpaceID()))", constantExpression=true)
    public boolean operator_notEquals(SpaceID id) {
        return id == null || !id.equals(this.getSpaceID());
    }
}

