/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.AbstractSkillContainer;
import io.sarl.lang.core.Address;
import io.sarl.lang.core.DynamicSkillProvider;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.IBehaviorGuardEvaluatorReceiver;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.SarlSpecification;
import jakarta.inject.Inject;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@SarlSpecification(value="0.15")
public class Agent
extends AbstractSkillContainer
implements IBehaviorGuardEvaluatorReceiver {
    private final UUID id;
    private final UUID parentID;
    private volatile Procedures.Procedure2<Agent, Skill> skillCallback;

    public Agent(UUID parentID, UUID agentID) {
        this(parentID, agentID, null);
    }

    @Inject
    public Agent(UUID parentID, UUID agentID, DynamicSkillProvider skillProvider) {
        super(skillProvider);
        this.parentID = parentID;
        this.id = agentID == null ? UUID.randomUUID() : agentID;
    }

    @Override
    @Pure
    protected void toString(ToStringBuilder builder) {
        builder.add("type", (Object)this.getClass().getSimpleName());
        builder.add("id", (Object)this.id);
        builder.add("parentID", (Object)this.parentID);
    }

    @Override
    protected final void $attachOwner(Skill skill) {
        skill.setOwner(this);
        Procedures.Procedure2<Agent, Skill> cb = this.skillCallback;
        if (cb != null) {
            cb.apply((Object)this, (Object)skill);
        }
    }

    void setSkillCallback(Procedures.Procedure2<Agent, Skill> callback) {
        this.skillCallback = callback;
    }

    @Pure
    public UUID getParentID() {
        return this.parentID;
    }

    @Override
    @Pure
    public UUID getID() {
        return this.id;
    }

    @Override
    @Pure
    @Inline(value="($1 != null && $0getID().equals($1.getID()))", constantExpression=true)
    protected boolean isMe(Address address) {
        return address != null && this.isMe(address.getID());
    }

    @Override
    @Pure
    @Inline(value="getID().equals($1)")
    protected boolean isMe(UUID uID) {
        return uID != null && this.getID().equals(uID);
    }

    @Override
    @Pure
    @Inline(value="($1 != null && $0getID().equals($1.getSource().getID()))", constantExpression=true)
    protected boolean isFromMe(Event event) {
        return event != null && this.isMe(event.getSource());
    }
}

