/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.PrivateAPI;
import java.io.Serializable;

public class AtomicSkillReference
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -2985132547428365532L;
    private volatile Skill reference;

    @PrivateAPI
    public AtomicSkillReference(Skill object) {
        assert (object != null);
        this.reference = object;
        object.increaseReference();
    }

    public AtomicSkillReference clone() {
        try {
            return (AtomicSkillReference)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new Error(exception);
        }
    }

    public Skill get() {
        return this.reference;
    }

    public Skill clear() {
        Skill ref = this.reference;
        this.reference = null;
        if (ref != null) {
            ref.decreaseReference();
        }
        return ref;
    }

    public String toString() {
        Skill ref = this.reference;
        if (ref != null) {
            return ref.toString();
        }
        return "null";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(AtomicSkillReference.class)) {
            return false;
        }
        Skill ref = this.reference;
        AtomicSkillReference aref = (AtomicSkillReference)obj;
        Skill oref = aref.reference;
        if (ref == null) {
            return oref == null;
        }
        if (oref == null) {
            return false;
        }
        return ref.equals(oref);
    }

    public int hashCode() {
        Skill ref = this.reference;
        if (ref == null) {
            return 0;
        }
        return ref.hashCode();
    }
}

