/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.DynamicSkillProvider;
import io.sarl.lang.core.Skill;
import org.eclipse.xtext.xbase.lib.Pure;

public final class DelegateDynamicSkillProvider
implements DynamicSkillProvider {
    private final DynamicSkillProvider[] delegates;

    public DelegateDynamicSkillProvider(DynamicSkillProvider[] delegates) {
        assert (delegates != null);
        this.delegates = delegates;
    }

    @Override
    @Pure
    public Skill createSkill(Class<? extends Capacity> capacity) {
        for (DynamicSkillProvider provider : this.delegates) {
            Skill skill = provider.createSkill(capacity);
            if (skill == null) continue;
            return skill;
        }
        return null;
    }

    @Override
    @Pure
    public boolean isSkillProviding(Class<? extends Capacity> capacity) {
        for (DynamicSkillProvider provider : this.delegates) {
            if (!provider.isSkillProviding(capacity)) continue;
            return true;
        }
        return false;
    }
}

