/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentContext;
import io.sarl.lang.core.SREBootstrap;
import io.sarl.lang.core.SREClassLoader;
import io.sarl.lang.core.SREListener;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.UUID;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class SRE {
    private static final String PREFIX = "META-INF/services/";
    private static SREBootstrap currentSRE;
    private static SoftReference<ServiceLoader<SREBootstrap>> loader;

    private SRE() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetServiceLoader() {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            loader = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Pure
    @Inline(value="getServiceLoader(false)")
    public static ServiceLoader<SREBootstrap> getServiceLoader() {
        return SRE.getServiceLoader(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static ServiceLoader<SREBootstrap> getServiceLoader(boolean onlyInstalledInJRE) {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            ServiceLoader<SREBootstrap> sl;
            ServiceLoader<SREBootstrap> serviceLoader = sl = loader == null ? null : loader.get();
            if (sl == null) {
                sl = onlyInstalledInJRE ? ServiceLoader.loadInstalled(SREBootstrap.class) : ServiceLoader.load(SREBootstrap.class);
                loader = new SoftReference<ServiceLoader<SREBootstrap>>(sl);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sl;
        }
    }

    @Pure
    @Inline(value="getServiceLibraries($1.class.getName())", imported={SREBootstrap.class})
    public static Iterable<URL> getBootstrappedLibraries() {
        return SRE.getServiceLibraries(SREBootstrap.class.getName());
    }

    @Pure
    public static Iterable<URL> getServiceLibraries(String libraryName) {
        String name = PREFIX + libraryName;
        return () -> {
            try {
                final Enumeration<URL> enumr = ClassLoader.getSystemResources(name);
                return new Iterator<URL>(){
                    final Enumeration<URL> enumeration;
                    {
                        this.enumeration = enumr;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.enumeration.hasMoreElements();
                    }

                    @Override
                    public URL next() {
                        return this.enumeration.nextElement();
                    }
                };
            }
            catch (Throwable exception) {
                return new Iterator<URL>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public URL next() {
                        throw new NoSuchElementException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setBootstrap(SREBootstrap sre) {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            currentSRE = sre;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void main(String[] args) throws Exception {
        Object[] params = new Object[args.length - 1];
        if (args.length > 1) {
            System.arraycopy(args, 1, params, 0, params.length);
        }
        Class<?> type = SREClassLoader.loadClass(args[0], SRE.class.getClassLoader());
        SRE.getBootstrap().startAgent(type, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static SREBootstrap getBootstrap() {
        Class<SRE> clazz = SRE.class;
        synchronized (SRE.class) {
            if (currentSRE == null) {
                Iterator<SREBootstrap> iterator = SRE.getServiceLoader().iterator();
                currentSRE = iterator.hasNext() ? iterator.next() : new VoidSREBootstrap();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return currentSRE;
        }
    }

    private static class VoidSREBootstrap
    implements SREBootstrap {
        VoidSREBootstrap() {
        }

        @Override
        public AgentContext startWithoutAgent(boolean asCommandLineApp) {
            return null;
        }

        @Override
        public void startAgent(Class<? extends Agent> agentCls, Object ... params) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startAgent(int nbAgents, Class<? extends Agent> agentCls, Object ... params) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void startAgentWithID(Class<? extends Agent> agentCls, UUID agentID, Object ... params) throws Exception {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public boolean isRunning() {
            return false;
        }

        @Override
        public <T> T getService(Class<T> serviceType) {
            return null;
        }

        @Override
        public void shutdown(int timeout) throws InterruptedException {
        }

        @Override
        public void addSREListener(SREListener listener) {
        }

        @Override
        public void removeSREListener(SREListener listener) {
        }

        @Override
        public void setCommandLineArguments(String[] arguments) {
        }

        @Override
        public void injectMembers(Object object) {
            throw new UnsupportedOperationException();
        }
    }
}

