/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class SREClassLoader {
    private SREClassLoader() {
    }

    @Pure
    @Inline(value="$3.loadClass($1, true, $2)", imported={SREClassLoader.class})
    public static Class<?> loadClass(String classname, ClassLoader context) throws ClassNotFoundException {
        return SREClassLoader.loadClass(classname, true, context);
    }

    private static Class<?> loadClass(String classname) {
        try {
            return Class.forName(classname, true, ClassLoader.getSystemClassLoader());
        }
        catch (Exception exception) {
            try {
                return Class.forName(classname, true, SREClassLoader.getPreferredSREClassloader());
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    @Pure
    public static Class<?> loadClass(String classname, boolean initialize, ClassLoader context) throws ClassNotFoundException {
        ClassNotFoundException ex = null;
        try {
            if (context != null) {
                return context.loadClass(classname);
            }
        }
        catch (ClassNotFoundException exception) {
            ex = exception;
        }
        Class<?> type = SREClassLoader.loadClass(classname);
        if (type == null) {
            if (ex != null) {
                throw ex;
            }
            throw new ClassNotFoundException(classname);
        }
        return type;
    }

    public static ClassLoader getPreferredSREClassloader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static <T extends ClassLoader> T getPreferredSREClassloader(Class<T> type) {
        ClassLoader cl = SREClassLoader.getPreferredSREClassloader();
        if (type.isInstance(cl)) {
            return (T)((ClassLoader)type.cast(cl));
        }
        return null;
    }

    public static void setPreferredSREClassloader(ClassLoader classLoader) {
        assert (classLoader != null);
        Thread.currentThread().setContextClassLoader(classLoader);
    }
}

