/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.AbstractSkillContainer;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AtomicSkillReference;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.DynamicSkillProvider;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.IBehaviorGuardEvaluatorReceiver;
import io.sarl.lang.core.SRESpecificDataContainer;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.PrivateAPI;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

@PrivateAPI
public final class SREutils {
    private SREutils() {
    }

    @Pure
    public static <S> S getSreSpecificData(SRESpecificDataContainer container, Class<S> type) {
        assert (container != null);
        return container.$getSreSpecificData(type);
    }

    public static void setSreSpecificData(SRESpecificDataContainer container, Object data) {
        assert (container != null);
        container.$setSreSpecificData(data);
    }

    public static <S> S setSreSpecificData(SRESpecificDataContainer container, S data, Class<S> type) {
        assert (container != null);
        S oldData = container.$getSreSpecificData(type);
        container.$setSreSpecificData(data);
        return oldData;
    }

    @Pure
    public static AtomicSkillReference getInternalSkillReference(AbstractSkillContainer container, Class<? extends Capacity> type) {
        return container.$getSkill(type);
    }

    @Pure
    public static <S extends Capacity> S castInternalSkillReference(AbstractSkillContainer container, AtomicSkillReference reference, Class<S> type) {
        return container.$castSkill(type, reference);
    }

    public static AtomicSkillReference setInternalSkill(AbstractSkillContainer container, Skill skill, Class<? extends Capacity>[] capacities) {
        assert (capacities != null);
        return container.$setSkill(skill, false, capacities);
    }

    public static AtomicSkillReference setInternalSkillIfAbsent(AbstractSkillContainer container, Skill skill, Class<? extends Capacity>[] capacities) {
        assert (capacities != null);
        return container.$setSkill(skill, true, capacities);
    }

    @Pure
    public static <S extends Capacity> S getInternalSkill(AbstractSkillContainer container, Class<S> type) {
        return container.getSkill(type);
    }

    public static ConcurrentMap<Class<? extends Capacity>, AtomicSkillReference> getSkillRepository(AbstractSkillContainer container) {
        return container.$getSkillRepository();
    }

    public static void setDynamicSkillProvider(AbstractSkillContainer container, DynamicSkillProvider provider) {
        container.$setDynamicSkillProvider(provider);
    }

    public static void doSkillInstallation(Skill skill) {
        skill.install();
    }

    public static void doSkillUninstallationPreparation(Skill skill) {
        skill.prepareUninstallation();
    }

    public static void doSkillUninstallation(Skill skill) {
        skill.uninstall();
    }

    public static void doEvaluateBehaviorGuards(IBehaviorGuardEvaluatorReceiver receiver, Class<?> eventType, Object event, Collection<Runnable> behaviorsMethodsToExecute) {
        receiver.$evaluateBehaviorGuards(eventType, event, behaviorsMethodsToExecute);
    }

    @Deprecated(since="0.14", forRemoval=true)
    public static void doEvaluateBehaviorGuards(IBehaviorGuardEvaluatorReceiver receiver, Object event, Collection<Runnable> behaviorsMethodsToExecute) {
        SREutils.doEvaluateBehaviorGuards(receiver, event.getClass().asSubclass(Event.class), event, behaviorsMethodsToExecute);
    }

    public static void doGetSupportedEvents(IBehaviorGuardEvaluatorReceiver receiver, Set<Class<? extends Event>> events) {
        receiver.$getSupportedEvents(events);
    }

    public static boolean doIsSupportedEvent(IBehaviorGuardEvaluatorReceiver receiver, Class<? extends Event> event) {
        return receiver.$isSupportedEvent(event);
    }

    public static void doBehaviorInstallation(Behavior behavior) {
        behavior.install();
    }

    public static void doBehaviorUninstallation(Behavior behavior) {
        behavior.uninstall();
    }

    public static void setSkillInstallationCallback(Agent agent, Procedures.Procedure2<Agent, Skill> callback) {
        agent.setSkillCallback(callback);
    }
}

