/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core;

import io.sarl.lang.core.Agent;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacities;
import io.sarl.lang.core.IBehaviorGuardEvaluatorReceiver;
import io.sarl.lang.core.annotation.PrivateAPI;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public abstract class Skill
extends AgentTrait
implements IBehaviorGuardEvaluatorReceiver {
    private final AtomicInteger referencesFromCapacityMap = new AtomicInteger();

    public Skill(Agent agent) {
        super(agent);
    }

    public Skill() {
    }

    @Override
    void setOwner(Agent agent) {
        super.setOwner(agent);
        this.referencesFromCapacityMap.set(0);
    }

    @Pure
    @Inline(value="$1.getCaller()", imported={Capacities.class}, constantExpression=true)
    protected AgentTrait getCaller() {
        return Capacities.getCaller();
    }

    protected void install() {
    }

    protected void prepareUninstallation() {
    }

    protected void uninstall() {
    }

    void increaseReference() {
        int oldValue = this.referencesFromCapacityMap.getAndIncrement();
        if (oldValue <= 0) {
            this.install();
        }
    }

    void decreaseReference() {
        int newValue = this.referencesFromCapacityMap.decrementAndGet();
        if (newValue <= 0) {
            this.prepareUninstallation();
            this.uninstall();
        }
    }

    @PrivateAPI
    public int getReferenceCount() {
        return this.referencesFromCapacityMap.get();
    }
}

