/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.annotations;

import io.sarl.lang.core.Agent;
import jakarta.inject.Singleton;
import java.util.Objects;
import org.eclipse.xtend.lib.annotations.AccessorsProcessor;
import org.eclipse.xtend.lib.macro.TransformationContext;
import org.eclipse.xtend.lib.macro.declaration.Element;
import org.eclipse.xtend.lib.macro.declaration.FieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableElement;
import org.eclipse.xtend.lib.macro.declaration.MutableFieldDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableParameterDeclaration;
import org.eclipse.xtend.lib.macro.declaration.MutableTypeDeclaration;
import org.eclipse.xtend.lib.macro.declaration.ResolvedMethod;
import org.eclipse.xtend.lib.macro.declaration.ResolvedParameter;
import org.eclipse.xtend.lib.macro.declaration.Type;
import org.eclipse.xtend.lib.macro.declaration.TypeReference;
import org.eclipse.xtend.lib.macro.declaration.Visibility;
import org.eclipse.xtend2.lib.StringConcatenationClient;

@Singleton
public class SarlAccessorsProcessor
extends AccessorsProcessor {
    protected void _transform(MutableFieldDeclaration it, TransformationContext context) {
        Visibility visibility;
        Util util = new Util(this, context);
        if (util.shouldAddGetter((FieldDeclaration)it)) {
            visibility = util.toVisibility(util.getGetterType((FieldDeclaration)it));
            visibility = this.applyMinMaxVisibility(visibility, it, context);
            util.addGetter(it, visibility);
        }
        if (util.shouldAddSetter((FieldDeclaration)it)) {
            visibility = util.toVisibility(util.getSetterType((FieldDeclaration)it));
            visibility = this.applyMinMaxVisibility(visibility, it, context);
            util.addSetter(it, visibility);
        }
    }

    protected Visibility applyMinMaxVisibility(Visibility visibility, MutableFieldDeclaration it, TransformationContext context) {
        if (context.findTypeGlobally(Agent.class).isAssignableFrom((Type)it.getDeclaringType()) && visibility.compareTo((Enum)Visibility.PROTECTED) > 0) {
            return Visibility.PROTECTED;
        }
        return visibility;
    }

    public class Util
    extends AccessorsProcessor.Util {
        private final TransformationContext context;

        public Util(SarlAccessorsProcessor this$0, TransformationContext context) {
            super(context);
            this.context = context;
        }

        public void addSetter(final MutableFieldDeclaration field, Visibility visibility) {
            this.validateSetter(field);
            String name = this.getSetterName((FieldDeclaration)field);
            MutableTypeDeclaration type = field.getDeclaringType();
            boolean isVarArgs = this.isInheritedVarargMethod(type, name, this.orObject(field.getType()));
            type.addMethod(name, it -> {
                this.context.setPrimarySourceElement((MutableElement)it, this.context.getPrimarySourceElement((Element)field));
                it.setReturnType(this.context.getPrimitiveVoid());
                final MutableParameterDeclaration param = it.addParameter(field.getSimpleName(), this.orObject(field.getType()));
                it.setBody(new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                        builder.append(Util.this.fieldOwner(field));
                        builder.append((Object)".");
                        builder.append((Object)field.getSimpleName());
                        builder.append((Object)" = ");
                        builder.append((Object)param.getSimpleName());
                        builder.append((Object)";");
                    }
                });
                it.setStatic(field.isStatic());
                it.setVisibility(visibility);
                it.setVarArgs(isVarArgs);
            });
        }

        protected boolean isInheritedVarargMethod(MutableTypeDeclaration type, String name, TypeReference paramType) {
            if (paramType.isArray()) {
                TypeReference ref = this.context.newTypeReference((Type)type, new TypeReference[0]);
                for (TypeReference superType : ref.getDeclaredSuperTypes()) {
                    for (ResolvedMethod method : superType.getAllResolvedMethods()) {
                        if (!Objects.equals(name, method.getDeclaration().getSimpleName()) || !this.isSingleVarargParameter(method, paramType)) continue;
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isSingleVarargParameter(ResolvedMethod method, TypeReference paramType) {
            boolean first = true;
            for (ResolvedParameter parameter : method.getResolvedParameters()) {
                if (paramType.equals((Object)parameter.getResolvedType())) {
                    return first && method.getDeclaration().isVarArgs();
                }
                first = false;
            }
            return false;
        }

        protected Object fieldOwner(MutableFieldDeclaration it) {
            if (it.isStatic()) {
                return this.context.newTypeReference((Type)it.getDeclaringType(), new TypeReference[0]);
            }
            return "this";
        }

        protected TypeReference orObject(TypeReference ref) {
            if (ref == null) {
                return this.context.getObject();
            }
            return ref;
        }
    }
}

