/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.scoping.extensions.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveCastExtensions {
    private PrimitiveCastExtensions() {
    }

    @Pure
    @Inline(value="$2.parseBoolean(($1).toString())", imported={Boolean.class})
    public static boolean booleanValue(CharSequence value) {
        return value != null && Boolean.parseBoolean(value.toString());
    }

    @Pure
    public static boolean booleanValue(Object value) {
        if (value instanceof Boolean) {
            Boolean bvalue = (Boolean)value;
            return bvalue;
        }
        if (value != null) {
            return PrimitiveCastExtensions.booleanValue(value.toString());
        }
        return false;
    }

    @Pure
    @Inline(value="($1).get()", imported={Boolean.class})
    public static boolean booleanValue(AtomicBoolean value) {
        return value != null && value.get();
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Boolean.class})
    public static String toString(boolean value) {
        return Boolean.toString(value);
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Character.class})
    public static String toString(char value) {
        return Character.toString(value);
    }

    @Pure
    public static byte byteValue(CharSequence value) {
        try {
            return Byte.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static byte byteValue(Object value) {
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            return cvalue.byteValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.byteValue(value.toString());
        }
        return 0;
    }

    @Pure
    public static Byte toByte(Object value) {
        byte bvalue;
        if (value instanceof Byte) {
            Byte cvalue = (Byte)value;
            return cvalue;
        }
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            bvalue = cvalue.byteValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toByte(value.toString());
            }
            bvalue = 0;
        }
        return bvalue;
    }

    @Pure
    public static byte toByte(CharSequence value) {
        try {
            return Byte.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static short shortValue(CharSequence value) {
        try {
            return Short.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static short shortValue(Object value) {
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            return cvalue.shortValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.shortValue(value.toString());
        }
        return 0;
    }

    @Pure
    public static Short toShort(Object value) {
        short svalue;
        if (value instanceof Short) {
            Short cvalue = (Short)value;
            return cvalue;
        }
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            svalue = cvalue.shortValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toShort(value.toString());
            }
            svalue = 0;
        }
        return svalue;
    }

    @Pure
    public static Short toShort(CharSequence value) {
        try {
            return Short.decode(value.toString());
        }
        catch (Throwable throwable) {
            return (short)0;
        }
    }

    @Pure
    public static int intValue(CharSequence value) {
        try {
            return Integer.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static int intValue(Object value) {
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            return cvalue.intValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.intValue(value.toString());
        }
        return 0;
    }

    @Pure
    public static Integer toInteger(Object value) {
        int ivalue;
        if (value instanceof Integer) {
            Integer cvalue = (Integer)value;
            return cvalue;
        }
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            ivalue = cvalue.intValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toInteger(value.toString());
            }
            ivalue = 0;
        }
        return ivalue;
    }

    @Pure
    public static Integer toInteger(CharSequence value) {
        try {
            return Integer.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    @Pure
    public static char charValue(CharSequence value) {
        try {
            return value.charAt(0);
        }
        catch (Throwable throwable) {
            return '\u0000';
        }
    }

    @Pure
    public static char charValue(Object value) {
        if (value instanceof Character) {
            Character cvalue = (Character)value;
            return cvalue.charValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.charValue(value.toString());
        }
        return '\u0000';
    }

    @Pure
    public static Character toCharacter(Object value) {
        char cvalue;
        if (value instanceof Character) {
            Character cvalue2 = (Character)value;
            return cvalue2;
        }
        if (value instanceof Number) {
            Number nvalue = (Number)value;
            cvalue = (char)nvalue.intValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toCharacter(value.toString());
            }
            cvalue = '\u0000';
        }
        return Character.valueOf(cvalue);
    }

    @Pure
    public static Character toCharacter(CharSequence value) {
        try {
            return Character.valueOf(value.charAt(0));
        }
        catch (Throwable throwable) {
            return Character.valueOf('\u0000');
        }
    }

    @Pure
    public static long longValue(CharSequence value) {
        try {
            return Long.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    @Pure
    public static long longValue(Object value) {
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            return cvalue.longValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.longValue(value.toString());
        }
        return 0L;
    }

    @Pure
    public static Long toLong(Object value) {
        long lvalue;
        if (value instanceof Long) {
            Long cvalue = (Long)value;
            return cvalue;
        }
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            lvalue = cvalue.longValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toLong(value.toString());
            }
            lvalue = 0L;
        }
        return lvalue;
    }

    @Pure
    public static Long toLong(CharSequence value) {
        try {
            return Long.decode(value.toString());
        }
        catch (Throwable throwable) {
            return 0L;
        }
    }

    @Pure
    public static float floatValue(CharSequence value) {
        try {
            return Float.parseFloat(value.toString());
        }
        catch (Throwable throwable) {
            return 0.0f;
        }
    }

    @Pure
    public static float floatValue(Object value) {
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            return cvalue.floatValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.floatValue(value.toString());
        }
        return 0.0f;
    }

    @Pure
    public static Float toFloat(Object value) {
        float fvalue;
        if (value instanceof Float) {
            Float cvalue = (Float)value;
            return cvalue;
        }
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            fvalue = cvalue.floatValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toFloat(value.toString());
            }
            fvalue = 0.0f;
        }
        return Float.valueOf(fvalue);
    }

    @Pure
    public static Float toFloat(CharSequence value) {
        try {
            return Float.valueOf(value.toString());
        }
        catch (Throwable throwable) {
            return Float.valueOf(0.0f);
        }
    }

    @Pure
    public static double doubleValue(CharSequence value) {
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    @Pure
    public static double doubleValue(Object value) {
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            return cvalue.doubleValue();
        }
        if (value != null) {
            return PrimitiveCastExtensions.doubleValue(value.toString());
        }
        return 0.0;
    }

    @Pure
    public static Double toDouble(Object value) {
        double dvalue;
        if (value instanceof Double) {
            Double cvalue = (Double)value;
            return cvalue;
        }
        if (value instanceof Number) {
            Number cvalue = (Number)value;
            dvalue = cvalue.doubleValue();
        } else {
            if (value != null) {
                return PrimitiveCastExtensions.toDouble(value.toString());
            }
            dvalue = 0.0;
        }
        return dvalue;
    }

    @Pure
    public static Double toDouble(CharSequence value) {
        try {
            return Double.valueOf(value.toString());
        }
        catch (Throwable throwable) {
            return 0.0;
        }
    }

    @Pure
    @Inline(value="new $2($3.booleanValue($1))", imported={AtomicBoolean.class, PrimitiveCastExtensions.class})
    public static AtomicBoolean toAtomicBoolean(CharSequence value) {
        return new AtomicBoolean(PrimitiveCastExtensions.booleanValue(value));
    }

    @Pure
    public static AtomicBoolean toAtomicBoolean(Object value) {
        if (value instanceof AtomicBoolean) {
            AtomicBoolean cvalue = (AtomicBoolean)value;
            return cvalue;
        }
        return new AtomicBoolean(PrimitiveCastExtensions.booleanValue(value));
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicBoolean.class})
    public static AtomicBoolean toAtomicBoolean(boolean value) {
        return new AtomicBoolean(value);
    }

    @Pure
    public static AtomicInteger toAtomicInteger(Object value) {
        if (value instanceof AtomicInteger) {
            AtomicInteger cvalue = (AtomicInteger)value;
            return cvalue;
        }
        return new AtomicInteger(PrimitiveCastExtensions.intValue(value));
    }

    @Pure
    @Inline(value="new $2($3.intValue($1))", imported={AtomicInteger.class, PrimitiveCastExtensions.class})
    public static AtomicInteger toAtomicInteger(CharSequence value) {
        return new AtomicInteger(PrimitiveCastExtensions.intValue(value));
    }

    @Pure
    public static AtomicLong toAtomicLong(Object value) {
        if (value instanceof AtomicLong) {
            AtomicLong cvalue = (AtomicLong)value;
            return cvalue;
        }
        return new AtomicLong(PrimitiveCastExtensions.longValue(value));
    }

    @Pure
    @Inline(value="new $2($3.longValue($1))", imported={AtomicLong.class, PrimitiveCastExtensions.class})
    public static AtomicLong toAtomicLong(CharSequence value) {
        return new AtomicLong(PrimitiveCastExtensions.longValue(value));
    }

    @Pure
    public static AtomicDouble toAtomicDouble(Object value) {
        if (value instanceof AtomicDouble) {
            AtomicDouble cvalue = (AtomicDouble)value;
            return cvalue;
        }
        return new AtomicDouble(PrimitiveCastExtensions.doubleValue(value));
    }

    @Pure
    @Inline(value="new $2($3.doubleValue($1))", imported={AtomicDouble.class, PrimitiveCastExtensions.class})
    public static AtomicDouble toAtomicDouble(CharSequence value) {
        return new AtomicDouble(PrimitiveCastExtensions.doubleValue(value));
    }

    private static boolean startsWith(CharSequence value, String prefix, int index) {
        if (value == null) {
            return prefix == null;
        }
        int prefixLength = prefix.length();
        if (value.length() == 0) {
            return prefixLength == 0;
        }
        int eoffset = index + prefixLength;
        if (eoffset > value.length()) {
            return false;
        }
        int idx0 = index;
        int idx1 = 0;
        while (idx1 < prefixLength) {
            if (value.charAt(idx0) != prefix.charAt(idx1)) {
                return false;
            }
            ++idx1;
            ++idx0;
        }
        return true;
    }

    @Pure
    public static BigInteger toBigInteger(Object value) {
        String svalue;
        if (value instanceof BigInteger) {
            BigInteger cvalue = (BigInteger)value;
            return cvalue;
        }
        if (value instanceof BigDecimal) {
            BigDecimal cvalue = (BigDecimal)value;
            return cvalue.toBigInteger();
        }
        if (value != null) {
            if (value instanceof Number) {
                Number cvalue = (Number)value;
                svalue = Long.toString(cvalue.longValue());
            } else {
                svalue = value.toString();
            }
        } else {
            svalue = "0";
        }
        return new BigInteger(svalue);
    }

    @Pure
    public static BigInteger toBigInteger(CharSequence value) {
        try {
            boolean negative = false;
            int index = 0;
            char firstChar = value.charAt(0);
            if (firstChar == '-') {
                negative = true;
                ++index;
            } else if (firstChar == '+') {
                ++index;
            }
            int radix = 10;
            if (PrimitiveCastExtensions.startsWith(value, "0x", index) || PrimitiveCastExtensions.startsWith(value, "0X", index)) {
                index += 2;
                radix = 16;
            } else if (PrimitiveCastExtensions.startsWith(value, "#", index)) {
                ++index;
                radix = 16;
            } else if (PrimitiveCastExtensions.startsWith(value, "0", index) && value.length() > 1 + index) {
                ++index;
                radix = 8;
            }
            CharSequence endValue = index > 0 ? value.subSequence(index, value.length()) : value;
            BigInteger number = new BigInteger(endValue.toString(), radix);
            if (negative) {
                return number.negate();
            }
            return number;
        }
        catch (Throwable throwable) {
            return BigInteger.valueOf(0L);
        }
    }

    @Pure
    public static BigDecimal toBigDecimal(Object value) {
        if (value instanceof BigDecimal) {
            BigDecimal cvalue = (BigDecimal)value;
            return cvalue;
        }
        if (value != null) {
            return new BigDecimal(value.toString());
        }
        return new BigDecimal(0.0);
    }

    @Pure
    public static BigDecimal toBigDecimal(CharSequence value) {
        try {
            return new BigDecimal(value.toString());
        }
        catch (Throwable throwable) {
            return BigDecimal.valueOf(0.0);
        }
    }

    @Pure
    public static UUID toUUID(Object value) {
        if (value instanceof UUID) {
            UUID cvalue = (UUID)value;
            return cvalue;
        }
        if (value != null) {
            return PrimitiveCastExtensions.toUUID(value.toString());
        }
        return null;
    }

    @Pure
    public static UUID toUUID(CharSequence value) {
        try {
            return UUID.fromString(value.toString());
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

