/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.scoping.extensions.numbers.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveFloatCastExtensions {
    private PrimitiveFloatCastExtensions() {
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Float.class})
    public static String toString(float number) {
        return Float.toString(number);
    }

    @Pure
    @Inline(value="new $2(($3) $1)", imported={AtomicLong.class, long.class})
    public static AtomicLong toAtomicLong(float number) {
        return new AtomicLong((long)number);
    }

    @Pure
    @Inline(value="new $2(($3) $1)", imported={AtomicInteger.class, int.class})
    public static AtomicInteger toAtomicInteger(float number) {
        return new AtomicInteger((int)number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicDouble.class})
    public static AtomicDouble toAtomicDouble(float number) {
        return new AtomicDouble((double)number);
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={BigInteger.class, long.class})
    public static BigInteger toBigInteger(float number) {
        return BigInteger.valueOf((long)number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={BigDecimal.class})
    public static BigDecimal toBigDecimal(float number) {
        return BigDecimal.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Byte.class, byte.class})
    public static Byte toByte(float number) {
        return (byte)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Short.class, short.class})
    public static Short toShort(float number) {
        return (short)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Integer.class, int.class})
    public static Integer toInteger(float number) {
        return (int)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Long.class, long.class})
    public static Long toLong(float number) {
        return (long)number;
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={Double.class})
    public static Double toDouble(float number) {
        return number;
    }
}

