/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.scoping.extensions.numbers.cast;

import com.google.common.util.concurrent.AtomicDouble;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveIntCastExtensions {
    private PrimitiveIntCastExtensions() {
    }

    @Pure
    @Inline(value="$2.toString($1)", imported={Integer.class})
    public static String toString(int number) {
        return Integer.toString(number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicLong.class})
    public static AtomicLong toAtomicLong(int number) {
        return new AtomicLong(number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicInteger.class})
    public static AtomicInteger toAtomicInteger(int number) {
        return new AtomicInteger(number);
    }

    @Pure
    @Inline(value="new $2($1)", imported={AtomicDouble.class})
    public static AtomicDouble toAtomicDouble(int number) {
        return new AtomicDouble((double)number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={BigInteger.class})
    public static BigInteger toBigInteger(int number) {
        return BigInteger.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={BigDecimal.class})
    public static BigDecimal toBigDecimal(int number) {
        return BigDecimal.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Byte.class, byte.class})
    public static Byte toByte(int number) {
        return (byte)number;
    }

    @Pure
    @Inline(value="$2.valueOf(($3) $1)", imported={Short.class, short.class})
    public static Short toShort(int number) {
        return (short)number;
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={Long.class})
    public static Long toLong(int number) {
        return number;
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={Float.class})
    public static Float toFloat(int number) {
        return Float.valueOf(number);
    }

    @Pure
    @Inline(value="$2.valueOf($1)", imported={Double.class})
    public static Double toDouble(int number) {
        return number;
    }
}

