/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.scoping.extensions.numbers.comparison;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

public final class PrimitiveFloatComparisonExtensions {
    private PrimitiveFloatComparisonExtensions() {
    }

    @Pure
    @Inline(value="($1 >= $2.doubleValue())", constantExpression=true)
    public static boolean operator_greaterEqualsThan(float left, Number right) {
        return (double)left >= right.doubleValue();
    }

    @Pure
    @Inline(value="($1 <= $2.doubleValue())", constantExpression=true)
    public static boolean operator_lessEqualsThan(float left, Number right) {
        return (double)left <= right.doubleValue();
    }

    @Pure
    @Inline(value="($1 > $2.doubleValue())", constantExpression=true)
    public static boolean operator_greaterThan(float left, Number right) {
        return (double)left > right.doubleValue();
    }

    @Pure
    @Inline(value="($1 < $2.doubleValue())", constantExpression=true)
    public static boolean operator_lessThan(float left, Number right) {
        return (double)left < right.doubleValue();
    }

    @Pure
    @Inline(value="($2 != null && $1 == $2.doubleValue())", constantExpression=true)
    public static boolean operator_equals(float left, Number right) {
        return right != null && (double)left == right.doubleValue();
    }

    @Pure
    @Inline(value="($2 == null || $1 != $2.doubleValue())", constantExpression=true)
    public static boolean operator_notEquals(float left, Number right) {
        return right == null || (double)left != right.doubleValue();
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, byte right) {
        return Float.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, short right) {
        return Float.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, int right) {
        return Float.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, long right) {
        return Float.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, float right) {
        return Float.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2)", constantExpression=true, imported={Double.class})
    public static int operator_spaceship(float left, double right) {
        return Double.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.byteValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, Byte right) {
        return Float.compare(left, right.byteValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.shortValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, Short right) {
        return Float.compare(left, right.shortValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.intValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, Integer right) {
        return Float.compare(left, right.intValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.longValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, Long right) {
        return Float.compare(left, right.longValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.floatValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, Float right) {
        return Float.compare(left, right.floatValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.doubleValue())", constantExpression=true, imported={Double.class})
    public static int operator_spaceship(float left, Double right) {
        return Double.compare(left, right);
    }

    @Pure
    @Inline(value="$3.compare($1, $2.intValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, AtomicInteger right) {
        return Float.compare(left, right.intValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.longValue())", constantExpression=true, imported={Float.class})
    public static int operator_spaceship(float left, AtomicLong right) {
        return Float.compare(left, right.longValue());
    }

    @Pure
    @Inline(value="$3.compare($1, $2.doubleValue())", constantExpression=true, imported={Double.class})
    public static int operator_spaceship(float left, Number right) {
        return Double.compare(left, right.doubleValue());
    }
}

