/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.scoping.extensions.time;

import com.google.common.annotations.GwtCompatible;
import java.util.concurrent.TimeUnit;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pure;

@GwtCompatible
public final class TimeExtensions {
    public static final long MILLIS_IN_SECOND = 1000L;
    public static final long MILLIS_IN_MINUTE = 60000L;
    public static final long MILLIS_IN_HOUR = 3600000L;
    public static final long MILLIS_IN_DAY = 86400000L;
    public static final long MILLIS_IN_WEEK = 604800000L;
    public static final double MILLIS_IN_MICROSECOND = 1.0E-5;
    public static final double MILLIS_IN_NANOSECOND = 1.0E-8;

    private TimeExtensions() {
    }

    @Pure
    @Inline(value="($1).longValue()")
    public static long milliseconds(Number milis) {
        return milis.longValue();
    }

    @Pure
    @Inline(value="(long) ($1)")
    public static long milliseconds(byte milis) {
        return milis;
    }

    @Pure
    @Inline(value="(long) ($1)")
    public static long milliseconds(short milis) {
        return milis;
    }

    @Pure
    @Inline(value="(long) ($1)")
    public static long milliseconds(int milis) {
        return milis;
    }

    @Pure
    @Inline(value="(long) ($1)")
    public static long milliseconds(long milis) {
        return milis;
    }

    @Pure
    @Inline(value="(long) ($1)")
    public static long milliseconds(float milis) {
        return (long)milis;
    }

    @Pure
    @Inline(value="(long) ($1)")
    public static long milliseconds(double milis) {
        return (long)milis;
    }

    @Pure
    @Inline(value="(long) (($1).doubleValue() * $2.MILLIS_IN_SECOND)", imported={TimeExtensions.class})
    public static long seconds(Number secs) {
        return (long)(secs.doubleValue() * 1000.0);
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_SECOND", imported={TimeExtensions.class})
    public static long seconds(byte secs) {
        return (long)secs * 1000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_SECOND", imported={TimeExtensions.class})
    public static long seconds(short secs) {
        return (long)secs * 1000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_SECOND", imported={TimeExtensions.class})
    public static long seconds(int secs) {
        return (long)secs * 1000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_SECOND", imported={TimeExtensions.class})
    public static long seconds(long secs) {
        return secs * 1000L;
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_SECOND)", imported={TimeExtensions.class})
    public static long seconds(float secs) {
        return (long)(secs * 1000.0f);
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_SECOND)", imported={TimeExtensions.class})
    public static long seconds(double secs) {
        return (long)(secs * 1000.0);
    }

    @Pure
    @Inline(value="(long) (($1).doubleValue() * $2.MILLIS_IN_MINUTE)", imported={TimeExtensions.class})
    public static long minutes(Number mins) {
        return (long)(mins.doubleValue() * 60000.0);
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_MINUTE", imported={TimeExtensions.class})
    public static long minutes(byte mins) {
        return (long)mins * 60000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_MINUTE", imported={TimeExtensions.class})
    public static long minutes(short mins) {
        return (long)mins * 60000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_MINUTE", imported={TimeExtensions.class})
    public static long minutes(int mins) {
        return (long)mins * 60000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_MINUTE", imported={TimeExtensions.class})
    public static long minutes(long mins) {
        return mins * 60000L;
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_MINUTE)", imported={TimeExtensions.class})
    public static long minutes(float mins) {
        return (long)(mins * 60000.0f);
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_MINUTE)", imported={TimeExtensions.class})
    public static long minutes(double mins) {
        return (long)(mins * 60000.0);
    }

    @Pure
    @Inline(value="(long) (($1).doubleValue() * $2.MILLIS_IN_HOUR)", imported={TimeExtensions.class})
    public static long hours(Number hours) {
        return (long)(hours.doubleValue() * 3600000.0);
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_HOUR", imported={TimeExtensions.class})
    public static long hours(byte hours) {
        return (long)hours * 3600000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_HOUR", imported={TimeExtensions.class})
    public static long hours(short hours) {
        return (long)hours * 3600000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_HOUR", imported={TimeExtensions.class})
    public static long hours(int hours) {
        return (long)hours * 3600000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_HOUR", imported={TimeExtensions.class})
    public static long hours(long hours) {
        return hours * 3600000L;
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_HOUR)", imported={TimeExtensions.class})
    public static long hours(float hours) {
        return (long)(hours * 3600000.0f);
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_HOUR)", imported={TimeExtensions.class})
    public static long hours(double hours) {
        return (long)(hours * 3600000.0);
    }

    @Pure
    @Inline(value="(long) (($1).doubleValue() * $2.MILLIS_IN_DAY)", imported={TimeExtensions.class})
    public static long days(Number days) {
        return (long)(days.doubleValue() * 8.64E7);
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_DAY", imported={TimeExtensions.class})
    public static long days(byte days) {
        return (long)days * 86400000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_DAY", imported={TimeExtensions.class})
    public static long days(short days) {
        return (long)days * 86400000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_DAY", imported={TimeExtensions.class})
    public static long days(int days) {
        return (long)days * 86400000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_DAY", imported={TimeExtensions.class})
    public static long days(long days) {
        return days * 86400000L;
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_DAY)", imported={TimeExtensions.class})
    public static long days(float days) {
        return (long)(days * 8.64E7f);
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_DAY)", imported={TimeExtensions.class})
    public static long days(double days) {
        return (long)(days * 8.64E7);
    }

    @Pure
    @Inline(value="(long) (($1).doubleValue() * $2.MILLIS_IN_WEEK)", imported={TimeExtensions.class})
    public static long weeks(Number weeks) {
        return (long)(weeks.doubleValue() * 6.048E8);
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_WEEK", imported={TimeExtensions.class})
    public static long weeks(byte weeks) {
        return (long)weeks * 604800000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_WEEK", imported={TimeExtensions.class})
    public static long weeks(short weeks) {
        return (long)weeks * 604800000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_WEEK", imported={TimeExtensions.class})
    public static long weeks(int weeks) {
        return (long)weeks * 604800000L;
    }

    @Pure
    @Inline(value="($1) * $2.MILLIS_IN_WEEK", imported={TimeExtensions.class})
    public static long weeks(long weeks) {
        return weeks * 604800000L;
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_WEEK)", imported={TimeExtensions.class})
    public static long weeks(float weeks) {
        return (long)(weeks * 6.048E8f);
    }

    @Pure
    @Inline(value="(long) (($1) * $2.MILLIS_IN_WEEK)", imported={TimeExtensions.class})
    public static long weeks(double weeks) {
        return (long)(weeks * 6.048E8);
    }

    @Pure
    public static double convertFromTo(double time, TimeUnit source, TimeUnit target) {
        assert (source != null);
        assert (target != null);
        if (source == target) {
            return time;
        }
        double millis = switch (source) {
            case TimeUnit.DAYS -> time * 8.64E7;
            case TimeUnit.HOURS -> time * 3600000.0;
            case TimeUnit.MINUTES -> time * 60000.0;
            case TimeUnit.SECONDS -> time * 1000.0;
            case TimeUnit.MILLISECONDS -> time;
            case TimeUnit.NANOSECONDS -> time * 1.0E-8;
            case TimeUnit.MICROSECONDS -> time * 1.0E-5;
            default -> throw new IllegalArgumentException();
        };
        switch (target) {
            case DAYS: {
                return millis / 8.64E7;
            }
            case HOURS: {
                return millis / 3600000.0;
            }
            case MINUTES: {
                return millis / 60000.0;
            }
            case SECONDS: {
                return millis / 1000.0;
            }
            case MILLISECONDS: {
                return millis;
            }
            case NANOSECONDS: {
                return millis / 1.0E-8;
            }
            case MICROSECONDS: {
                return millis / 1.0E-5;
            }
        }
        throw new IllegalArgumentException();
    }
}

