/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.util;

import com.google.common.base.Strings;

public final class CliUtilities {
    private static final String UNIX_LOPT = "--";
    private static final String WINDOWS_LOPT = "/";
    private static final String UNIX_SOPT = "-";
    private static final String WINDOWS_SOPT = "/";
    private static final String EQUAL_SIGN = "=";
    private static final String DEFINITION_PREFIX = "D";

    private CliUtilities() {
    }

    private static boolean isUnixCompliant() {
        String os = System.getProperty("os.name").trim().toLowerCase();
        return os.indexOf("windows") < 0;
    }

    public static String getCommandLineLastOptionPrefix() {
        if (CliUtilities.isUnixCompliant()) {
            return UNIX_LOPT;
        }
        return "";
    }

    public static String getCommandLineLongOptionPrefix() {
        if (CliUtilities.isUnixCompliant()) {
            return UNIX_LOPT;
        }
        return "/";
    }

    public static String getCommandLineShortOptionPrefix() {
        if (CliUtilities.isUnixCompliant()) {
            return UNIX_SOPT;
        }
        return "/";
    }

    public static String getCommandLineOption(String name) {
        if (name.length() > 1) {
            return CliUtilities.getCommandLineLongOptionPrefix() + name;
        }
        return CliUtilities.getCommandLineShortOptionPrefix() + name;
    }

    public static String getCommandLineOption(String name, boolean value) {
        return CliUtilities.getCommandLineOption(name) + EQUAL_SIGN + value;
    }

    public static String getCommandLineOption(String name, long value) {
        return CliUtilities.getCommandLineOption(name) + EQUAL_SIGN + value;
    }

    public static String getCommandLineOption(String name, double value) {
        return CliUtilities.getCommandLineOption(name) + EQUAL_SIGN + value;
    }

    public static String getCommandLineOption(String name, String value) {
        assert (!Strings.isNullOrEmpty((String)name));
        assert (!Strings.isNullOrEmpty((String)value));
        StringBuilder buf = new StringBuilder();
        buf.append(CliUtilities.getCommandLineOption(name));
        buf.append(EQUAL_SIGN).append(value);
        return buf.toString();
    }

    public static String getCommandLineDefinition(String name, boolean value) {
        return CliUtilities.getCommandLineDefinition(name, Boolean.toString(value));
    }

    public static String getCommandLineDefinition(String name, long value) {
        return CliUtilities.getCommandLineDefinition(name, Long.toString(value));
    }

    public static String getCommandLineDefinition(String name, double value) {
        return CliUtilities.getCommandLineDefinition(name, Double.toString(value));
    }

    public static String getCommandLineDefinition(String name, String value) {
        assert (!Strings.isNullOrEmpty((String)name));
        assert (!Strings.isNullOrEmpty((String)value));
        StringBuilder buf = new StringBuilder();
        buf.append(CliUtilities.getCommandLineOption(DEFINITION_PREFIX));
        buf.append(name);
        buf.append(EQUAL_SIGN).append(value);
        return buf.toString();
    }

    public static String getUnixCommandLineOption(String name) {
        if (name.length() > 1) {
            return CliUtilities.getUnixCommandLineLongOptionPrefix() + name;
        }
        return CliUtilities.getUnixCommandLineShortOptionPrefix() + name;
    }

    public static String getUnixCommandLineOption(String name, String value) {
        assert (!Strings.isNullOrEmpty((String)name));
        assert (!Strings.isNullOrEmpty((String)value));
        StringBuilder buf = new StringBuilder();
        buf.append(CliUtilities.getUnixCommandLineOption(name));
        buf.append(EQUAL_SIGN).append(value);
        return buf.toString();
    }

    public static String getUnixCommandLineShortOptionPrefix() {
        return UNIX_SOPT;
    }

    public static String getUnixCommandLineLongOptionPrefix() {
        return UNIX_LOPT;
    }

    public static String getUnixCommandLineLastOptionPrefix() {
        return UNIX_LOPT;
    }
}

