/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.util;

import io.sarl.lang.core.util.ConcurrentCollection;
import io.sarl.lang.core.util.ConcurrentCollectionFactory;
import io.sarl.lang.core.util.ConcurrentCollectionLinkedDeque;
import io.sarl.lang.core.util.ConcurrentList;
import io.sarl.lang.core.util.ConcurrentListCopyOnWriteList;
import io.sarl.lang.core.util.ConcurrentSet;
import io.sarl.lang.core.util.ConcurrentSetSkipListSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class DefaultConcurrentCollectionFactory
implements ConcurrentCollectionFactory {
    @Override
    public <T> ConcurrentCollection<T> newCollection() {
        return new ConcurrentCollectionLinkedDeque();
    }

    @Override
    public <T> ConcurrentCollection<T> newCollection(Collection<T> toCopy) {
        return new ConcurrentCollectionLinkedDeque<T>(toCopy);
    }

    @Override
    public <T> ConcurrentSet<T> newSet(Comparator<? super T> comparator) {
        return new ConcurrentSetSkipListSet<T>(comparator);
    }

    @Override
    public <T> ConcurrentSet<T> newSet(Comparator<? super T> comparator, Collection<T> toCopy) {
        return new ConcurrentSetSkipListSet<T>(toCopy);
    }

    @Override
    public <T> ConcurrentList<T> newList() {
        return new ConcurrentListCopyOnWriteList();
    }

    @Override
    public <T> ConcurrentList<T> newList(List<T> toCopy) {
        return new ConcurrentListCopyOnWriteList<T>(toCopy);
    }

    @Override
    public <K, V> ConcurrentMap<K, V> newMap(Comparator<? super K> comparator) {
        return new ConcurrentSkipListMap(comparator);
    }

    @Override
    public <K, V> ConcurrentMap<K, V> newMap(Comparator<? super K> comparator, Map<K, V> toCopy) {
        ConcurrentSkipListMap<K, V> map = new ConcurrentSkipListMap<K, V>(comparator);
        if (toCopy != null) {
            map.putAll(toCopy);
        }
        return map;
    }
}

