/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class MutableOptional<T> {
    private T value;

    public static <T> MutableOptional<T> empty() {
        return new MutableOptional<Object>(null);
    }

    public static <T> MutableOptional<T> of(T value) {
        return new MutableOptional<T>(value);
    }

    private MutableOptional(T value) {
        this.value = value;
    }

    public synchronized T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public synchronized boolean isPresent() {
        return this.value != null;
    }

    public synchronized boolean isEmpty() {
        return this.value == null;
    }

    public synchronized void ifPresent(Consumer<? super T> action) {
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public synchronized void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        if (this.value != null) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
    }

    public synchronized MutableOptional<T> filter(Predicate<? super T> predicate) {
        assert (predicate != null);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : MutableOptional.empty();
    }

    public synchronized <U> MutableOptional<U> map(Function<? super T, ? extends U> mapper) {
        assert (mapper != null);
        if (!this.isPresent()) {
            return MutableOptional.empty();
        }
        return new MutableOptional<U>(mapper.apply(this.value));
    }

    public synchronized <U> MutableOptional<U> flatMap(Function<? super T, ? extends MutableOptional<? extends U>> mapper) {
        assert (mapper != null);
        if (!this.isPresent()) {
            return MutableOptional.empty();
        }
        MutableOptional<? extends U> r = mapper.apply(this.value);
        assert (r != null);
        return r;
    }

    public synchronized MutableOptional<T> or(Supplier<? extends MutableOptional<? extends T>> supplier) {
        assert (supplier != null);
        if (this.isPresent()) {
            return this;
        }
        MutableOptional<? extends T> r = supplier.get();
        assert (r != null);
        return r;
    }

    public synchronized T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    public synchronized T orElseGet(Supplier<? extends T> supplier) {
        return this.value != null ? this.value : supplier.get();
    }

    public synchronized T orElseThrow() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public synchronized <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        assert (exceptionSupplier != null);
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MutableOptional)) return false;
        MutableOptional other = (MutableOptional)obj;
        if (!Objects.equals(this.value, other.value)) return false;
        return true;
    }

    public synchronized int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? "Optional[" + String.valueOf(this.value) + "]" : "Optional.empty";
    }

    public synchronized void set(T value) {
        this.value = value;
    }
}

