/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.core.util;

public final class SarlUtils {
    public static final String HIDDEN_MEMBER_CHARACTER = "$";

    private SarlUtils() {
    }

    public static boolean isHiddenMember(String name) {
        return name.contains(HIDDEN_MEMBER_CHARACTER);
    }

    public static String[] getFileExtensions(String fileExtensions) {
        if (fileExtensions == null) {
            return null;
        }
        return fileExtensions.split("\\s*([,;:]\\s*)+");
    }

    public static String getMajorFileExtension(String[] fileExtensions) {
        return fileExtensions == null || fileExtensions.length <= 0 ? null : fileExtensions[0];
    }

    public static String getMajorFileExtension(String fileExtensions) {
        return SarlUtils.getMajorFileExtension(SarlUtils.getFileExtensions(fileExtensions));
    }

    public static boolean hasFileExtension(String filename, String[] fileExtensions) {
        if (fileExtensions != null && filename != null) {
            int lg = filename.length();
            for (String extension : fileExtensions) {
                int idx;
                int elg = extension.length();
                if (lg < elg + 1 || '.' != filename.charAt(idx = filename.length() - elg - 1) || !SarlUtils.eq(idx + 1, filename, extension)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean eq(int idx, String filename, String extension) {
        int flg = filename.length();
        int elg = extension.length();
        int i = 0;
        for (int j = idx; i < elg && j < flg; ++i, ++j) {
            if (filename.charAt(j) == extension.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

