/*
 * $Id$
 *
 * SARL is an general-purpose agent programming language.
 * More details on http://www.sarl.io
 *
 * Copyright (C) 2014-2025 SARL.io, the Original Authors and Main Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.sarl.lang.mwe2.codebuilder.fragments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import com.google.inject.Singleton;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Pure;

/**
 * Contributions to the code builder factory.
 *
 * @author <a href="http://www.ciad-lab.fr/stephane_galland">St&eacute;phane Galland</a>
 * @version mwe2 0.15.1 20250911-224823
 * @mavengroupid io.sarl.lang
 * @mavenartifactid mwe2
 */
@Singleton
public class BuilderFactoryContributions {

	private final List<StringConcatenationClient> contributions = new ArrayList<>();

	/** Add a contribution.
	 *
	 * @param contribution the contribution.
	 */
	public void addContribution(StringConcatenationClient contribution) {
		if (contribution != null) {
			this.contributions.add(contribution);
		}
	}

	/** Replies the contributions.
	 *
	 * @return the contributions.
	 */
	@Pure
	public List<StringConcatenationClient> getContributions() {
		return Collections.unmodifiableList(this.contributions);
	}

}
