/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.binding;

import io.sarl.lang.mwe2.binding.BindingElement;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;
import org.eclipse.xtext.xtext.generator.model.TypeReference;

public class BindingFactory {
    private static final String CONFIGURE_PREFIX = "configure";
    private static final String BIND_PREFIX = "bind";
    private static final String REFERENCE_PREFIX = "ref ";
    private WeakReference<GuiceModuleAccess> module;
    private String name;
    private final Set<GuiceModuleAccess.Binding> bindings = new HashSet<GuiceModuleAccess.Binding>();
    private final List<GuiceModuleAccess.Binding> removableBindings = new ArrayList<GuiceModuleAccess.Binding>();

    public void setName(String name) {
        this.name = name;
    }

    public void setGuiceModule(GuiceModuleAccess module) {
        this.module = new WeakReference<GuiceModuleAccess>(module);
    }

    protected GuiceModuleAccess.Binding bindAnnotatedWith(final TypeReference bind, final TypeReference annotatedWith, final TypeReference to, String functionName) {
        StringConcatenationClient client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                builder.append((Object)"binder.bind(");
                builder.append((Object)bind);
                builder.append((Object)".class).annotatedWith(");
                builder.append((Object)annotatedWith);
                builder.append((Object)".class).to(");
                builder.append((Object)to);
                builder.append((Object)".class);");
            }
        };
        String fctname = functionName;
        if (Strings.isEmpty((String)fctname)) {
            fctname = bind.getSimpleName();
        }
        GuiceModuleAccess.BindKey key = new GuiceModuleAccess.BindKey(BindingFactory.formatFunctionName(fctname), null, false, false);
        GuiceModuleAccess.BindValue statements = new GuiceModuleAccess.BindValue(null, null, false, Collections.singletonList(client));
        return new GuiceModuleAccess.Binding(key, statements, true, this.name);
    }

    protected GuiceModuleAccess.Binding bindAnnotatedWithToInstance(final TypeReference bind, final TypeReference annotatedWith, final String to, String functionName) {
        StringConcatenationClient client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                builder.append((Object)"binder.bind(");
                builder.append((Object)bind);
                builder.append((Object)".class).annotatedWith(");
                builder.append((Object)annotatedWith);
                builder.append((Object)".class).toInstance(");
                builder.append((Object)to);
                builder.append((Object)".class);");
            }
        };
        String fctname = functionName;
        if (Strings.isEmpty((String)fctname)) {
            fctname = bind.getSimpleName();
        }
        GuiceModuleAccess.BindKey key = new GuiceModuleAccess.BindKey(BindingFactory.formatFunctionName(fctname), null, false, false);
        GuiceModuleAccess.BindValue statements = new GuiceModuleAccess.BindValue(null, null, false, Collections.singletonList(client));
        return new GuiceModuleAccess.Binding(key, statements, true, this.name);
    }

    protected GuiceModuleAccess.Binding bindAnnotatedWithName(final TypeReference bind, String name, TypeReference to, String functionName) {
        Object tmpName = Strings.emptyIfNull((String)name);
        tmpName = ((String)tmpName).startsWith(REFERENCE_PREFIX) ? ((String)tmpName).substring(REFERENCE_PREFIX.length()).trim() : "\"" + (String)tmpName + "\"";
        Object unferencedName = tmpName;
        StringConcatenationClient client = new StringConcatenationClient(this, (String)unferencedName, to){
            final /* synthetic */ String val$unferencedName;
            final /* synthetic */ TypeReference val$to;
            {
                this.val$unferencedName = string;
                this.val$to = typeReference2;
            }

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                builder.append((Object)"binder.bind(");
                builder.append((Object)bind);
                builder.append((Object)".class).annotatedWith(Names.named(");
                builder.append((Object)this.val$unferencedName);
                builder.append((Object)")).to(");
                builder.append((Object)this.val$to);
                builder.append((Object)".class);");
            }
        };
        String fctname = functionName;
        if (Strings.isEmpty((String)fctname)) {
            fctname = name;
        }
        GuiceModuleAccess.BindKey key = new GuiceModuleAccess.BindKey(BindingFactory.formatFunctionName(fctname), null, false, false);
        GuiceModuleAccess.BindValue statements = new GuiceModuleAccess.BindValue(null, null, false, Collections.singletonList(client));
        return new GuiceModuleAccess.Binding(key, statements, true, this.name);
    }

    protected GuiceModuleAccess.Binding bindAnnotatedWithNameToInstance(final TypeReference bind, String name, String to, String functionName) {
        Object tmpName = Strings.emptyIfNull((String)name);
        tmpName = ((String)tmpName).startsWith(REFERENCE_PREFIX) ? ((String)tmpName).substring(REFERENCE_PREFIX.length()).trim() : "\"" + (String)tmpName + "\"";
        Object unferencedName = tmpName;
        StringConcatenationClient client = new StringConcatenationClient(this, (String)unferencedName, to){
            final /* synthetic */ String val$unferencedName;
            final /* synthetic */ String val$to;
            {
                this.val$unferencedName = string;
                this.val$to = string2;
            }

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                builder.append((Object)"binder.bind(");
                builder.append((Object)bind);
                builder.append((Object)".class).annotatedWith(Names.named(");
                builder.append((Object)this.val$unferencedName);
                builder.append((Object)")).toInstance(");
                builder.append((Object)this.val$to);
                builder.append((Object)".class);");
            }
        };
        String fctname = functionName;
        if (Strings.isEmpty((String)fctname)) {
            fctname = name;
        }
        GuiceModuleAccess.BindKey key = new GuiceModuleAccess.BindKey(BindingFactory.formatFunctionName(fctname), null, false, false);
        GuiceModuleAccess.BindValue statements = new GuiceModuleAccess.BindValue(null, null, false, Collections.singletonList(client));
        return new GuiceModuleAccess.Binding(key, statements, true, this.name);
    }

    protected GuiceModuleAccess.Binding bindToInstance(final TypeReference bind, String functionName, final String instanceExpression, boolean isSingleton, boolean isEager) {
        GuiceModuleAccess.BindValue value;
        GuiceModuleAccess.BindKey type;
        if (!Strings.isEmpty((String)functionName) && functionName.startsWith(CONFIGURE_PREFIX)) {
            String fname = functionName.substring(CONFIGURE_PREFIX.length());
            type = new GuiceModuleAccess.BindKey(Strings.toFirstUpper((String)fname), null, isSingleton, isEager);
            StringConcatenationClient client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                    builder.append((Object)"binder.bind(");
                    builder.append((Object)bind);
                    builder.append((Object)".class).toInstance(");
                    builder.append((Object)instanceExpression);
                    builder.append((Object)");");
                }
            };
            value = new GuiceModuleAccess.BindValue(null, null, false, Collections.singletonList(client));
        } else {
            String fname = functionName;
            if (fname != null && fname.startsWith(BIND_PREFIX)) {
                fname = fname.substring(BIND_PREFIX.length());
            }
            type = new GuiceModuleAccess.BindKey(Strings.toFirstUpper((String)fname), bind, isSingleton, isEager);
            StringConcatenationClient client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                    builder.append((Object)instanceExpression);
                }
            };
            value = new GuiceModuleAccess.BindValue((Object)client, null, false, Collections.emptyList());
        }
        return new GuiceModuleAccess.Binding(type, value, true, this.name);
    }

    protected GuiceModuleAccess.Binding bindToType(final TypeReference bind, String functionName, final TypeReference to, boolean isSingleton, boolean isEager, boolean isProvider) {
        GuiceModuleAccess.BindValue value;
        GuiceModuleAccess.BindKey type;
        if (!Strings.isEmpty((String)functionName) && functionName.startsWith(CONFIGURE_PREFIX)) {
            String fname = functionName.substring(CONFIGURE_PREFIX.length());
            type = new GuiceModuleAccess.BindKey(Strings.toFirstUpper((String)fname), null, false, false);
            StringConcatenationClient client = isProvider ? new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                    builder.append((Object)"binder.bind(");
                    builder.append((Object)bind);
                    builder.append((Object)".class).toProvider(");
                    builder.append((Object)to);
                    builder.append((Object)".class);");
                }
            } : new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                    builder.append((Object)"binder.bind(");
                    builder.append((Object)bind);
                    builder.append((Object)".class).to(");
                    builder.append((Object)to);
                    builder.append((Object)".class);");
                }
            };
            value = new GuiceModuleAccess.BindValue(null, null, false, Collections.singletonList(client));
        } else {
            String fname = functionName;
            if (fname != null && fname.startsWith(BIND_PREFIX)) {
                fname = fname.substring(BIND_PREFIX.length());
            }
            type = new GuiceModuleAccess.BindKey(Strings.toFirstUpper((String)fname), bind, isSingleton, isEager);
            value = new GuiceModuleAccess.BindValue(null, to, false, Collections.emptyList());
        }
        return new GuiceModuleAccess.Binding(type, value, true, this.name);
    }

    private static GuiceModuleAccess.Binding findBinding(Set<GuiceModuleAccess.Binding> bindings, GuiceModuleAccess.Binding binding) {
        for (GuiceModuleAccess.Binding bnd : bindings) {
            if (!Objects.equals(bnd, binding)) continue;
            return bnd;
        }
        return null;
    }

    private static String formatFunctionName(String name) {
        String formattedName = name;
        if (formattedName.startsWith(CONFIGURE_PREFIX)) {
            formattedName = formattedName.substring(CONFIGURE_PREFIX.length());
        } else if (formattedName.startsWith(BIND_PREFIX)) {
            formattedName = formattedName.substring(BIND_PREFIX.length());
        }
        return Strings.toFirstUpper((String)formattedName);
    }

    public void add(GuiceModuleAccess.Binding binding, boolean override) {
        Set moduleBindings = ((GuiceModuleAccess)this.module.get()).getBindings();
        GuiceModuleAccess.Binding otherBinding = BindingFactory.findBinding(moduleBindings, binding);
        if (!override) {
            if (otherBinding != null) {
                throw new IllegalArgumentException(MessageFormat.format("Forbidden override of {0} by {1}.", otherBinding, binding));
            }
        } else if (otherBinding != null) {
            this.removableBindings.add(otherBinding);
        }
        if (!this.bindings.add(binding)) {
            throw new IllegalArgumentException(MessageFormat.format("Duplicate binding for {0} in {1}", binding.getKey(), this.name));
        }
    }

    public void contributeToModule() {
        GuiceModuleAccess module = (GuiceModuleAccess)this.module.get();
        if (!this.removableBindings.isEmpty()) {
            try {
                Field field = module.getClass().getDeclaredField("bindings");
                field.setAccessible(true);
                Collection hiddenBindings = (Collection)field.get(module);
                hiddenBindings.removeAll(this.removableBindings);
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        module.addAll(this.bindings);
    }

    private static TypeReference typeRef(String qualifiedName) {
        int index = qualifiedName.indexOf(36);
        if (index > 0) {
            Object classname = qualifiedName.substring(0, index);
            String innerClasses = qualifiedName.substring(index + 1);
            index = ((String)classname).lastIndexOf(46);
            if (index >= 0) {
                String packageName = ((String)classname).substring(0, index);
                classname = ((String)classname).substring(index + 1) + "." + innerClasses;
                return new TypeReference(packageName, (String)classname);
            }
        }
        return TypeReference.typeRef((String)qualifiedName, (TypeReference[])new TypeReference[0]);
    }

    public GuiceModuleAccess.Binding toBinding(BindingElement element) {
        TypeReference typeReference = BindingFactory.typeRef(element.getBind());
        String annotatedWith = element.getAnnotatedWith();
        String annotatedWithName = element.getAnnotatedWithName();
        if (!Strings.isEmpty((String)annotatedWith)) {
            TypeReference annotationType = BindingFactory.typeRef(annotatedWith);
            if (element.isInstance()) {
                return this.bindAnnotatedWithToInstance(typeReference, annotationType, element.getTo(), element.getFunctionName());
            }
            TypeReference typeReference2 = BindingFactory.typeRef(element.getTo());
            return this.bindAnnotatedWith(typeReference, annotationType, typeReference2, element.getFunctionName());
        }
        if (!Strings.isEmpty((String)annotatedWithName)) {
            if (element.isInstance()) {
                return this.bindAnnotatedWithNameToInstance(typeReference, annotatedWithName, element.getTo(), element.getFunctionName());
            }
            TypeReference typeReference2 = BindingFactory.typeRef(element.getTo());
            return this.bindAnnotatedWithName(typeReference, annotatedWithName, typeReference2, element.getFunctionName());
        }
        if (element.isInstance()) {
            return this.bindToInstance(typeReference, element.getFunctionName(), element.getTo(), element.isSingleton(), element.isEager());
        }
        TypeReference typeReference2 = BindingFactory.typeRef(element.getTo());
        return this.bindToType(typeReference, element.getFunctionName(), typeReference2, element.isSingleton(), element.isEager(), element.isProvider());
    }
}

