/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.binding;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.binding.BindingElement;
import io.sarl.lang.mwe2.binding.BindingFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;

public class InjectionFragment2
extends AbstractXtextGeneratorFragment {
    protected static final Logger LOG = Logger.getLogger(InjectionFragment2.class);
    @Inject
    private Injector injector;
    private String name = ((Object)((Object)this)).getClass().getName();
    private String comment;
    private boolean overrideAll;
    private final List<BindingElement> rtBindingElements = new ArrayList<BindingElement>();
    private final List<BindingElement> uiBindingElements = new ArrayList<BindingElement>();

    public void setOverrideAll(boolean override) {
        this.overrideAll = override;
    }

    public boolean isOverrideAll() {
        return this.overrideAll;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.name = !Strings.isEmpty((String)comment) ? MessageFormat.format("{0} [{1}]", ((Object)((Object)this)).getClass().getName(), comment) : ((Object)((Object)this)).getClass().getName();
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public String getComment() {
        return this.comment;
    }

    public void addRuntime(BindingElement element) {
        if (element != null) {
            this.rtBindingElements.add(element);
        }
    }

    @Pure
    public List<BindingElement> getRuntimeBindings() {
        return this.rtBindingElements;
    }

    public void addUi(BindingElement element) {
        if (element != null) {
            this.uiBindingElements.add(element);
        }
    }

    @Pure
    public List<BindingElement> getUiBindings() {
        return this.uiBindingElements;
    }

    public void addBoth(BindingElement element) {
        if (element != null) {
            this.rtBindingElements.add(element);
            this.uiBindingElements.add(element);
        }
    }

    private void bind(GuiceModuleAccess module, List<BindingElement> bindings) {
        BindingFactory bindingFactory = (BindingFactory)this.injector.getInstance(BindingFactory.class);
        bindingFactory.setName(this.name);
        bindingFactory.setGuiceModule(module);
        for (BindingElement element : bindings) {
            GuiceModuleAccess.Binding guiceBinding = bindingFactory.toBinding(element);
            bindingFactory.add(guiceBinding, this.isOverrideAll() || element.isOverride());
        }
        bindingFactory.contributeToModule();
    }

    public void generate() {
        List<BindingElement> elements = this.getRuntimeBindings();
        if (!elements.isEmpty()) {
            LOG.info((Object)MessageFormat.format("Generating the user-defined bindings for runtime module: {0}", Strings.emptyIfNull((String)this.getComment())));
            this.bind(this.getLanguage().getRuntimeGenModule(), elements);
        }
        if (!(elements = this.getUiBindings()).isEmpty()) {
            LOG.info((Object)MessageFormat.format("Generating the user-defined bindings for ui module: {0}", Strings.emptyIfNull((String)this.getComment())));
            this.bind(this.getLanguage().getEclipsePluginGenModule(), elements);
        }
    }
}

