/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.binding;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import io.sarl.lang.mwe2.binding.BindingElement;
import io.sarl.lang.mwe2.binding.BindingFactory;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.xtend.core.XtendRuntimeModule;
import org.eclipse.xtend.ide.common.XtendIdeModule;
import org.eclipse.xtext.service.SingletonBinding;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;

@Beta
public class InjectionRecommender2
extends AbstractXtextGeneratorFragment {
    protected static final Logger LOG = Logger.getLogger(InjectionRecommender2.class.getName());
    private static final String CONFIGURE_PREFIX = "configure";
    private static final String BIND_PREFIX = "bind";
    @Inject
    private BindingFactory bindingFactory;
    private String name = ((Object)((Object)this)).getClass().getName();
    private String comment;
    private boolean enable = true;
    private boolean runtimeEnable = true;
    private boolean uiEnable = true;

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setShowRuntimeRecommendations(boolean enable) {
        this.runtimeEnable = enable;
    }

    public boolean isShowRuntimeRecommendations() {
        return this.runtimeEnable;
    }

    public void setShowUiRecommendations(boolean enable) {
        this.uiEnable = enable;
    }

    public boolean isShowUiRecommendations() {
        return this.uiEnable;
    }

    public void setComment(String comment) {
        this.comment = comment;
        this.name = !Strings.isEmpty((String)comment) ? MessageFormat.format("{0} [{1}]", ((Object)((Object)this)).getClass().getName(), comment) : ((Object)((Object)this)).getClass().getName();
    }

    @Pure
    public String getName() {
        return this.name;
    }

    @Pure
    public String getComment() {
        return this.comment;
    }

    private static String getTypeName(Class<?> type) {
        if (type.getEnclosingClass() != null) {
            return type.getEnclosingClass().getName() + "$" + type.getSimpleName();
        }
        return type.getName();
    }

    protected static boolean isIgnorableType(String typeName) {
        return "FileExtensions".equals(typeName) || "LanguageName".equals(typeName);
    }

    private static void fillFrom(Set<BindingElement> bindings, Class<?> type) {
        for (Method declaredMethod : type.getDeclaredMethods()) {
            String typeName;
            String methodName = declaredMethod.getName();
            if (Strings.isEmpty((String)methodName) || (methodName.length() <= CONFIGURE_PREFIX.length() || !methodName.startsWith(CONFIGURE_PREFIX)) && (methodName.length() <= BIND_PREFIX.length() || !methodName.startsWith(BIND_PREFIX))) continue;
            if (declaredMethod.getReturnType() != null && !Void.TYPE.equals(declaredMethod.getReturnType())) {
                String typeName2;
                Class<?> returnType = declaredMethod.getReturnType();
                if (returnType.equals(Class.class)) {
                    typeName2 = declaredMethod.getGenericReturnType().getTypeName();
                    typeName2 = typeName2.replaceFirst("^.*?Class<\\?\\s+extends\\s+", "");
                    typeName2 = typeName2.replaceFirst(">$", "");
                } else {
                    typeName2 = InjectionRecommender2.getTypeName(returnType);
                }
                if (Strings.isEmpty((String)typeName2) || InjectionRecommender2.isIgnorableType(typeName2)) continue;
                BindingElement element = new BindingElement();
                element.setBind(typeName2);
                element.setTo(Object.class.getName());
                SingletonBinding singleton = declaredMethod.getAnnotation(SingletonBinding.class);
                if (singleton != null) {
                    element.setSingleton(true);
                    element.setEager(singleton.eager());
                }
                bindings.add(element);
                continue;
            }
            if (!methodName.startsWith(CONFIGURE_PREFIX) || Strings.isEmpty((String)(typeName = methodName.substring(CONFIGURE_PREFIX.length()))) || InjectionRecommender2.isIgnorableType(typeName)) continue;
            BindingElement element = new BindingElement();
            element.setBind(typeName);
            element.setTo(Object.class.getName());
            element.setFunctionName(methodName);
            bindings.add(element);
        }
    }

    protected void recommendFrom(String label, Set<BindingElement> source, Set<GuiceModuleAccess.Binding> current) {
        this.bindingFactory.setName(this.getName());
        boolean hasRecommend = false;
        for (BindingElement sourceElement : source) {
            GuiceModuleAccess.Binding wrapElement = this.bindingFactory.toBinding(sourceElement);
            if (current.contains(wrapElement)) continue;
            if (!hasRecommend) {
                LOG.info(MessageFormat.format("Begin recommendations for {0}", label));
                hasRecommend = true;
            }
            LOG.warning(MessageFormat.format("\t{1}", label, sourceElement.getKeyString()));
        }
        if (hasRecommend) {
            LOG.info(MessageFormat.format("End recommendations for {0}", label));
        } else {
            LOG.info(MessageFormat.format("No recommendation for {0}", label));
        }
    }

    protected void recommend(Class<?> superModule, GuiceModuleAccess currentModuleAccess) {
        LOG.info(MessageFormat.format("Building injection configuration from {0}", superModule.getName()));
        LinkedHashSet<BindingElement> superBindings = new LinkedHashSet<BindingElement>();
        InjectionRecommender2.fillFrom(superBindings, superModule.getSuperclass());
        InjectionRecommender2.fillFrom(superBindings, superModule);
        Set currentBindings = currentModuleAccess.getBindings();
        this.recommendFrom(superModule.getName(), superBindings, currentBindings);
    }

    public void generate() {
        if (this.isEnable()) {
            if (this.isShowRuntimeRecommendations()) {
                this.recommend(XtendRuntimeModule.class, this.getLanguage().getRuntimeGenModule());
            }
            if (this.isShowUiRecommendations()) {
                this.recommend(XtendIdeModule.class, this.getLanguage().getIdeGenModule());
            }
        }
    }
}

