/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.mwe2.codebuilder;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.mwe2.codebuilder.extractor.CodeElementExtractor;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractAppenderBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractBuilderBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.AbstractSubCodeBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.BuilderFactoryFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.DocumentationBuilderFragment;
import io.sarl.lang.mwe2.codebuilder.fragments.ScriptBuilderFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.AbstractStubGeneratingFragment;
import org.eclipse.xtext.xtext.generator.IXtextGeneratorFragment;
import org.eclipse.xtext.xtext.generator.Issues;
import org.eclipse.xtext.xtext.generator.model.GuiceModuleAccess;

public class CodeBuilderFragment2
extends AbstractStubGeneratingFragment {
    private static final Logger LOG = Logger.getLogger(CodeBuilderFragment2.class);
    private Collection<AbstractSubCodeBuilderFragment> subFragments;
    @Inject
    private CodeElementExtractor grammarExtractor;

    @Pure
    public String getLanguageName() {
        return Strings.toFirstUpper((String)GrammarUtil.getSimpleName((Grammar)this.getGrammar()).toLowerCase());
    }

    public void initialize(Injector injector) {
        super.initialize(injector);
        this.grammarExtractor.initialize(this.getGrammar());
        this.subFragments = this.initializeSubGenerators(injector);
        for (IXtextGeneratorFragment iXtextGeneratorFragment : this.subFragments) {
            iXtextGeneratorFragment.initialize(injector);
        }
    }

    protected Collection<AbstractSubCodeBuilderFragment> initializeSubGenerators(Injector injector) {
        ArrayList<AbstractSubCodeBuilderFragment> fragments = new ArrayList<AbstractSubCodeBuilderFragment>();
        fragments.add((AbstractSubCodeBuilderFragment)((Object)injector.getInstance(BuilderFactoryFragment.class)));
        fragments.add((AbstractSubCodeBuilderFragment)((Object)injector.getInstance(DocumentationBuilderFragment.class)));
        fragments.add((AbstractSubCodeBuilderFragment)((Object)injector.getInstance(AbstractBuilderBuilderFragment.class)));
        fragments.add((AbstractSubCodeBuilderFragment)((Object)injector.getInstance(AbstractAppenderBuilderFragment.class)));
        fragments.add((AbstractSubCodeBuilderFragment)((Object)injector.getInstance(ScriptBuilderFragment.class)));
        return fragments;
    }

    public void checkConfiguration(Issues issues) {
        super.checkConfiguration(issues);
        if (this.subFragments == null) {
            issues.addError("Sub generators are not created");
        } else {
            for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
                subFragment.checkConfiguration(issues);
            }
        }
    }

    public void generate() {
        LOG.info((Object)("Generating the code builder for " + this.getLanguageName()));
        BuilderFactoryFragment fragment = null;
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            if (subFragment instanceof BuilderFactoryFragment) {
                BuilderFactoryFragment cvalue;
                fragment = cvalue = (BuilderFactoryFragment)subFragment;
                continue;
            }
            subFragment.generate();
        }
        if (fragment != null) {
            fragment.generate();
        }
        if (this.isGenerateStub()) {
            if (this.isGenerateXtendStub()) {
                for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
                    subFragment.generateXtendStubs();
                }
            } else {
                for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
                    subFragment.generateJavaStubs();
                }
            }
        }
        this.createRuntimeBindings().contributeTo(this.getLanguage().getRuntimeGenModule());
        this.createEclipseBindings().contributeTo(this.getLanguage().getEclipsePluginGenModule());
        this.createIdeaBindings().contributeTo(this.getLanguage().getIdeGenModule());
        this.createWebBindings().contributeTo(this.getLanguage().getWebGenModule());
        Set exportedPackages = this.getProjectConfig().getRuntime().getManifest().getExportedPackages();
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.getExportedPackages(exportedPackages);
        }
    }

    protected GuiceModuleAccess.BindingFactory createRuntimeBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateRuntimeBindings(factory);
        }
        return factory;
    }

    protected GuiceModuleAccess.BindingFactory createEclipseBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateEclipseBindings(factory);
        }
        return factory;
    }

    protected GuiceModuleAccess.BindingFactory createIdeaBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateIdeaBindings(factory);
        }
        return factory;
    }

    protected GuiceModuleAccess.BindingFactory createWebBindings() {
        GuiceModuleAccess.BindingFactory factory = new GuiceModuleAccess.BindingFactory(((Object)((Object)this)).getClass().getName());
        for (AbstractSubCodeBuilderFragment subFragment : this.subFragments) {
            subFragment.generateWebBindings(factory);
        }
        return factory;
    }
}

